/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.sourceforge.plantuml.code.AsciiEncoder;

public class SignatureUtils {
    public static byte[] salting(String pass, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        int iterations = 10000;
        int keyLength = 512;
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(pass.toCharArray(), salt, 10000, 512);
        SecretKey key = skf.generateSecret(spec);
        byte[] tmp = key.getEncoded();
        return tmp;
    }

    public static String getSignature(String s) {
        try {
            byte[] digest = SignatureUtils.getMD5raw(s);
            return SignatureUtils.toString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    public static String toString(byte[] data) {
        AsciiEncoder coder = new AsciiEncoder();
        return coder.encode(data);
    }

    public static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte b : data) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String getMD5Hex(String s) {
        try {
            byte[] digest = SignatureUtils.getMD5raw(s);
            assert (digest.length == 16);
            return SignatureUtils.toHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    public static String getSHA512Hex(String s) {
        try {
            byte[] digest = SignatureUtils.getSHA512raw(s);
            assert (digest.length == 64);
            return SignatureUtils.toHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    public static byte[] getMD5raw(String s) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest msgDigest = MessageDigest.getInstance("MD5");
        msgDigest.update(s.getBytes("UTF-8"));
        return msgDigest.digest();
    }

    public static byte[] getSHA512raw(String s) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return SignatureUtils.getSHA512raw(s.getBytes("UTF-8"));
    }

    public static byte[] getSHA512raw(byte[] data) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest msgDigest = MessageDigest.getInstance("SHA-512");
        msgDigest.update(data);
        return msgDigest.digest();
    }

    public static String getSignatureSha512(File f) throws IOException {
        FileInputStream is = new FileInputStream(f);
        try {
            String string = SignatureUtils.getSignatureSha512(is);
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static String getSignatureSha512(InputStream is) throws IOException {
        try {
            MessageDigest msgDigest = MessageDigest.getInstance("SHA-512");
            int read = 0;
            while ((read = is.read()) != -1) {
                msgDigest.update((byte)read);
            }
            byte[] digest = msgDigest.digest();
            return SignatureUtils.toString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    public static String getSignatureWithoutImgSrc(String s) {
        s = SignatureUtils.getSignature(SignatureUtils.purge(s));
        return s;
    }

    public static String purge(String s) {
        String regex = "(?i)\\<img\\s+src=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"/\\>";
        s = s.replaceAll("(?i)\\<img\\s+src=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"/\\>", "<img src=\"$1$2\"/>");
        String regex2 = "(?i)image=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"";
        s = s.replaceAll("(?i)image=\"(?:[^\"]+[/\\\\])?([^/\\\\\\d.]+)\\d*(\\.\\w+)\"", "image=\"$1$2\"");
        return s;
    }

    public static String getSignature(File f) throws IOException {
        try {
            MessageDigest msgDigest = MessageDigest.getInstance("MD5");
            FileInputStream is = new FileInputStream(f);
            int read = -1;
            while ((read = is.read()) != -1) {
                msgDigest.update((byte)read);
            }
            is.close();
            byte[] digest = msgDigest.digest();
            return SignatureUtils.toString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }
}

