/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.SnakeDirection;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Worm
implements Iterable<Point2D.Double> {
    private final List<Point2D.Double> points = new ArrayList<Point2D.Double>();

    public boolean isPureHorizontal() {
        return this.points.size() == 2 && this.points.get(0).getY() == this.points.get(1).getY();
    }

    public void drawInternalOneColor(UGraphic ug, HtmlColorAndStyle color, double stroke, Direction emphasizeDirection, UPolygon endDecoration) {
        HtmlColor color2 = color.getColor();
        if (color2 == null) {
            throw new IllegalArgumentException();
        }
        LinkStyle style = color.getStyle();
        if (style.isInvisible()) {
            return;
        }
        ug = ug.apply(new UChangeColor(color2));
        ug = ug.apply(new UChangeBackColor(color2));
        ug = style.isNormal() ? ug.apply(new UStroke(stroke)) : ug.apply(style.goThickness(stroke).getStroke3());
        boolean drawn = false;
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D.Double p1 = this.points.get(i);
            Point2D.Double p2 = this.points.get(i + 1);
            Line2D.Double line = new Line2D.Double(p1, p2);
            if (!drawn && emphasizeDirection != null && Direction.fromVector(p1, p2) == emphasizeDirection) {
                this.drawLine(ug, line, emphasizeDirection);
                drawn = true;
                continue;
            }
            this.drawLine(ug, line, null);
        }
        if (endDecoration != null) {
            ug = ug.apply(new UStroke(1.5));
            Point2D end = this.points.get(this.points.size() - 1);
            ug.apply(new UTranslate(end)).apply(new UStroke()).draw(endDecoration);
        }
    }

    private void drawLine(UGraphic ug, Line2D line, Direction direction) {
        this.drawLine(ug, line.getX1(), line.getY1(), line.getX2(), line.getY2(), direction);
    }

    private void drawLine(UGraphic ug, double x1, double y1, double x2, double y2, Direction direction) {
        ug = ug.apply(new UTranslate(x1, y1));
        if (direction != null) {
            ug.apply(new UTranslate((x2 - x1) / 2.0, (y2 - y1) / 2.0)).draw(Arrows.asTo(direction));
        }
        ug.draw(new ULine(x2 - x1, y2 - y1));
    }

    public Worm move(double dx, double dy) {
        Worm result = new Worm();
        for (Point2D point2D : this.points) {
            result.addPoint(point2D.getX() + dx, point2D.getY() + dy);
        }
        return result;
    }

    public Worm moveFirstPoint(UTranslate move) {
        double dx = move.getDx();
        double dy = move.getDy();
        if (dx != 0.0 && dy != 0.0) {
            throw new IllegalArgumentException("move=" + move);
        }
        Worm result = new Worm();
        double x0 = this.points.get(0).getX();
        double y0 = this.points.get(0).getY();
        double x1 = this.points.get(1).getX();
        double y1 = this.points.get(1).getY();
        if (dx != 0.0 && x0 == x1) {
            x1 += dx;
        }
        if (dy != 0.0 && y0 == y1) {
            y1 += dy;
        }
        result.addPoint(x0 += dx, y0 += dy);
        result.addPoint(x1, y1);
        for (int i = 2; i < this.points.size(); ++i) {
            result.addPoint(this.points.get(i));
        }
        return result;
    }

    public Worm moveLastPoint(UTranslate move) {
        double dx = move.getDx();
        double dy = move.getDy();
        if (dx != 0.0 && dy != 0.0) {
            throw new IllegalArgumentException("move=" + move);
        }
        Worm result = new Worm();
        double x8 = this.points.get(this.points.size() - 2).getX();
        double y8 = this.points.get(this.points.size() - 2).getY();
        double x9 = this.points.get(this.points.size() - 1).getX();
        double y9 = this.points.get(this.points.size() - 1).getY();
        if (dx != 0.0 && x8 == x9) {
            x8 += dx;
        }
        if (dy != 0.0 && y8 == y9) {
            y8 += dy;
        }
        x9 += dx;
        y9 += dy;
        for (int i = 0; i < this.points.size() - 2; ++i) {
            result.addPoint(this.points.get(i));
        }
        result.addPoint(x8, y8);
        result.addPoint(x9, y9);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            result.append((Object)((Object)this.getDirectionAtPoint(i)) + " ");
        }
        return result + this.points.toString();
    }

    public void addPoint(double x, double y) {
        this.points.add(new Point2D.Double(x, y));
    }

    public void addPoint(Point2D pt) {
        this.addPoint(pt.getX(), pt.getY());
    }

    public Worm translate(UTranslate translate) {
        return this.move(translate.getDx(), translate.getDy());
    }

    SnakeDirection getDirection() {
        if (this.points.size() < 2) {
            throw new IllegalStateException();
        }
        return SnakeDirection.getDirection(this.points.get(0), this.points.get(1));
    }

    String getDirectionsCode() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Direction direction = Direction.fromVector(this.points.get(i), this.points.get(i + 1));
            result.append(direction.getShortCode());
        }
        return result.toString();
    }

    private List<Direction> getPatternAt(int i) {
        return Arrays.asList(this.getDirectionAtPoint(i), this.getDirectionAtPoint(i + 1), this.getDirectionAtPoint(i + 2), this.getDirectionAtPoint(i + 3));
    }

    private boolean isForwardAndBackwardAt(int i) {
        return this.getDirectionAtPoint(i) == this.getDirectionAtPoint(i + 1).getInv();
    }

    private Direction getDirectionAtPoint(int i) {
        return Direction.fromVector(this.points.get(i), this.points.get(i + 1));
    }

    @Override
    public Iterator<Point2D.Double> iterator() {
        return Collections.unmodifiableCollection(this.points).iterator();
    }

    public boolean doesHorizontalCross(MinMax area) {
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D.Double pt1 = this.get(i);
            Point2D.Double pt2 = this.get(i + 1);
            if (pt1.getY() != pt2.getY() || !area.doesHorizontalCross(pt1, pt2)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.points.size();
    }

    public Point2D.Double get(int i) {
        return this.points.get(i);
    }

    public void addAll(Worm other) {
        this.points.addAll(other.points);
    }

    public void remove(int i) {
        this.points.remove(i);
    }

    public void add(int i, Point2D.Double pt) {
        this.points.add(i, pt);
    }

    private Point2D getFirst() {
        return this.points.get(0);
    }

    public Point2D getLast() {
        return this.points.get(this.points.size() - 1);
    }

    public Worm merge(Worm other, MergeStrategy merge) {
        if (!Snake.same(this.getLast(), other.getFirst())) {
            throw new IllegalArgumentException();
        }
        Worm result = new Worm();
        result.points.addAll(this.points);
        result.points.addAll(other.points);
        result.mergeMe(merge);
        return result;
    }

    private void mergeMe(MergeStrategy merge) {
        boolean change = false;
        do {
            change = (change = false) || this.removeNullVector();
            change = change || this.removeRedondantDirection();
            change = change || this.removePattern1();
            change = change || this.removePattern2();
            change = change || this.removePattern3();
            change = change || this.removePattern4();
            change = change || this.removePattern5();
            change = change || this.removePattern6();
            boolean bl = change = change || this.removePattern7();
            if (merge != MergeStrategy.FULL) continue;
            boolean bl2 = change = change || this.removePattern8();
        } while (change);
    }

    private boolean removeNullVector() {
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Direction dir = this.getDirectionAtPoint(i);
            if (dir != null) continue;
            this.points.remove(i);
            return true;
        }
        return false;
    }

    private boolean removeRedondantDirection() {
        for (int i = 0; i < this.points.size() - 2; ++i) {
            Direction dir2;
            Direction dir1 = this.getDirectionAtPoint(i);
            if (dir1 != (dir2 = this.getDirectionAtPoint(i + 1))) continue;
            this.points.remove(i + 1);
            return true;
        }
        return false;
    }

    private boolean removePattern1() {
        for (int i = 0; i < this.points.size() - 5; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.RIGHT).equals(patternAt) && !Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT).equals(patternAt)) continue;
            Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }

    private boolean removePattern7() {
        if (this.points.size() > 4) {
            boolean i = false;
            List<Direction> patternAt = this.getPatternAt(0);
            if (Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.LEFT, Direction.DOWN).equals(patternAt) && this.points.get((int)3).x > this.points.get((int)0).x) {
                Point2D.Double newPoint = new Point2D.Double(this.points.get((int)3).x, this.points.get((int)0).y);
                this.points.remove(2);
                this.points.remove(1);
                this.points.add(1, newPoint);
                return true;
            }
        }
        return false;
    }

    private boolean removePattern2() {
        for (int i = 0; i < this.points.size() - 5; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.RIGHT, Direction.UP).equals(patternAt) && !Arrays.asList(Direction.LEFT, Direction.DOWN, Direction.LEFT, Direction.UP).equals(patternAt)) continue;
            Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 3)).x, this.points.get((int)(i + 1)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }

    private boolean removePattern3() {
        for (int i = 0; i < this.points.size() - 4; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.RIGHT).equals(patternAt) && !Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.LEFT).equals(patternAt)) continue;
            Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }

    private boolean removePattern4() {
        int i = this.points.size() - 5;
        if (i >= 0) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.RIGHT).equals(patternAt)) {
                Point2D.Double p1 = this.points.get(i + 1);
                Point2D.Double p4 = this.points.get(i + 4);
                if (p4.x > p1.x) {
                    Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
                    this.points.remove(i + 3);
                    this.points.remove(i + 2);
                    this.points.remove(i + 1);
                    this.points.add(i + 1, newPoint);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removePattern5() {
        int i = this.points.size() - 5;
        if (i >= 0) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT).equals(patternAt)) {
                Point2D.Double p1 = this.points.get(i + 1);
                Point2D.Double p4 = this.points.get(i + 4);
                if (p4.x + 4.0 < p1.x) {
                    Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
                    this.points.remove(i + 3);
                    this.points.remove(i + 2);
                    this.points.remove(i + 1);
                    this.points.add(i + 1, newPoint);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removePattern6() {
        for (int i = 0; i < this.points.size() - 2; ++i) {
            if (!this.isForwardAndBackwardAt(i)) continue;
            this.points.remove(i + 1);
            return true;
        }
        return false;
    }

    private boolean removePattern8() {
        for (int i = 0; i < this.points.size() - 4; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.LEFT, Direction.DOWN, Direction.LEFT, Direction.DOWN).equals(patternAt) && !Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.RIGHT, Direction.DOWN).equals(patternAt)) continue;
            Point2D.Double newPoint = new Point2D.Double(this.points.get((int)(i + 3)).x, this.points.get((int)(i + 1)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }
}

