/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.LeafType;

class JavaClass {
    private final String name;
    private final String javaPackage;
    private final List<String> parents = new ArrayList<String>();
    private final LeafType type;
    private final LeafType parentType;

    public JavaClass(String javaPackage, String name, String p, LeafType type, LeafType parentType) {
        this.name = name;
        this.javaPackage = javaPackage;
        if (p == null) {
            p = "";
        }
        StringTokenizer st = new StringTokenizer(StringUtils.trin(p), ",");
        while (st.hasMoreTokens()) {
            this.parents.add(StringUtils.trin(st.nextToken()).replaceAll("\\<.*", ""));
        }
        this.type = type;
        this.parentType = parentType;
    }

    public final String getName() {
        return this.name;
    }

    public final LeafType getType() {
        return this.type;
    }

    public final List<String> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public final LeafType getParentType() {
        return this.parentType;
    }

    public final String getJavaPackage() {
        return this.javaPackage;
    }
}

