/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.ScaleSimple;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;

public class CommandScale
extends SingleLineCommand<AbstractPSystem> {
    public CommandScale() {
        super("(?i)^scale[%s]+([0-9.]+)(?:[%s]*/[%s]*([0-9.]+))?$");
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractPSystem diagram, List<String> arg) {
        double scale = Double.parseDouble(arg.get(0));
        if (scale == 0.0) {
            return CommandExecutionResult.error("Scale cannot be zero");
        }
        if (arg.get(1) != null) {
            double div = Double.parseDouble(arg.get(1));
            if (div == 0.0) {
                return CommandExecutionResult.error("Scale cannot be zero");
            }
            scale /= div;
        }
        diagram.setScale(new ScaleSimple(scale));
        return CommandExecutionResult.ok();
    }
}

