/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class AtomVerticalTexts
implements Atom {
    private final List<Atom> all;

    public AtomVerticalTexts(List<Atom> texts) {
        this.all = texts;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (Atom text : this.all) {
            Dimension2D dim = text.calculateDimension(stringBounder);
            width = Math.max(width, dim.getWidth());
            height += dim.getHeight();
        }
        return new Dimension2DDouble(width, height);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return this.all.get(0).getStartingAltitude(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        double y = 0.0;
        for (Atom text : this.all) {
            Dimension2D dim = text.calculateDimension(ug.getStringBounder());
            text.drawU(ug.apply(new UTranslate(0.0, y)));
            y += dim.getHeight();
        }
    }
}

