/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.DisplaySection;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PngTitler {
    private final HtmlColor textColor;
    private final HtmlColor hyperlinkColor;
    private final DisplaySection text;
    private final int fontSize;
    private final String fontFamily;
    private final boolean useUnderlineForHyperlink;

    public PngTitler(HtmlColor textColor, DisplaySection text, int fontSize, String fontFamily, HtmlColor hyperlinkColor, boolean useUnderlineForHyperlink) {
        this.textColor = textColor;
        this.text = text;
        this.fontSize = fontSize;
        this.fontFamily = fontFamily;
        this.hyperlinkColor = hyperlinkColor;
        this.useUnderlineForHyperlink = useUnderlineForHyperlink;
    }

    public Dimension2D getTextDimension(StringBounder stringBounder) {
        TextBlock textBloc = this.getRibbonBlock();
        if (textBloc == null) {
            return null;
        }
        return textBloc.calculateDimension(stringBounder);
    }

    public TextBlock getRibbonBlock() {
        UFont normalFont = new UFont(this.fontFamily, 0, this.fontSize);
        return this.text.createRibbon(new FontConfiguration(normalFont, this.textColor, this.hyperlinkColor, this.useUnderlineForHyperlink), new SpriteContainerEmpty());
    }

    private double getOffsetX(double imWidth, StringBounder stringBounder) {
        TextBlock textBloc = this.getRibbonBlock();
        if (textBloc == null) {
            return 0.0;
        }
        Dimension2D dimText = textBloc.calculateDimension(stringBounder);
        if (imWidth >= dimText.getWidth()) {
            return 0.0;
        }
        return (dimText.getWidth() - imWidth) / 2.0;
    }

    private double getOffsetY(StringBounder stringBounder) {
        TextBlock textBloc = this.getRibbonBlock();
        if (textBloc == null) {
            return 0.0;
        }
        Dimension2D dimText = textBloc.calculateDimension(stringBounder);
        double height = dimText.getHeight();
        return height;
    }
}

