/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.BaseFile;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.SkinParamForecolored;
import net.sourceforge.plantuml.SkinParamSameClassWidth;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.ExeState;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.descdiagram.EntityImageDesignedDomain;
import net.sourceforge.plantuml.descdiagram.EntityImageDomain;
import net.sourceforge.plantuml.descdiagram.EntityImageMachine;
import net.sourceforge.plantuml.descdiagram.EntityImageRequirement;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.EntityImageProtected;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.SvekResult;
import net.sourceforge.plantuml.svek.image.EntityImageActivity;
import net.sourceforge.plantuml.svek.image.EntityImageArcCircle;
import net.sourceforge.plantuml.svek.image.EntityImageAssociation;
import net.sourceforge.plantuml.svek.image.EntityImageAssociationPoint;
import net.sourceforge.plantuml.svek.image.EntityImageBranch;
import net.sourceforge.plantuml.svek.image.EntityImageCircleEnd;
import net.sourceforge.plantuml.svek.image.EntityImageCircleStart;
import net.sourceforge.plantuml.svek.image.EntityImageClass;
import net.sourceforge.plantuml.svek.image.EntityImageDescription;
import net.sourceforge.plantuml.svek.image.EntityImageEmptyPackage;
import net.sourceforge.plantuml.svek.image.EntityImageGroup;
import net.sourceforge.plantuml.svek.image.EntityImageLollipopInterface;
import net.sourceforge.plantuml.svek.image.EntityImageNote;
import net.sourceforge.plantuml.svek.image.EntityImageObject;
import net.sourceforge.plantuml.svek.image.EntityImagePseudoState;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageState2;
import net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import net.sourceforge.plantuml.svek.image.EntityImageStateEmptyDescription;
import net.sourceforge.plantuml.svek.image.EntityImageSynchroBar;
import net.sourceforge.plantuml.svek.image.EntityImageTips;
import net.sourceforge.plantuml.svek.image.EntityImageUseCase;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;

public final class GeneralImageBuilder {
    private final DotData dotData;
    private final EntityFactory entityFactory;
    private final UmlSource source;
    private final Pragma pragma;
    private Map<Code, Double> maxX;
    private final StringBounder stringBounder;

    public GeneralImageBuilder(DotData dotData, EntityFactory entityFactory, UmlSource source, Pragma pragma, StringBounder stringBounder) {
        this.dotData = dotData;
        this.entityFactory = entityFactory;
        this.source = source;
        this.pragma = pragma;
        this.stringBounder = stringBounder;
    }

    public IEntityImage buildImage(BaseFile basefile, String[] dotStrings) {
        String svg;
        this.dotData.removeIrrelevantSametail();
        DotStringFactory dotStringFactory = new DotStringFactory(this.stringBounder, this.dotData);
        this.printGroups(dotStringFactory, this.dotData.getRootGroup());
        this.printEntities(dotStringFactory, this.getUnpackagedEntities());
        for (Link link : this.dotData.getLinks()) {
            if (link.isRemoved()) continue;
            try {
                Shape other;
                Shape shape;
                ISkinParam skinParam = this.dotData.getSkinParam();
                FontConfiguration labelFont = new FontConfiguration(skinParam, FontParam.ARROW, null);
                Line line = new Line(link, dotStringFactory.getColorSequence(), skinParam, this.stringBounder, labelFont, dotStringFactory.getBibliotekon(), this.dotData.getPragma());
                dotStringFactory.getBibliotekon().addLine(line);
                if (!link.getEntity1().isGroup() && link.getEntity1().getLeafType() == LeafType.NOTE && this.onlyOneLink(link.getEntity1())) {
                    shape = dotStringFactory.getBibliotekon().getShape(link.getEntity1());
                    other = dotStringFactory.getBibliotekon().getShape(link.getEntity2());
                    if (other == null) continue;
                    ((EntityImageNote)shape.getImage()).setOpaleLine(line, shape, other);
                    line.setOpale(true);
                    continue;
                }
                if (link.getEntity2().isGroup() || link.getEntity2().getLeafType() != LeafType.NOTE || !this.onlyOneLink(link.getEntity2())) continue;
                shape = dotStringFactory.getBibliotekon().getShape(link.getEntity2());
                other = dotStringFactory.getBibliotekon().getShape(link.getEntity1());
                if (other == null) continue;
                ((EntityImageNote)shape.getImage()).setOpaleLine(line, shape, other);
                line.setOpale(true);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        if (dotStringFactory.illegalDotExe()) {
            return this.error(dotStringFactory.getDotExe());
        }
        if (basefile == null && this.isSvekTrace()) {
            basefile = new BaseFile();
        }
        try {
            svg = dotStringFactory.getSvg(basefile, dotStrings);
        }
        catch (IOException e) {
            return new GraphvizCrash(this.source.getPlainString());
        }
        if (svg.length() == 0) {
            return new GraphvizCrash(this.source.getPlainString());
        }
        String graphvizVersion = this.extractGraphvizVersion(svg);
        try {
            ClusterPosition position = dotStringFactory.solve(svg).delta(10.0, 10.0);
            double minY = position.getMinY();
            double minX = position.getMinX();
            if (minX > 0.0 || minY > 0.0) {
                throw new IllegalStateException();
            }
            SvekResult result = new SvekResult(position, this.dotData, dotStringFactory);
            result.moveSvek(6.0 - minX, -minY);
            this.maxX = dotStringFactory.getBibliotekon().getMaxX();
            return result;
        }
        catch (Exception e) {
            Log.error("Exception " + e);
            throw new UnparsableGraphvizException(e, graphvizVersion, svg, this.source.getPlainString());
        }
    }

    private boolean isSvekTrace() {
        String value = this.pragma.getValue("svek_trace");
        return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    private String extractGraphvizVersion(String svg) {
        Pattern pGraph = Pattern.compile("(?mi)!-- generated by graphviz(.*)");
        Matcher mGraph = pGraph.matcher(svg);
        if (mGraph.find()) {
            return StringUtils.trin(mGraph.group(1));
        }
        return null;
    }

    private boolean onlyOneLink(IEntity ent) {
        int nb = 0;
        for (Link link : this.dotData.getLinks()) {
            if (link.isInvis()) continue;
            if (link.contains(ent)) {
                ++nb;
            }
            if (nb <= 1) continue;
            return false;
        }
        return nb == 1;
    }

    private IEntityImage error(File dotExe) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("Dot Executable: " + dotExe);
        ExeState exeState = ExeState.checkFile(dotExe);
        msg.add(exeState.getTextMessage());
        msg.add("Cannot find Graphviz. You should try");
        msg.add(" ");
        msg.add("@startuml");
        msg.add("testdot");
        msg.add("@enduml");
        msg.add(" ");
        msg.add(" or ");
        msg.add(" ");
        msg.add("java -jar plantuml.jar -testdot");
        msg.add(" ");
        return GraphicStrings.createForError(msg, false);
    }

    private void printEntities(DotStringFactory dotStringFactory, Collection<ILeaf> entities2) {
        for (ILeaf ent : entities2) {
            if (ent.isRemoved()) continue;
            this.printEntity(dotStringFactory, ent);
        }
    }

    private void printEntity(DotStringFactory dotStringFactory, ILeaf ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage image = this.printEntityInternal(dotStringFactory, ent);
        Dimension2D dim = image.calculateDimension(this.stringBounder);
        Shape shape = new Shape(image, image.getShapeType(), dim.getWidth(), dim.getHeight(), dotStringFactory.getColorSequence(), ent.isTop(), image.getShield(this.stringBounder), ent.getEntityPosition());
        dotStringFactory.addShape(shape);
        dotStringFactory.getBibliotekon().putShape(ent, shape);
    }

    private IEntityImage printEntityInternal(DotStringFactory dotStringFactory, ILeaf ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.dotData.getSkinParam();
            if (skinParam.sameClassWidth()) {
                double width = this.getMaxWidth(dotStringFactory);
                skinParam = new SkinParamSameClassWidth(skinParam, width);
            }
            return GeneralImageBuilder.createEntityImageBlock(ent, skinParam, this.dotData.isHideEmptyDescriptionForState(), this.dotData, dotStringFactory.getBibliotekon(), dotStringFactory.getGraphvizVersion(), this.dotData.getUmlDiagramType(), this.dotData.getLinks());
        }
        return ent.getSvekImage();
    }

    private double getMaxWidth(DotStringFactory dotStringFactory) {
        double result = 0.0;
        for (ILeaf ent : this.dotData.getLeafs()) {
            EntityImageClass im;
            double w;
            if (!ent.getLeafType().isLikeClass() || !((w = (im = new EntityImageClass(dotStringFactory.getGraphvizVersion(), ent, this.dotData.getSkinParam(), this.dotData)).calculateDimension(this.stringBounder).getWidth()) > result)) continue;
            result = w;
        }
        return result;
    }

    public static IEntityImage createEntityImageBlock(ILeaf leaf, ISkinParam skinParam, boolean isHideEmptyDescriptionForState, PortionShower portionShower, Bibliotekon bibliotekon, GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType, Collection<Link> links) {
        if (leaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (leaf.getLeafType().isLikeClass()) {
            EntityImageClass entityImageClass = new EntityImageClass(graphvizVersion, leaf, skinParam, portionShower);
            Neighborhood neighborhood = leaf.getNeighborhood();
            if (neighborhood != null) {
                return new EntityImageProtected(entityImageClass, 20.0, neighborhood, bibliotekon);
            }
            return entityImageClass;
        }
        if (leaf.getLeafType() == LeafType.NOTE) {
            return new EntityImageNote(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.ACTIVITY) {
            return new EntityImageActivity(leaf, skinParam, bibliotekon);
        }
        if (leaf.getLeafType() == LeafType.STATE) {
            if (leaf.getEntityPosition() != EntityPosition.NORMAL) {
                Cluster stateParent = bibliotekon.getCluster(leaf.getParentContainer());
                return new EntityImageStateBorder(leaf, skinParam, stateParent, bibliotekon);
            }
            if (isHideEmptyDescriptionForState && leaf.getBodier().getFieldsToDisplay().size() == 0) {
                return new EntityImageStateEmptyDescription(leaf, skinParam);
            }
            if (leaf.getStereotype() != null && "<<sdlreceive>>".equals(leaf.getStereotype().getLabel(false))) {
                return new EntityImageState2(leaf, skinParam);
            }
            return new EntityImageState(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.CIRCLE_START) {
            ColorParam param = ColorParam.activityStart;
            if (umlDiagramType == UmlDiagramType.STATE) {
                param = ColorParam.stateStart;
            }
            return new EntityImageCircleStart(leaf, skinParam, param);
        }
        if (leaf.getLeafType() == LeafType.CIRCLE_END) {
            ColorParam param = ColorParam.activityEnd;
            if (umlDiagramType == UmlDiagramType.STATE) {
                param = ColorParam.stateEnd;
            }
            return new EntityImageCircleEnd(leaf, skinParam, param);
        }
        if (leaf.getLeafType() == LeafType.BRANCH || leaf.getLeafType() == LeafType.STATE_CHOICE) {
            return new EntityImageBranch(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.LOLLIPOP) {
            return new EntityImageLollipopInterface(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.CIRCLE) {
            return new EntityImageDescription(leaf, skinParam, portionShower, links);
        }
        if (leaf.getLeafType() == LeafType.DESCRIPTION) {
            return new EntityImageDescription(leaf, skinParam, portionShower, links);
        }
        if (leaf.getLeafType() == LeafType.USECASE) {
            return new EntityImageUseCase(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.OBJECT) {
            return new EntityImageObject(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.SYNCHRO_BAR || leaf.getLeafType() == LeafType.STATE_FORK_JOIN) {
            return new EntityImageSynchroBar(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.ARC_CIRCLE) {
            return new EntityImageArcCircle(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.POINT_FOR_ASSOCIATION) {
            return new EntityImageAssociationPoint(leaf, skinParam);
        }
        if (leaf.isGroup()) {
            return new EntityImageGroup(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.EMPTY_PACKAGE) {
            if (leaf.getUSymbol() != null) {
                HtmlColor black = SkinParamUtils.getColor(skinParam, leaf.getUSymbol().getColorParamBorder(), leaf.getStereotype());
                return new EntityImageDescription(leaf, new SkinParamForecolored(skinParam, black), portionShower, links);
            }
            return new EntityImageEmptyPackage(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.ASSOCIATION) {
            return new EntityImageAssociation(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.PSEUDO_STATE) {
            return new EntityImagePseudoState(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.TIPS) {
            return new EntityImageTips(leaf, skinParam, bibliotekon);
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isMachineOrSpecification()) {
            return new EntityImageMachine(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isDesignedOrSolved()) {
            return new EntityImageDesignedDomain(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.REQUIREMENT) {
            return new EntityImageRequirement(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isLexicalOrGiven()) {
            return new EntityImageDomain(leaf, skinParam, 'X');
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isCausal()) {
            return new EntityImageDomain(leaf, skinParam, 'C');
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isBiddableOrUncertain()) {
            return new EntityImageDomain(leaf, skinParam, 'B');
        }
        if (leaf.getLeafType() == LeafType.DOMAIN) {
            return new EntityImageDomain(leaf, skinParam, 'P');
        }
        throw new UnsupportedOperationException(leaf.getLeafType().toString());
    }

    private Collection<ILeaf> getUnpackagedEntities() {
        ArrayList<ILeaf> result = new ArrayList<ILeaf>();
        for (ILeaf ent : this.dotData.getLeafs()) {
            if (this.dotData.getTopParent() != ent.getParentContainer()) continue;
            result.add(ent);
        }
        return result;
    }

    private void printGroups(DotStringFactory dotStringFactory, IGroup parent) {
        for (IGroup g : this.dotData.getGroupHierarchy().getChildrenGroups(parent)) {
            if (g.isRemoved()) continue;
            if (this.dotData.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                ILeaf folder = this.entityFactory.createLeaf(g.getCode(), g.getDisplay(), LeafType.EMPTY_PACKAGE, g.getParentContainer(), null, this.dotData.getNamespaceSeparator());
                USymbol symbol = g.getUSymbol();
                folder.setUSymbol(symbol);
                folder.setStereotype(g.getStereotype());
                if (g.getUrl99() != null) {
                    folder.addUrl(g.getUrl99());
                }
                if (g.getColors(this.dotData.getSkinParam()).getColor(ColorType.BACK) == null) {
                    ColorParam param = symbol == null ? ColorParam.packageBackground : symbol.getColorParamBack();
                    HtmlColor c1 = this.dotData.getSkinParam().getHtmlColor(param, g.getStereotype(), false);
                    folder.setSpecificColorTOBEREMOVED(ColorType.BACK, c1 == null ? this.dotData.getSkinParam().getBackgroundColor() : c1);
                } else {
                    folder.setSpecificColorTOBEREMOVED(ColorType.BACK, g.getColors(this.dotData.getSkinParam()).getColor(ColorType.BACK));
                }
                this.printEntity(dotStringFactory, folder);
                continue;
            }
            this.printGroup(dotStringFactory, g);
        }
    }

    private void printGroup(DotStringFactory dotStringFactory, IGroup g) {
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        int titleAndAttributeWidth = 0;
        int titleAndAttributeHeight = 0;
        TextBlock title = this.getTitleBlock(g);
        TextBlock stereo = this.getStereoBlock(g);
        TextBlock stereoAndTitle = TextBlockUtils.mergeTB(stereo, title, HorizontalAlignment.CENTER);
        Dimension2D dimLabel = stereoAndTitle.calculateDimension(this.stringBounder);
        if (dimLabel.getWidth() > 0.0) {
            List<Member> members = g.getBodier().getFieldsToDisplay();
            AbstractTextBlock attribute = members.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(members, FontParam.STATE_ATTRIBUTE, this.dotData.getSkinParam(), g.getStereotype(), null);
            Dimension2D dimAttribute = attribute.calculateDimension(this.stringBounder);
            double attributeHeight = dimAttribute.getHeight();
            double attributeWidth = dimAttribute.getWidth();
            double marginForFields = attributeHeight > 0.0 ? 5.0 : 0.0;
            USymbol uSymbol = g.getUSymbol();
            int suppHeightBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppHeightBecauseOfShape();
            int suppWidthBecauseOfShape = uSymbol == null ? 0 : uSymbol.suppWidthBecauseOfShape();
            titleAndAttributeWidth = (int)Math.max(dimLabel.getWidth(), attributeWidth) + suppWidthBecauseOfShape;
            titleAndAttributeHeight = (int)(dimLabel.getHeight() + attributeHeight + marginForFields + (double)suppHeightBecauseOfShape);
        }
        dotStringFactory.openCluster(g, titleAndAttributeWidth, titleAndAttributeHeight, title, stereo);
        this.printEntities(dotStringFactory, g.getLeafsDirect());
        this.printGroups(dotStringFactory, g);
        dotStringFactory.closeCluster();
    }

    private TextBlock getTitleBlock(IGroup g) {
        Display label = g.getDisplay();
        if (label == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        ISkinParam skinParam = this.dotData.getSkinParam();
        FontConfiguration fontConfiguration = g.getFontConfigurationForTitle(skinParam);
        return label.create(fontConfiguration, HorizontalAlignment.CENTER, skinParam);
    }

    private TextBlock getStereoBlock(IGroup g) {
        Sprite tmp;
        Stereotype stereotype = g.getStereotype();
        if (stereotype == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        if (stereotype.getSprite() != null && (tmp = this.dotData.getSkinParam().getSprite(stereotype.getSprite())) != null) {
            return tmp.asTextBlock(stereotype.getHtmlColor(), 1.0);
        }
        List<String> stereos = stereotype.getLabels(this.dotData.getSkinParam().useGuillemet());
        if (stereos == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        boolean show = this.dotData.showPortion(EntityPortion.STEREOTYPE, g);
        if (!show) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        FontParam fontParam = FontParam.PACKAGE_STEREOTYPE;
        return Display.create(stereos).create(new FontConfiguration(this.dotData.getSkinParam(), fontParam, stereotype), HorizontalAlignment.CENTER, this.dotData.getSkinParam());
    }

    public String getWarningOrError(int warningOrError) {
        if (this.maxX == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Code, Double> ent : this.maxX.entrySet()) {
            if (!(ent.getValue() > (double)warningOrError)) continue;
            sb.append(ent.getKey() + " is overpassing the width limit.");
            sb.append("\n");
        }
        return sb.length() == 0 ? "" : sb.toString();
    }
}

