/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.List;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.style.ISkinSimple;

public class ElementRadioCheckbox
extends AbstractElement {
    private static final int RECTANGLE = 10;
    private static final int ELLIPSE = 10;
    private static final int ELLIPSE2 = 4;
    private final TextBlock block;
    private final int margin = 20;
    private final double stroke = 1.5;
    private final boolean radio;
    private final boolean checked;

    public ElementRadioCheckbox(List<String> text, UFont font, boolean radio, boolean checked, ISkinSimple spriteContainer) {
        FontConfiguration config = FontConfiguration.blackBlueTrue(font);
        this.block = Display.create(text).create(config, HorizontalAlignment.LEFT, spriteContainer);
        this.radio = radio;
        this.checked = checked;
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        XDimension2D dim = this.block.calculateDimension(stringBounder);
        return dim.delta(20.0, 0.0);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        if (zIndex != 0) {
            return;
        }
        ug = ug.apply(this.getBlack());
        this.block.drawU(ug.apply(UTranslate.dx(20.0)));
        XDimension2D dim = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        double height = dim.getHeight();
        ug = ug.apply(UStroke.withThickness(1.5));
        if (this.radio) {
            this.drawRadio(ug, height);
        } else {
            this.drawOther(ug, height);
        }
    }

    private void drawOther(UGraphic ug, double height) {
        ug.apply(new UTranslate(2.0, (height - 10.0) / 2.0)).draw(URectangle.build(10.0, 10.0));
        if (this.checked) {
            UPolygon poly = new UPolygon();
            poly.addPoint(0.0, 0.0);
            poly.addPoint(3.0, 3.0);
            poly.addPoint(10.0, -6.0);
            poly.addPoint(3.0, 1.0);
            ug = ug.apply(HColors.changeBack(ug));
            ug = ug.apply(new UTranslate(3.0, 6.0));
            ug.draw(poly);
        }
    }

    private void drawRadio(UGraphic ug, double height) {
        ug.apply(new UTranslate(2.0, (height - 10.0) / 2.0)).draw(UEllipse.build(10.0, 10.0));
        if (this.checked) {
            ug = ug.apply(HColors.changeBack(ug));
            ug = ug.apply(new UTranslate(5.0, (height - 4.0) / 2.0));
            ug.draw(UEllipse.build(4.0, 4.0));
        }
    }
}

