/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.asciiart.BasicCharArea;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.geom.LineSegmentDouble;
import net.sourceforge.plantuml.posimo.BezierUtils;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableUtils;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.MinFinder;
import net.sourceforge.plantuml.svek.PointAndAngle;
import net.sourceforge.plantuml.svek.PointDirected;
import net.sourceforge.plantuml.svek.SvgResult;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DotPath
implements UShape,
Moveable {
    private final List<CubicCurve2D.Double> beziers = new ArrayList<CubicCurve2D.Double>();
    private String comment;

    public DotPath() {
        this(new ArrayList<CubicCurve2D.Double>());
    }

    public DotPath(DotPath other) {
        this(new ArrayList<CubicCurve2D.Double>());
        for (CubicCurve2D.Double c : other.beziers) {
            this.beziers.add(new CubicCurve2D.Double(c.x1, c.y1, c.ctrlx1, c.ctrly1, c.ctrlx2, c.ctrly2, c.x2, c.y2));
        }
    }

    private DotPath(List<CubicCurve2D.Double> beziers) {
        this.beziers.addAll(beziers);
    }

    public DotPath addCurve(Point2D pt1, Point2D pt2, Point2D pt3, Point2D pt4) {
        ArrayList<CubicCurve2D.Double> beziersNew = new ArrayList<CubicCurve2D.Double>(this.beziers);
        beziersNew.add(new CubicCurve2D.Double(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY(), pt3.getX(), pt3.getY(), pt4.getX(), pt4.getY()));
        return new DotPath(beziersNew);
    }

    public DotPath addCurve(Point2D pt2, Point2D pt3, Point2D pt4) {
        CubicCurve2D.Double last = this.beziers.get(this.beziers.size() - 1);
        Point2D p1 = last.getP2();
        return this.addCurve(p1, pt2, pt3, pt4);
    }

    private Point2D mirror(Point2D center, Point2D pt) {
        double x = 2.0 * center.getX() - pt.getX();
        double y = 2.0 * center.getY() - pt.getY();
        return new Point2D.Double(x, y);
    }

    public DotPath(SvgResult fullSvg) {
        if (!DotPath.isPathConsistent(fullSvg.getSvg())) {
            throw new IllegalArgumentException();
        }
        int posC = fullSvg.indexOf("C", 0);
        if (posC == -1) {
            throw new IllegalArgumentException();
        }
        Point2D.Double start = fullSvg.substring(1, posC).getNextPoint();
        ArrayList<TriPoints> triPoints = new ArrayList<TriPoints>();
        Iterator<Point2D.Double> it = fullSvg.substring(posC + 1).getPoints(" ").iterator();
        while (it.hasNext()) {
            Point2D.Double p1 = it.next();
            Point2D.Double p2 = it.next();
            Point2D.Double p = it.next();
            triPoints.add(new TriPoints(p1, p2, p));
        }
        double x = ((Point2D)start).getX();
        double y = ((Point2D)start).getY();
        for (TriPoints p : triPoints) {
            CubicCurve2D.Double bezier = new CubicCurve2D.Double(x, y, p.x1, p.y1, p.x2, p.y2, p.x, p.y);
            this.beziers.add(bezier);
            x = p.x;
            y = p.y;
        }
    }

    public static boolean isPathConsistent(String init) {
        return init.startsWith("M");
    }

    public Point2D getStartPoint() {
        return this.beziers.get(0).getP1();
    }

    public PointAndAngle getMiddle() {
        Point2D result = null;
        double angle = 0.0;
        for (CubicCurve2D.Double bez : this.beziers) {
            CubicCurve2D.Double left = new CubicCurve2D.Double();
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            bez.subdivide(left, right);
            Point2D p1 = left.getP1();
            Point2D p2 = left.getP2();
            Point2D p3 = right.getP1();
            Point2D p4 = right.getP2();
            if (result == null || this.getCost(p1) < this.getCost(result)) {
                result = p1;
                angle = BezierUtils.getStartingAngle(left);
            }
            if (this.getCost(p2) < this.getCost(result)) {
                result = p2;
                angle = BezierUtils.getEndingAngle(left);
            }
            if (this.getCost(p3) < this.getCost(result)) {
                result = p3;
                angle = BezierUtils.getStartingAngle(right);
            }
            if (!(this.getCost(p4) < this.getCost(result))) continue;
            result = p4;
            angle = BezierUtils.getEndingAngle(right);
        }
        return new PointAndAngle(result, angle);
    }

    private double getCost(Point2D pt) {
        Point2D start = this.getStartPoint();
        Point2D end = this.getEndPoint();
        return pt.distanceSq(start) + pt.distanceSq(end);
    }

    public void forceStartPoint(double x, double y) {
        this.beziers.get((int)0).x1 = x;
        this.beziers.get((int)0).y1 = y;
        this.beziers.get((int)0).ctrlx1 = x;
        this.beziers.get((int)0).ctrly1 = y;
    }

    public Point2D getEndPoint() {
        return this.beziers.get(this.beziers.size() - 1).getP2();
    }

    public void forceEndPoint(double x, double y) {
        this.beziers.get((int)(this.beziers.size() - 1)).x2 = x;
        this.beziers.get((int)(this.beziers.size() - 1)).y2 = y;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrlx2 = x;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrly2 = y;
    }

    public void moveEndPoint(double dx, double dy) {
        this.beziers.get((int)(this.beziers.size() - 1)).x2 += dx;
        this.beziers.get((int)(this.beziers.size() - 1)).y2 += dy;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrlx2 += dx;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrly2 += dy;
    }

    public MinFinder getMinFinder() {
        MinFinder result = new MinFinder();
        for (CubicCurve2D.Double c : this.beziers) {
            result.manage(c.x1, c.y1);
            result.manage(c.x2, c.y2);
            result.manage(c.ctrlx1, c.ctrly1);
            result.manage(c.ctrlx2, c.ctrly2);
        }
        return result;
    }

    public MinMax getMinMax() {
        MinMax result = MinMax.getEmpty(false);
        for (CubicCurve2D.Double c : this.beziers) {
            result = result.addPoint(c.x1, c.y1);
            result = result.addPoint(c.x2, c.y2);
            result = result.addPoint(c.ctrlx1, c.ctrly1);
            result = result.addPoint(c.ctrlx2, c.ctrly2);
        }
        return result;
    }

    public double getMinDist(Point2D ref) {
        double result = Double.MAX_VALUE;
        for (CubicCurve2D.Double c : this.beziers) {
            double d4;
            double d3;
            double d2;
            double d1 = ref.distance(c.x1, c.y1);
            if (d1 < result) {
                result = d1;
            }
            if ((d2 = ref.distance(c.x2, c.y2)) < result) {
                result = d2;
            }
            if ((d3 = ref.distance(c.ctrlx1, c.ctrly1)) < result) {
                result = d3;
            }
            if (!((d4 = ref.distance(c.ctrlx2, c.ctrly2)) < result)) continue;
            result = d4;
        }
        return result;
    }

    public Line2D getEndTangeante() {
        CubicCurve2D.Double last = this.beziers.get(this.beziers.size() - 1);
        double dx = last.x2 - last.ctrlx2;
        double dy = last.y2 - last.ctrly2;
        if (dx == 0.0 && dy == 0.0) {
            dx = last.x2 - last.x1;
            dy = last.y2 - last.y1;
        }
        return new Line2D.Double(last.x2, last.y2, last.x2 + dx, last.y2 + dy);
    }

    public double getEndAngle() {
        Line2D tan = this.getEndTangeante();
        double theta1 = Math.atan2(tan.getY2() - tan.getY1(), tan.getX2() - tan.getX1());
        return theta1;
    }

    public double getStartAngle() {
        Line2D tan = this.getStartTangeante();
        double theta1 = Math.atan2(tan.getY2() - tan.getY1(), tan.getX2() - tan.getX1());
        return theta1;
    }

    public Line2D getStartTangeante() {
        CubicCurve2D.Double first = this.beziers.get(0);
        double dx = first.ctrlx1 - first.x1;
        double dy = first.ctrly1 - first.y1;
        if (dx == 0.0 && dy == 0.0) {
            dx = first.x2 - first.x1;
            dy = first.y2 - first.y1;
        }
        return new Line2D.Double(first.x1, first.y1, first.x1 + dx, first.y1 + dy);
    }

    public DotPath addBefore(CubicCurve2D.Double before) {
        ArrayList<CubicCurve2D.Double> copy = new ArrayList<CubicCurve2D.Double>(this.beziers);
        copy.add(0, before);
        return new DotPath(copy);
    }

    private DotPath addBefore(DotPath other) {
        ArrayList<CubicCurve2D.Double> copy = new ArrayList<CubicCurve2D.Double>(this.beziers);
        copy.addAll(0, other.beziers);
        return new DotPath(copy);
    }

    public DotPath addAfter(CubicCurve2D.Double after) {
        ArrayList<CubicCurve2D.Double> copy = new ArrayList<CubicCurve2D.Double>(this.beziers);
        copy.add(after);
        return new DotPath(copy);
    }

    public DotPath addAfter(DotPath other) {
        ArrayList<CubicCurve2D.Double> copy = new ArrayList<CubicCurve2D.Double>(this.beziers);
        copy.addAll(other.beziers);
        return new DotPath(copy);
    }

    public Map<Point2D, Double> somePoints() {
        HashMap<Point2D, Double> result = new HashMap<Point2D, Double>();
        for (CubicCurve2D.Double bez : this.beziers) {
            CubicCurve2D.Double left = new CubicCurve2D.Double();
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            bez.subdivide(left, right);
            result.put(left.getP1(), BezierUtils.getStartingAngle(left));
            result.put(left.getP2(), BezierUtils.getEndingAngle(left));
            result.put(right.getP1(), BezierUtils.getStartingAngle(right));
            result.put(right.getP2(), BezierUtils.getEndingAngle(right));
        }
        return result;
    }

    private PointDirected getIntersection(ClusterPosition position) {
        for (CubicCurve2D.Double bez : this.beziers) {
            PointDirected result = position.getIntersection(bez);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void draw(Graphics2D g2d, double x, double y) {
        GeneralPath p = new GeneralPath();
        for (CubicCurve2D.Double bez : this.beziers) {
            bez = new CubicCurve2D.Double(x + bez.x1, y + bez.y1, x + bez.ctrlx1, y + bez.ctrly1, x + bez.ctrlx2, y + bez.ctrly2, x + bez.x2, y + bez.y2);
            p.append(bez, true);
        }
        g2d.draw(p);
    }

    public void manageEnsureVisible(double x, double y, EnsureVisible visible) {
        for (CubicCurve2D.Double bez : this.beziers) {
            visible.ensureVisible(x + bez.x1, y + bez.y1);
            visible.ensureVisible(x + bez.x2, y + bez.y2);
        }
    }

    public void drawOk(EpsGraphics eps, double x, double y) {
        for (CubicCurve2D.Double bez : this.beziers) {
            bez = new CubicCurve2D.Double(x + bez.x1, y + bez.y1, x + bez.ctrlx1, y + bez.ctrly1, x + bez.ctrlx2, y + bez.ctrly2, x + bez.x2, y + bez.y2);
            eps.epsLine(bez.x1, bez.y1, bez.x2, bez.y2);
        }
    }

    public void draw(EpsGraphics eps, double x, double y) {
        eps.newpathDot();
        boolean dashed = false;
        boolean first = true;
        for (CubicCurve2D.Double bez : this.beziers) {
            bez = new CubicCurve2D.Double(x + bez.x1, y + bez.y1, x + bez.ctrlx1, y + bez.ctrly1, x + bez.ctrlx2, y + bez.ctrly2, x + bez.x2, y + bez.y2);
            if (first) {
                eps.movetoNoMacro(bez.x1, bez.y1);
                first = false;
            }
            eps.curvetoNoMacro(bez.ctrlx1, bez.ctrly1, bez.ctrlx2, bez.ctrly2, bez.x2, bez.y2);
        }
        eps.closepathDot();
    }

    public UPath toUPath() {
        UPath result = new UPath(this.comment);
        boolean start = true;
        for (CubicCurve2D.Double bez : this.beziers) {
            if (start) {
                result.add(new double[]{bez.x1, bez.y1}, USegmentType.SEG_MOVETO);
                start = false;
            }
            result.add(new double[]{bez.ctrlx1, bez.ctrly1, bez.ctrlx2, bez.ctrly2, bez.x2, bez.y2}, USegmentType.SEG_CUBICTO);
        }
        return result;
    }

    private Point2D getFrontierIntersection(Shape shape, Rectangle2D ... notIn) {
        ArrayList<CubicCurve2D.Double> all = new ArrayList<CubicCurve2D.Double>(this.beziers);
        for (int i = 0; i < 8; ++i) {
            for (CubicCurve2D.Double immutable : all) {
                if (DotPath.contains(immutable, notIn)) continue;
                CubicCurve2D.Double bez = new CubicCurve2D.Double();
                bez.setCurve(immutable);
                if (!BezierUtils.isCutting(bez, shape)) continue;
                while (BezierUtils.dist(bez) > 1.0) {
                    BezierUtils.shorten(bez, shape);
                }
                Point2D.Double result = new Point2D.Double((bez.x1 + bez.x2) / 2.0, (bez.y1 + bez.y2) / 2.0);
                if (DotPath.contains(result, notIn)) continue;
                return result;
            }
            this.cutAllCubic(all);
        }
        throw new IllegalArgumentException("shape=" + shape);
    }

    private void cutAllCubic(List<CubicCurve2D.Double> all) {
        ArrayList<CubicCurve2D.Double> tmp = new ArrayList<CubicCurve2D.Double>(all);
        all.clear();
        for (CubicCurve2D.Double bez : tmp) {
            CubicCurve2D.Double left = new CubicCurve2D.Double();
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            bez.subdivide(left, right);
            all.add(left);
            all.add(right);
        }
    }

    private static boolean contains(Point2D.Double point, Rectangle2D ... rects) {
        for (Rectangle2D r : rects) {
            if (!r.contains(point)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(CubicCurve2D.Double cubic, Rectangle2D ... rects) {
        for (Rectangle2D r : rects) {
            if (!r.contains(cubic.getP1()) || !r.contains(cubic.getP2())) continue;
            return true;
        }
        return false;
    }

    private DotPath manageRect(Rectangle2D start, Rectangle2D end) {
        ArrayList<CubicCurve2D.Double> list = new ArrayList<CubicCurve2D.Double>(this.beziers);
        while (true) {
            if (!BezierUtils.isCutting((CubicCurve2D.Double)list.get(0), start)) {
                throw new IllegalStateException();
            }
            if (BezierUtils.dist((CubicCurve2D.Double)list.get(0)) <= 1.0) break;
            CubicCurve2D.Double left = new CubicCurve2D.Double();
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            ((CubicCurve2D.Double)list.get(0)).subdivide(left, right);
            list.set(0, left);
            list.add(1, right);
            if (!BezierUtils.isCutting((CubicCurve2D.Double)list.get(1), start)) continue;
            list.remove(0);
        }
        return new DotPath(list);
    }

    private Point2D getFrontierIntersection(Positionable p) {
        return this.getFrontierIntersection(PositionableUtils.convert(p), new Rectangle2D[0]);
    }

    public void draw(BasicCharArea area, double pixelXPerChar, double pixelYPerChar) {
        for (CubicCurve2D.Double bez : this.beziers) {
            if (bez.x1 == bez.x2) {
                area.drawVLine('|', (int)(bez.x1 / pixelXPerChar), (int)(bez.y1 / pixelYPerChar), (int)(bez.y2 / pixelYPerChar));
                continue;
            }
            if (bez.y1 != bez.y2) continue;
            area.drawHLine('-', (int)(bez.y1 / pixelYPerChar), (int)(bez.x1 / pixelXPerChar), (int)(bez.x2 / pixelXPerChar));
        }
    }

    static String toString(CubicCurve2D.Double c) {
        return "(" + c.x1 + "," + c.y1 + ") (" + c.ctrlx1 + "," + c.ctrly1 + ") (" + c.ctrlx2 + "," + c.ctrly2 + ") (" + c.x2 + "," + c.y2 + ") ";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CubicCurve2D.Double c : this.beziers) {
            sb.append(DotPath.toString(c));
            sb.append(" - ");
        }
        return sb.toString();
    }

    public static CubicCurve2D.Double reverse(CubicCurve2D curv) {
        return new CubicCurve2D.Double(curv.getX2(), curv.getY2(), curv.getCtrlX2(), curv.getCtrlY2(), curv.getCtrlX1(), curv.getCtrlY1(), curv.getX1(), curv.getY1());
    }

    public DotPath reverse() {
        ArrayList<CubicCurve2D.Double> reverse = new ArrayList<CubicCurve2D.Double>(this.beziers);
        Collections.reverse(reverse);
        ArrayList<CubicCurve2D.Double> copy = new ArrayList<CubicCurve2D.Double>();
        for (CubicCurve2D.Double cub : reverse) {
            copy.add(DotPath.reverse(cub));
        }
        return new DotPath(copy);
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        for (int i = 0; i < this.beziers.size(); ++i) {
            CubicCurve2D.Double c = this.beziers.get(i);
            this.beziers.set(i, new CubicCurve2D.Double(c.x1 + deltaX, c.y1 + deltaY, c.ctrlx1 + deltaX, c.ctrly1 + deltaY, c.ctrlx2 + deltaX, c.ctrly2 + deltaY, c.x2 + deltaX, c.y2 + deltaY));
        }
    }

    public final List<CubicCurve2D.Double> getBeziers() {
        return Collections.unmodifiableList(this.beziers);
    }

    /*
     * WARNING - void declaration
     */
    public DotPath simulateCompound(Cluster head, Cluster tail) {
        CubicCurve2D.Double part2;
        CubicCurve2D.Double part1;
        int k;
        ClusterPosition clusterPosition;
        if (head == null && tail == null) {
            return this;
        }
        DotPath me = this;
        if (tail != null && (clusterPosition = tail.getClusterPosition()).contains(this.getStartPoint())) {
            DotPath result = new DotPath();
            int idx = 0;
            while (idx + 1 < this.beziers.size() && clusterPosition.contains(this.beziers.get(idx).getP2())) {
                if (!clusterPosition.contains(this.beziers.get(idx).getP1())) {
                    throw new IllegalStateException();
                }
                ++idx;
            }
            if (!clusterPosition.contains(this.beziers.get(idx).getP2())) {
                assert (clusterPosition.contains(this.beziers.get(idx).getP1()));
                assert (!clusterPosition.contains(this.beziers.get(idx).getP2()));
                CubicCurve2D cubicCurve2D = this.beziers.get(idx);
                for (k = 0; k < 8; ++k) {
                    void var7_9;
                    part1 = new CubicCurve2D.Double();
                    part2 = new CubicCurve2D.Double();
                    var7_9.subdivide(part1, part2);
                    assert (part1.getP2().equals(part2.getP1()));
                    if (clusterPosition.contains(part1.getP2())) {
                        CubicCurve2D.Double double_ = part2;
                        continue;
                    }
                    result.beziers.add(0, part2);
                    CubicCurve2D.Double double_ = part1;
                }
                for (int i = idx + 1; i < this.beziers.size(); ++i) {
                    result.beziers.add(this.beziers.get(i));
                }
                me = result;
            }
        }
        if (head != null) {
            DotPath result = new DotPath();
            ClusterPosition clusterPosition2 = head.getClusterPosition();
            if (clusterPosition2.contains(this.getEndPoint())) {
                for (CubicCurve2D.Double double_ : me.beziers) {
                    if (!clusterPosition2.contains(double_.getP2())) {
                        result.beziers.add(double_);
                        continue;
                    }
                    if (clusterPosition2.contains(double_.getP1())) {
                        return me;
                    }
                    assert (!clusterPosition2.contains(double_.getP1()));
                    assert (clusterPosition2.contains(double_.getP2()));
                    for (k = 0; k < 8; ++k) {
                        void var7_15;
                        part1 = new CubicCurve2D.Double();
                        part2 = new CubicCurve2D.Double();
                        var7_15.subdivide(part1, part2);
                        assert (part1.getP2().equals(part2.getP1()));
                        if (clusterPosition2.contains(part1.getP2())) {
                            CubicCurve2D.Double double_2 = part1;
                            continue;
                        }
                        result.beziers.add(part1);
                        CubicCurve2D.Double double_3 = part2;
                    }
                    return result;
                }
            }
        }
        return me;
    }

    private double length(CubicCurve2D curve) {
        return curve.getP1().distance(curve.getP2());
    }

    public boolean isLine() {
        for (CubicCurve2D.Double curve : this.beziers) {
            if (!(curve.getFlatnessSq() > 0.001)) continue;
            return false;
        }
        return true;
    }

    public List<LineSegmentDouble> getLineSegments() {
        ArrayList<LineSegmentDouble> result = new ArrayList<LineSegmentDouble>();
        for (CubicCurve2D.Double curve : this.beziers) {
            if (!(curve.getFlatnessSq() <= 0.001)) continue;
            result.add(new LineSegmentDouble(curve));
        }
        return Collections.unmodifiableList(result);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    static class TriPoints {
        private final double x1;
        private final double y1;
        private final double x2;
        private final double y2;
        private final double x;
        private final double y;

        public TriPoints(Point2D.Double p1, Point2D.Double p2, Point2D.Double p) {
            this.x1 = p1.getX();
            this.y1 = p1.getY();
            this.x2 = p2.getX();
            this.y2 = p2.getY();
            this.x = p.getX();
            this.y = p.getY();
        }
    }
}

