/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import h.ST_refstr_t;
import java.util.ArrayList;
import java.util.List;
import smetana.core.JUtils;
import smetana.core.UnsupportedC;
import smetana.core.__ptr__;
import smetana.core.amiga.Area;

public class CString
extends UnsupportedC
implements __ptr__,
Area {
    private static int UID = 100;
    private final Throwable creation = new Throwable();
    private final List<Character> data2;
    private final int currentStart;
    private final int uid;
    private ST_refstr_t parent;

    public boolean isSameThan(CString other) {
        if (this.data2 != other.data2) {
            throw new UnsupportedOperationException();
        }
        return this.currentStart == other.currentStart;
    }

    @Override
    public void memcopyFrom(Area source) {
        CString other = (CString)source;
        this.data2.clear();
        this.data2.addAll(other.data2);
    }

    public CString(String string) {
        this(new ArrayList<Character>(), 0);
        for (int i = 0; i < string.length(); ++i) {
            this.data2.add(Character.valueOf(string.charAt(i)));
        }
        this.data2.add(Character.valueOf('\u0000'));
    }

    public CString duplicate() {
        return new CString(new ArrayList<Character>(this.data2), this.currentStart);
    }

    public CString strdup() {
        return this.duplicate();
    }

    public CString(int size) {
        this(new ArrayList<Character>(), 0);
        for (int i = 0; i < size; ++i) {
            this.data2.add(Character.valueOf('\u0000'));
        }
    }

    private CString(List<Character> data2, int currentStart) {
        this.data2 = data2;
        this.currentStart = currentStart;
        this.uid = UID;
        UID += 2;
        this.creation.fillInStackTrace();
    }

    @Override
    public __ptr__ addVirtualBytes(int bytes) {
        JUtils.LOG("CString::addVirtualBytes " + bytes);
        JUtils.LOG("AM " + this);
        throw new UnsupportedOperationException();
    }

    public ST_refstr_t getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        throw new UnsupportedOperationException();
    }

    public void setParent(ST_refstr_t struct) {
        if (struct == null) {
            throw new IllegalStateException();
        }
        this.parent = struct;
    }

    @Override
    public CString plus(int pointerMove) {
        return new CString(this.data2, this.currentStart + pointerMove);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Character c : this.getData()) {
            if (c.charValue() == '\u0000') {
                sb.append("(0)");
                continue;
            }
            sb.append(c);
        }
        return "CString:" + sb;
    }

    private List<Character> getData() {
        return this.data2.subList(this.currentStart, this.data2.size());
    }

    public String getContent() {
        StringBuilder sb = new StringBuilder();
        for (Character c : this.getData()) {
            if (c.charValue() == '\u0000') {
                return sb.toString();
            }
            sb.append(c);
        }
        throw new UnsupportedOperationException();
    }

    public char charAt(int i) {
        if (i >= this.getData().size()) {
            return '\u0000';
        }
        return this.getData().get(i).charValue();
    }

    public char setCharAt(int i, char c) {
        this.getData().set(i, Character.valueOf(c));
        return c;
    }

    public int length() {
        int len = 0;
        for (Character c : this.getData()) {
            if (c.charValue() == '\u0000') {
                return len;
            }
            ++len;
        }
        throw new IllegalStateException();
    }

    public int compareTo(CString other) {
        for (int i = 0; i < this.data2.size() - this.currentStart; ++i) {
            int diff = this.charAt(i) - other.charAt(i);
            if (this.charAt(i) != '\u0000' && diff == 0) continue;
            return diff;
        }
        throw new IllegalStateException();
    }

    public int compareTo(CString other, int num) {
        for (int i = 0; i < this.data2.size() - this.currentStart && i < num; ++i) {
            int diff = this.charAt(i) - other.charAt(i);
            if (this.charAt(i) != '\u0000' && diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public void copyFrom(CString source, int nb) {
        for (int i = 0; i < source.length() + 1 && i < nb; ++i) {
            this.setCharAt(i, source.charAt(i));
        }
    }

    public CString strchr(char c) {
        for (int i = this.currentStart; i < this.data2.size(); ++i) {
            if (this.data2.get(i).charValue() != c) continue;
            return new CString(this.data2, i);
        }
        return null;
    }

    public boolean isSame(CString other) {
        return this.getContent().equals(other.getContent());
    }

    public int getUid() {
        return this.uid;
    }
}

