/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public abstract class Annotations
extends Attribute {
    private AnnotationEntry[] annotation_table;
    private final boolean isRuntimeVisible;

    Annotations(byte annotation_type, int name_index, int length, DataInput input, ConstantPool constant_pool, boolean isRuntimeVisible) throws IOException {
        this(annotation_type, name_index, length, (AnnotationEntry[])null, constant_pool, isRuntimeVisible);
        int annotation_table_length = input.readUnsignedShort();
        this.annotation_table = new AnnotationEntry[annotation_table_length];
        for (int i = 0; i < annotation_table_length; ++i) {
            this.annotation_table[i] = AnnotationEntry.read(input, constant_pool, isRuntimeVisible);
        }
    }

    public Annotations(byte annotation_type, int name_index, int length, AnnotationEntry[] annotation_table, ConstantPool constant_pool, boolean isRuntimeVisible) {
        super(annotation_type, name_index, length, constant_pool);
        this.annotation_table = annotation_table;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    @Override
    public void accept(Visitor v) {
        v.visitAnnotation(this);
    }

    public final void setAnnotationTable(AnnotationEntry[] annotation_table) {
        this.annotation_table = annotation_table;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotation_table;
    }

    public final int getNumAnnotations() {
        if (this.annotation_table == null) {
            return 0;
        }
        return this.annotation_table.length;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    protected void writeAnnotations(DataOutputStream dos) throws IOException {
        if (this.annotation_table == null) {
            return;
        }
        dos.writeShort(this.annotation_table.length);
        for (AnnotationEntry element : this.annotation_table) {
            element.dump(dos);
        }
    }
}

