/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.eps;

import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UClip;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.drawing.eps.EpsGraphics;
import net.sourceforge.plantuml.klimt.shape.URectangle;

public class DriverRectangleEps
implements UDriver<URectangle, EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverRectangleEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(URectangle rect, double x, double y, ColorMapper mapper, UParam param, EpsGraphics eps) {
        HColor back;
        double width = rect.getWidth();
        double height = rect.getHeight();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Rectangle2D.Double orig = new Rectangle2D.Double(x, y, width, height);
            Rectangle2D.Double r = clip.getClippedRectangle(orig);
            if (r.height < 0.0) {
                return;
            }
            x = r.x;
            y = r.y;
            width = r.width;
            height = r.height;
        }
        double rx = rect.getRx();
        double ry = rect.getRy();
        if (rect.getDeltaShadow() != 0.0) {
            eps.epsRectangleShadow(x, y, width, height, rx / 2.0, ry / 2.0, rect.getDeltaShadow());
        }
        if ((back = param.getBackcolor()) instanceof HColorGradient) {
            eps.setStrokeColor(param.getColor().toColor(mapper));
            eps.epsRectangle(x, y, width, height, rx / 2.0, ry / 2.0, (HColorGradient)back, mapper);
        } else {
            eps.setStrokeColor(param.getColor().toColor(mapper));
            eps.setFillColor(param.getBackcolor().toColor(mapper));
            eps.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashVisible(), param.getStroke().getDashSpace());
            eps.epsRectangle(x, y, width, height, rx / 2.0, ry / 2.0);
        }
    }
}

