/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.UEmpty;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class LaneDivider
extends AbstractTextBlock {
    private final ISkinParam skinParam;
    private final double x1;
    private final double x2;
    private final double height;
    private Style style;

    public LaneDivider(ISkinParam skinParam, double x1, double x2, double height) {
        this.skinParam = skinParam;
        this.x1 = x1;
        this.x2 = x2;
        this.height = height;
    }

    public StyleSignatureBasic getDefaultStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.swimlane);
    }

    private Style getStyle() {
        if (this.style == null) {
            this.style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        }
        return this.style;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.x1 + this.x2, this.height);
    }

    @Override
    public void drawU(UGraphic ug) {
        UEmpty back = new UEmpty(this.x1 + this.x2, 1.0);
        ug.draw(back);
        HColor color = this.getStyle().value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        UStroke thickness = this.getStyle().getStroke();
        ug.apply(UTranslate.dx(this.x1)).apply(thickness).apply(color).draw(ULine.vline(this.height));
    }

    public double getWidth() {
        return this.x1 + this.x2;
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getX2() {
        return this.x2;
    }
}

