/*
 * Decompiled with CFR 0.152.
 */
package dom;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ElementTraversal;

public class ElementPrinter {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            ElementPrinter.printUsage();
            System.exit(1);
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(stringArray[0]);
            DOMImplementation dOMImplementation = document.getImplementation();
            if (dOMImplementation.hasFeature("ElementTraversal", "1.0")) {
                ElementPrinter.print(document.getDocumentElement(), 0);
            } else {
                System.err.println("The DOM implementation does not claim support for ElementTraversal.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void print(Element element, int n) {
        ElementTraversal elementTraversal;
        do {
            elementTraversal = (ElementTraversal)((Object)element);
            for (int i = 0; i < n; ++i) {
                System.out.print("--");
            }
            System.out.print("--> [");
            System.out.print(new QName(element.getNamespaceURI(), element.getLocalName()));
            System.out.println("], Child Element Count = " + elementTraversal.getChildElementCount());
            Element element2 = elementTraversal.getFirstElementChild();
            if (element2 == null) continue;
            ElementPrinter.print(element2, n + 1);
        } while ((element = elementTraversal.getNextElementSibling()) != null);
    }

    private static void printUsage() {
        System.err.println("usage: java dom.ElementPrinter uri");
    }
}

