/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.quantization;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sourceforge.plantuml.quantization.Multiset;

public final class HashMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    private final Map<E, Count> elementCounts = new HashMap<E, Count>();
    private int size;

    public HashMultiset() {
    }

    public HashMultiset(Collection<E> source) {
        this.addAll(source);
    }

    @Override
    public void add(E element, int n) {
        Count count = this.elementCounts.get(element);
        if (count != null) {
            count.value += n;
        } else {
            this.elementCounts.put(element, new Count(n));
        }
        this.size += n;
    }

    @Override
    public boolean add(E element) {
        this.add(element, 1);
        return true;
    }

    @Override
    public int remove(Object element, int n) {
        Count count = this.elementCounts.get(element);
        if (count == null) {
            return 0;
        }
        if (n < count.value) {
            count.value -= n;
            this.size -= n;
            return n;
        }
        this.elementCounts.remove(element);
        this.size -= count.value;
        return count.value;
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, 1) > 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new HashMultisetIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int count(Object element) {
        Count countOrNull = this.elementCounts.get(element);
        return countOrNull != null ? countOrNull.value : 0;
    }

    @Override
    public Set<E> getDistinctElements() {
        return this.elementCounts.keySet();
    }

    private static final class Count {
        private int value;

        Count(int value) {
            this.value = value;
        }
    }

    private final class HashMultisetIterator
    implements Iterator<E> {
        private final Iterator<Map.Entry<E, Count>> distinctElementIterator;
        private E currentElement;
        private int currentCount;
        private boolean currentElementRemoved;

        HashMultisetIterator() {
            this.distinctElementIterator = HashMultiset.this.elementCounts.entrySet().iterator();
            this.currentCount = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentCount > 0 || this.distinctElementIterator.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("iterator has been exhausted");
            }
            if (this.currentCount == 0) {
                Map.Entry next = this.distinctElementIterator.next();
                this.currentElement = next.getKey();
                this.currentCount = next.getValue().value;
            }
            --this.currentCount;
            this.currentElementRemoved = false;
            return this.currentElement;
        }

        @Override
        public void remove() {
            if (this.currentElement == null) {
                throw new IllegalStateException("next() has not been called");
            }
            if (this.currentElementRemoved) {
                throw new IllegalStateException("remove() already called for current element");
            }
            HashMultiset.this.remove(this.currentElement);
        }
    }
}

