/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.ScriptRuntime;

public class CompilerEnvirons {
    private ErrorReporter errorReporter = DefaultErrorReporter.instance;
    private int syntaxErrorCount = 0;
    private boolean fromEval = false;
    int languageVersion = 0;
    boolean generateDebugInfo = true;
    boolean useDynamicScope = false;
    boolean reservedKeywordAsIdentifier = false;
    boolean allowMemberExprAsFunctionName = false;
    private int optimizationLevel = 0;
    private boolean generatingSource = true;
    Hashtable activationNames;

    public void initFromContext(Context cx) {
        this.setErrorReporter(cx.getErrorReporter());
        this.languageVersion = cx.getLanguageVersion();
        this.useDynamicScope = cx.hasCompileFunctionsWithDynamicScope();
        this.generateDebugInfo = !cx.isGeneratingDebugChanged() || cx.isGeneratingDebug();
        this.reservedKeywordAsIdentifier = cx.hasFeature(3);
        this.allowMemberExprAsFunctionName = cx.hasFeature(2);
        this.optimizationLevel = cx.getOptimizationLevel();
        this.generatingSource = cx.isGeneratingSource();
        this.activationNames = cx.activationNames;
    }

    public final int getSyntaxErrorCount() {
        return this.syntaxErrorCount;
    }

    public final ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        this.errorReporter = errorReporter;
    }

    public final void reportSyntaxError(String message, String sourceName, int lineno, String lineText, int lineOffset) {
        ++this.syntaxErrorCount;
        if (this.fromEval) {
            throw ScriptRuntime.constructError("SyntaxError", message, sourceName, lineno, lineText, lineOffset);
        }
        this.getErrorReporter().error(message, sourceName, lineno, lineText, lineOffset);
    }

    public final void reportSyntaxWarning(String message, String sourceName, int lineno, String lineText, int lineOffset) {
        this.getErrorReporter().warning(message, sourceName, lineno, lineText, lineOffset);
    }

    public final boolean isFromEval() {
        return this.fromEval;
    }

    public void setFromEval(boolean fromEval) {
        this.fromEval = fromEval;
    }

    public final int getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(int languageVersion) {
        Context.checkLanguageVersion(languageVersion);
        this.languageVersion = languageVersion;
    }

    public final boolean isGenerateDebugInfo() {
        return this.generateDebugInfo;
    }

    public void setGenerateDebugInfo(boolean flag) {
        this.generateDebugInfo = flag;
    }

    public final boolean isUseDynamicScope() {
        return this.useDynamicScope;
    }

    public void setUseDynamicScope(boolean flag) {
        this.useDynamicScope = flag;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int level) {
        Context.checkOptimizationLevel(level);
        this.optimizationLevel = level;
    }

    public boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public void setGeneratingSource(boolean generatingSource) {
        this.generatingSource = generatingSource;
    }
}

