/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.io.FileReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;

class OpenFile
implements Runnable {
    String fileName;
    Main db;
    Reader reader = null;

    OpenFile(Main db, String fileName) {
        this.fileName = fileName;
        this.db = db;
    }

    OpenFile(Main db, String fileName, Reader reader) {
        this(db, fileName);
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Context cx = Context.enter();
        ContextData contextData = ContextData.get(cx);
        contextData.breakNextLine = true;
        try {
            cx.compileReader(this.reader == null ? new FileReader(this.fileName) : this.reader, this.fileName, 1, null);
        }
        catch (Exception exc) {
            String msg = exc.getMessage();
            if (exc instanceof EcmaError) {
                EcmaError err = (EcmaError)exc;
                msg = err.getSourceName() + ", line " + err.getLineNumber() + ": " + msg;
            }
            MessageDialogWrapper.showMessageDialog(this.db, msg, "Error Compiling File", 0);
        }
        finally {
            cx.exit();
        }
    }
}

