/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.modules.output.html;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class StyleBuilder {
    private static final String INDENT = "    ";
    private boolean compact;
    private Map backend;
    private Map parentBackend;

    public StyleBuilder(boolean bl, StyleBuilder styleBuilder) {
        this(bl);
        if (styleBuilder != null) {
            this.parentBackend = new TreeMap();
            if (styleBuilder.parentBackend != null) {
                this.parentBackend.putAll(styleBuilder.parentBackend);
            }
            this.parentBackend.putAll(styleBuilder.backend);
        }
    }

    public StyleBuilder(boolean bl) {
        this.compact = bl;
        this.backend = new TreeMap();
        this.parentBackend = null;
    }

    public void append(StyleKey styleKey, CSSValue cSSValue) {
        if (cSSValue == null) {
            return;
        }
        String string = cSSValue.getCSSText();
        String string2 = styleKey.getName();
        if (this.parentBackend == null || !styleKey.isInherited()) {
            this.backend.put(string2, string);
            return;
        }
        if (!this.parentContains(string2, string)) {
            this.backend.put(string2, string);
        }
    }

    public void append(String string, boolean bl, String string2) {
        if (this.parentBackend == null || !bl) {
            this.backend.put(string, string2);
            return;
        }
        if (!this.parentContains(string, string2)) {
            this.backend.put(string, string2);
        }
    }

    public void append(StyleKey styleKey, String string, String string2) {
        if (string == null) {
            return;
        }
        String string3 = string + string2;
        String string4 = styleKey.getName();
        if (this.parentBackend == null || !styleKey.isInherited()) {
            this.backend.put(string4, string3);
            return;
        }
        if (!this.parentContains(string4, string3)) {
            this.backend.put(string4, string3);
        }
    }

    public void append(StyleKey styleKey, String string) {
        String string2 = styleKey.getName();
        if (this.parentBackend == null || !styleKey.isInherited()) {
            this.backend.put(string2, string);
            return;
        }
        if (!this.parentContains(string2, string)) {
            this.backend.put(string2, string);
        }
    }

    public boolean parentContains(String string, String string2) {
        if (this.parentBackend == null) {
            return false;
        }
        Object v = this.parentBackend.get(string);
        return ObjectUtilities.equal(v, (Object)string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.compact) {
            Iterator iterator = this.backend.entrySet().iterator();
            while (iterator.hasNext()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(StringUtils.getLineSeparator());
                }
                stringBuffer.append(INDENT);
                Map.Entry entry = iterator.next();
                stringBuffer.append(entry.getKey());
                stringBuffer.append(": ");
                stringBuffer.append(entry.getValue());
                stringBuffer.append(';');
            }
        } else {
            for (Map.Entry entry : this.backend.entrySet()) {
                stringBuffer.append(entry.getKey());
                stringBuffer.append(": ");
                stringBuffer.append(entry.getValue());
                stringBuffer.append("; ");
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        StyleBuilder styleBuilder = new StyleBuilder(false);
        styleBuilder.append(BoxStyleKeys.PADDING_TOP, "red");
        StyleBuilder styleBuilder2 = new StyleBuilder(false, styleBuilder);
        styleBuilder2.append(BoxStyleKeys.PADDING_TOP, "red");
        StyleBuilder styleBuilder3 = new StyleBuilder(false, styleBuilder2);
        styleBuilder3.append(BoxStyleKeys.PADDING_TOP, "red");
    }

    public boolean isEmpty() {
        return this.backend.isEmpty();
    }
}

