/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.hsqldb.util.ZaurusChoice;
import org.hsqldb.util.ZaurusComponent;
import org.hsqldb.util.ZaurusEditor;
import org.hsqldb.util.ZaurusTextField;

public class ZaurusTableForm
extends ScrollPane
implements TextListener,
ItemListener,
ActionListener {
    Connection cConn;
    DatabaseMetaData dbmeta;
    String tableName;
    ZaurusComponent[] komponente;
    String[] columns;
    short[] columnTypes;
    String[] primaryKeys;
    int[] pkColIndex;
    String[][] importedKeys;
    int[][] imColIndex;
    String[] refTables;
    String[][] refColumns;
    int[][] refColIndex;
    Object[][] resultRowPKs;
    int numberOfResult;
    PreparedStatement pStmt;
    int aktRowNr;

    public ZaurusTableForm(String string, Connection connection) {
        this.tableName = string;
        this.cConn = connection;
        this.fetchColumns();
        this.fetchPrimaryKeys();
        this.fetchImportedKeys();
        this.initGUI();
    }

    public void cancelChanges() {
        this.showAktRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteRow() {
        int n;
        int n2;
        String string = "DELETE FROM " + this.tableName + this.generatePKWhere();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.cConn.prepareStatement(string);
            preparedStatement.clearParameters();
            for (n2 = 0; n2 < this.primaryKeys.length; ++n2) {
                preparedStatement.setObject(n2 + 1, this.resultRowPKs[this.aktRowNr][n2]);
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ZaurusEditor.printStatus("SQL Exception: " + sQLException.getMessage());
            int n3 = 0;
            return n3;
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        --this.numberOfResult;
        for (n = this.aktRowNr; n < this.numberOfResult; ++n) {
            for (n2 = 0; n2 < this.primaryKeys.length; ++n2) {
                this.resultRowPKs[n][n2] = this.resultRowPKs[n + 1][n2];
            }
        }
        if (this.numberOfResult == 0) {
            n = 1;
            ZaurusEditor.printStatus("Last row was deleted.");
            return n;
        }
        if (this.numberOfResult == this.aktRowNr) {
            --this.aktRowNr;
            n = this.aktRowNr == 0 ? 2 : 4;
        } else {
            n = this.numberOfResult >= 2 && this.aktRowNr < this.numberOfResult - 1 ? 4 : 3;
        }
        this.showAktRow();
        ZaurusEditor.printStatus("Row was deleted.");
        return n;
    }

    public String getPrimaryKeysString() {
        String string = "";
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            if (string != "") {
                string = string + ", ";
            }
            string = string + this.primaryKeys[i];
        }
        return string;
    }

    public void insertNewRow() {
        int n;
        for (n = 0; n < this.komponente.length; ++n) {
            this.komponente[n].clearContent();
        }
        for (n = 0; n < this.primaryKeys.length; ++n) {
            this.komponente[this.pkColIndex[n]].setEditable(true);
        }
        ZaurusEditor.printStatus("enter a new row for table " + this.tableName);
    }

    public boolean nextRow() {
        if (this.aktRowNr + 1 == this.numberOfResult) {
            return false;
        }
        ++this.aktRowNr;
        this.showAktRow();
        return this.aktRowNr + 1 < this.numberOfResult;
    }

    public boolean prevRow() {
        if (this.aktRowNr == 0) {
            return false;
        }
        --this.aktRowNr;
        this.showAktRow();
        return this.aktRowNr > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveChanges() {
        int[] nArray = new int[this.columns.length];
        int n = 0;
        String string = "";
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.komponente[i].hasChanged()) continue;
            if (string != "") {
                string = string + ", ";
            }
            string = string + this.columns[i] + "=?";
            nArray[n++] = i;
        }
        if (n > 0) {
            string = "UPDATE " + this.tableName + " SET " + string + this.generatePKWhere();
            PreparedStatement preparedStatement = null;
            try {
                int n2;
                int n3;
                preparedStatement = this.cConn.prepareStatement(string);
                preparedStatement.clearParameters();
                for (n3 = 0; n3 < n; ++n3) {
                    preparedStatement.setObject(n3 + 1, this.komponente[nArray[n3]].getContent());
                }
                for (n2 = 0; n2 < this.primaryKeys.length; ++n2) {
                    preparedStatement.setObject(n3 + n2 + 1, this.resultRowPKs[this.aktRowNr][n2]);
                }
                preparedStatement.executeUpdate();
                ZaurusEditor.printStatus("changed row was saved to table " + this.tableName);
                n2 = 1;
                return n2 != 0;
            }
            catch (SQLException sQLException) {
                ZaurusEditor.printStatus("SQL Exception: " + sQLException.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveNewRow() {
        int n;
        int n2;
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        for (n2 = 0; n2 < this.primaryKeys.length; ++n2) {
            if (!this.komponente[this.pkColIndex[n2]].getContent().equals("")) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.komponente[this.pkColIndex[n2]].requestFocus();
            ZaurusEditor.printStatus("no value for primary key " + this.primaryKeys[n2]);
            return false;
        }
        String string = "INSERT INTO " + this.tableName + " VALUES(";
        for (n = 0; n < this.columns.length; ++n) {
            if (n > 0) {
                string = string + ", ";
            }
            string = string + "?";
        }
        string = string + ")";
        try {
            preparedStatement = this.cConn.prepareStatement(string);
            preparedStatement.clearParameters();
            for (n = 0; n < this.columns.length; ++n) {
                preparedStatement.setObject(n + 1, this.komponente[n].getContent());
            }
            preparedStatement.executeUpdate();
            ZaurusEditor.printStatus("new row was saved to table " + this.tableName);
            boolean bl2 = true;
            return bl2;
        }
        catch (SQLException sQLException) {
            ZaurusEditor.printStatus("SQL Exception: " + sQLException.getMessage());
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int searchRows(String[] stringArray, boolean bl, boolean bl2, boolean bl3) {
        String string = this.generateWhere(stringArray, bl, bl2, bl3);
        Vector<Object[]> vector = new Vector<Object[]>(20);
        Statement statement = null;
        try {
            statement = this.cConn.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT " + this.getPrimaryKeysString() + " FROM " + this.tableName + string);
            while (resultSet.next()) {
                Object[] objectArray = new Object[this.primaryKeys.length];
                for (int i = 0; i < this.primaryKeys.length; ++i) {
                    objectArray[i] = resultSet.getObject(this.pkColIndex[i] + 1);
                }
                vector.addElement(objectArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ZaurusEditor.printStatus("SQL Exception: " + sQLException.getMessage());
            int n = -1;
            return n;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        this.resultRowPKs = new Object[vector.size()][this.primaryKeys.length];
        this.numberOfResult = vector.size();
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                this.resultRowPKs[j][i] = ((Object[])vector.elementAt(j))[i];
            }
        }
        String string2 = "SELECT * FROM " + this.tableName;
        try {
            this.pStmt = this.cConn.prepareStatement(string2 + this.generatePKWhere());
        }
        catch (SQLException sQLException) {
            System.out.println("SQL Exception: " + sQLException.getMessage());
        }
        if (this.numberOfResult > 0) {
            this.disablePKFields();
            this.aktRowNr = 0;
            this.showAktRow();
        }
        return this.numberOfResult;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.komponente[i] != textEvent.getSource()) continue;
            this.komponente[i].setChanged();
            break;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.komponente[i] != itemEvent.getSource()) continue;
            this.komponente[i].setChanged();
            break;
        }
    }

    private void disablePKFields() {
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            this.komponente[this.pkColIndex[i]].setEditable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillZChoice(ZaurusChoice zaurusChoice, String string, String string2) {
        Statement statement = null;
        try {
            if (this.cConn == null) {
                return;
            }
            statement = this.cConn.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string + " ORDER BY " + string2);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int n2 = resultSet.findColumn(string2);
            while (resultSet.next()) {
                String string3 = "";
                for (int i = 1; i <= n; ++i) {
                    if (i > 1) {
                        string3 = string3 + "; ";
                    }
                    string3 = string3 + resultSet.getString(i);
                }
                zaurusChoice.add(string3, resultSet.getString(n2));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQL Exception: " + sQLException.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void fetchColumns() {
        Vector<String> vector = new Vector<String>(20);
        Vector<Short> vector2 = new Vector<Short>(20);
        try {
            if (this.cConn == null) {
                return;
            }
            if (this.dbmeta == null) {
                this.dbmeta = this.cConn.getMetaData();
            }
            ResultSet resultSet = this.dbmeta.getColumns(null, null, this.tableName, "%");
            while (resultSet.next()) {
                vector.addElement(resultSet.getString("COLUMN_NAME"));
                vector2.addElement(new Short(resultSet.getShort("DATA_TYPE")));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ZaurusEditor.printStatus("SQL Exception: " + sQLException.getMessage());
        }
        this.columns = new String[vector.size()];
        vector.copyInto(this.columns);
        this.columnTypes = new short[vector.size()];
        for (int i = 0; i < this.columnTypes.length; ++i) {
            this.columnTypes[i] = (Short)vector2.elementAt(i);
        }
    }

    private void fetchImportedKeys() {
        int n;
        Object object;
        Object object2;
        Vector vector = new Vector(20);
        Vector<String> vector2 = null;
        Vector<String> vector3 = new Vector<String>(20);
        Vector vector4 = new Vector(20);
        Vector<String> vector5 = null;
        try {
            if (this.cConn == null) {
                return;
            }
            if (this.dbmeta == null) {
                this.dbmeta = this.cConn.getMetaData();
            }
            ResultSet resultSet = this.dbmeta.getImportedKeys(null, null, this.tableName);
            while (resultSet.next()) {
                String string = resultSet.getString("PKTABLE_NAME");
                object2 = resultSet.getString("PKCOLUMN_NAME");
                object = resultSet.getString("FKCOLUMN_NAME");
                n = resultSet.getInt("KEY_SEQ");
                if (n == 1) {
                    if (vector2 != null) {
                        vector.addElement(vector2);
                        vector4.addElement(vector5);
                    }
                    vector2 = new Vector<String>(20);
                    vector5 = new Vector<String>(20);
                    vector3.addElement(string);
                }
                vector2.addElement((String)object);
                vector5.addElement((String)object2);
            }
            if (vector2 != null) {
                vector.addElement(vector2);
                vector4.addElement(vector5);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ZaurusEditor.printStatus("SQL Exception: " + sQLException.getMessage());
        }
        int n2 = vector.size();
        this.importedKeys = new String[n2][];
        this.imColIndex = new int[n2][];
        this.refTables = new String[n2];
        this.refColumns = new String[n2][];
        this.refColIndex = new int[n2][];
        for (int i = 0; i < n2; ++i) {
            object2 = (Vector)vector.elementAt(i);
            object = (Vector)vector4.elementAt(i);
            n = ((Vector)object2).size();
            this.importedKeys[i] = new String[n];
            this.imColIndex[i] = new int[n];
            this.refColumns[i] = new String[n];
            this.refColIndex[i] = new int[n];
            this.refTables[i] = (String)vector3.elementAt(i);
            for (int j = 0; j < n; ++j) {
                this.importedKeys[i][j] = (String)((Vector)object2).elementAt(j);
                this.imColIndex[i][j] = this.getColIndex(this.importedKeys[i][j]);
                this.refColumns[i][j] = (String)((Vector)object).elementAt(j);
                this.refColIndex[i][j] = this.getColIndex(this.refColumns[i][j], this.refTables[i]);
            }
        }
    }

    private void fetchPrimaryKeys() {
        Vector<String> vector = new Vector<String>(20);
        try {
            if (this.cConn == null) {
                return;
            }
            if (this.dbmeta == null) {
                this.dbmeta = this.cConn.getMetaData();
            }
            ResultSet resultSet = this.dbmeta.getPrimaryKeys(null, null, this.tableName);
            while (resultSet.next()) {
                vector.addElement(resultSet.getString("COLUMN_NAME"));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ZaurusEditor.printStatus("SQL Exception: " + sQLException.getMessage());
        }
        this.primaryKeys = new String[vector.size()];
        vector.copyInto(this.primaryKeys);
        this.pkColIndex = new int[this.primaryKeys.length];
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            this.pkColIndex[i] = this.getColIndex(this.primaryKeys[i]);
        }
    }

    private String generatePKWhere() {
        String string = " WHERE ";
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            if (i > 0) {
                string = string + " AND ";
            }
            string = string + this.primaryKeys[i] + "=?";
        }
        return string;
    }

    private String generateWhere(String[] stringArray, boolean bl, boolean bl2, boolean bl3) {
        String string = "";
        String string2 = bl ? " AND " : " OR ";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = "";
            for (int j = 0; j < this.columns.length; ++j) {
                if (string3 != "") {
                    string3 = string3 + " OR ";
                }
                if (bl2) {
                    if (bl3) {
                        string3 = string3 + "LOWER(" + this.columns[j] + ") LIKE '%" + stringArray[i].toLowerCase() + "%'";
                        continue;
                    }
                    string3 = string3 + "LOWER(" + this.columns[j] + ") LIKE '" + stringArray[i].toLowerCase() + "'";
                    continue;
                }
                string3 = bl3 ? string3 + this.columns[j] + " LIKE '%" + stringArray[i] + "%'" : string3 + this.columns[j] + " LIKE '" + stringArray[i] + "'";
            }
            if (string != "") {
                string = string + string2;
            }
            string = string + "(" + string3 + ")";
        }
        if (string != "") {
            string = " WHERE " + string;
        }
        return string;
    }

    private int getColIndex(String string) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!string.equals(this.columns[i])) continue;
            return i;
        }
        return -1;
    }

    private int getColIndex(String string, String string2) {
        int n = 0;
        try {
            if (this.cConn == null) {
                return -1;
            }
            if (this.dbmeta == null) {
                this.dbmeta = this.cConn.getMetaData();
            }
            ResultSet resultSet = this.dbmeta.getColumns(null, null, string2, string);
            resultSet.next();
            n = resultSet.getInt("ORDINAL_POSITION");
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQL Exception: " + sQLException.getMessage());
        }
        return n - 1;
    }

    private int getConstraintIndex(int n) {
        for (int i = 0; i < this.imColIndex.length; ++i) {
            for (int j = 0; j < this.imColIndex[i].length; ++j) {
                if (n != this.imColIndex[i][j]) continue;
                return i;
            }
        }
        return -1;
    }

    private void initGUI() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.komponente = new ZaurusComponent[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Component component;
            gridBagConstraints.gridy = i;
            gridBagConstraints.gridx = 0;
            panel.add((Component)new Label(this.columns[i]), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            int n = this.getConstraintIndex(i);
            if (n >= 0 && this.imColIndex[n].length == 1) {
                component = new ZaurusChoice();
                this.fillZChoice((ZaurusChoice)component, this.refTables[n], this.refColumns[n][0]);
                ((Choice)component).addItemListener(this);
                this.komponente[i] = component;
                panel.add(component, gridBagConstraints);
            } else if (this.columnTypes[i] == 91) {
                component = new ZaurusTextField(8);
                ((TextComponent)component).addTextListener(this);
                panel.add(component, gridBagConstraints);
                this.komponente[i] = component;
            } else {
                component = new ZaurusTextField(5);
                ((TextComponent)component).addTextListener(this);
                panel.add(component, gridBagConstraints);
                this.komponente[i] = component;
            }
            this.komponente[i].setEditable(true);
        }
        this.add(panel);
    }

    private void showAktRow() {
        try {
            this.pStmt.clearParameters();
            for (int i = 0; i < this.primaryKeys.length; ++i) {
                this.pStmt.setObject(i + 1, this.resultRowPKs[this.aktRowNr][i]);
            }
            ResultSet resultSet = this.pStmt.executeQuery();
            resultSet.next();
            for (int i = 0; i < this.columns.length; ++i) {
                this.komponente[i].setContent(resultSet.getString(i + 1));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ZaurusEditor.printStatus("SQL Exception: " + sQLException.getMessage());
        }
        for (int i = 0; i < this.columns.length; ++i) {
            this.komponente[i].clearChanges();
        }
    }
}

