/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.openoffice.xmerge.converter.palm.PalmDB;
import org.openoffice.xmerge.converter.palm.PdbHeader;
import org.openoffice.xmerge.converter.palm.Record;

public final class PdbEncoder {
    private final PdbHeader header = new PdbHeader();
    private final PalmDB db;
    private static final int START_UNIQUE_ID = 47806;

    public PdbEncoder(PalmDB palmDB) {
        this.header.version = palmDB.getVersion();
        this.header.attribute = palmDB.getAttribute();
        this.db = palmDB;
        this.header.pdbName = palmDB.getPDBNameBytes();
        this.header.creatorID = palmDB.getCreatorID();
        this.header.typeID = palmDB.getTypeID();
        Date date = new Date();
        this.header.modificationDate = this.header.creationDate = date.getTime() / 1000L + 2082844800L;
        this.header.numRecords = palmDB.getRecordCount();
    }

    public void write(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        this.header.write(dataOutputStream);
        if (this.header.numRecords > 0) {
            int n;
            int[] nArray = new int[this.header.numRecords];
            byte[] byArray = new byte[this.header.numRecords];
            nArray[0] = 78 + this.header.numRecords * 8;
            int n2 = this.header.numRecords - 1;
            for (int i = 0; i < n2; ++i) {
                Record record = this.db.getRecord(i);
                n = record.getSize();
                byArray[i] = record.getAttributes();
                nArray[i + 1] = nArray[i] + n;
            }
            Record record = this.db.getRecord(n2);
            byArray[n2] = record.getAttributes();
            int n3 = 47806;
            for (n = 0; n < this.header.numRecords; ++n) {
                dataOutputStream.writeInt(nArray[n]);
                int n4 = byArray[n] << 24;
                dataOutputStream.writeInt(n4 |= n3);
                ++n3;
            }
            for (n = 0; n < this.header.numRecords; ++n) {
                Record record2 = this.db.getRecord(n);
                byte[] byArray2 = record2.getBytes();
                dataOutputStream.write(byArray2);
            }
        } else {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.flush();
    }
}

