/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.ContextHelper;
import org.mozilla.javascript.tools.debugger.ContextWindow;
import org.mozilla.javascript.tools.debugger.CreateFileWindow;
import org.mozilla.javascript.tools.debugger.EnterInterrupt;
import org.mozilla.javascript.tools.debugger.EvalWindow;
import org.mozilla.javascript.tools.debugger.ExitInterrupt;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FindFunction;
import org.mozilla.javascript.tools.debugger.FrameHelper;
import org.mozilla.javascript.tools.debugger.JSInternalConsole;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Menubar;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.MoreWindows;
import org.mozilla.javascript.tools.debugger.OfficeScriptInfo;
import org.mozilla.javascript.tools.debugger.OpenFile;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.ScriptItem;
import org.mozilla.javascript.tools.debugger.SetFilePosition;
import org.mozilla.javascript.tools.debugger.SourceInfo;
import org.mozilla.javascript.tools.debugger.UpdateContext;
import org.mozilla.javascript.tools.debugger.UpdateFileText;

public class Main
extends JFrame
implements Debugger,
ContextListener {
    ObjToIntMap contexts = new ObjToIntMap();
    static Thread mainThread;
    boolean breakFlag = false;
    static final int STEP_OVER = 0;
    static final int STEP_INTO = 1;
    static final int STEP_OUT = 2;
    static final int GO = 3;
    static final int BREAK = 4;
    static final int RUN_TO_CURSOR = 5;
    static final int EXIT = 6;
    private Hashtable threadState = new Hashtable();
    private Thread runToCursorThread;
    private int runToCursorLine;
    private String runToCursorFile;
    private Hashtable scriptItems = new Hashtable();
    private Hashtable sourceNames = new Hashtable();
    Hashtable functionNames = new Hashtable();
    JDesktopPane desk;
    ContextWindow context;
    Menubar menubar;
    JToolBar toolBar;
    JSInternalConsole console;
    EvalWindow evalWindow;
    JSplitPane split1;
    JLabel statusBar;
    ScopeProvider scopeProvider;
    Runnable exitAction;
    int frameIndex = -1;
    boolean isInterrupted = false;
    boolean nonDispatcherWaiting = false;
    int dispatcherIsWaiting = 0;
    Context currentContext = null;
    boolean sourceEditingEnabled = true;
    JFileChooser dlg;
    Hashtable fileWindows = new Hashtable();
    FileWindow currentWindow;
    Object monitor = new Object();
    Object swingMonitor = new Object();
    int returnValue = -1;
    boolean breakOnExceptions;
    boolean breakOnEnter;
    boolean breakOnReturn;
    Hashtable toplevels = new Hashtable();
    OfficeScriptInfo officeScripts = new OfficeScriptInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextCreated(Context cx) {
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            ContextData contextData = new ContextData();
            cx.setDebugger(this, contextData);
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(-1);
            if (this.breakFlag || Thread.currentThread() == mainThread) {
                contextData.breakNextLine = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextEntered(Context cx) {
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            if (!this.contexts.has(cx) && cx.getDebugger() == this) {
                this.contexts.put(cx, 1);
            }
        }
    }

    @Override
    public void contextExited(Context cx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextReleased(Context cx) {
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            this.contexts.remove(cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBreak() {
        this.breakFlag = true;
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            ObjToIntMap.Iterator iter = this.contexts.newIterator();
            iter.start();
            while (!iter.done()) {
                Context cx = (Context)iter.getKey();
                ContextData.get((Context)cx).breakNextLine = true;
                iter.next();
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.context.split.setDividerLocation(0.5);
        }
    }

    @Override
    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
        String sourceUrl = this.getNormilizedUrl(fnOrScript);
        SourceInfo si = this.registerSource(sourceUrl, source);
        this.registerScript(si, fnOrScript);
    }

    String getNormilizedUrl(DebuggableScript fnOrScript) {
        String url = fnOrScript.getSourceName();
        if (url == null) {
            url = "document";
        } else {
            int searchStart;
            int evalSeparator = 35;
            StringBuffer sb = null;
            int urlLength = url.length();
            int cursor = 0;
            while ((searchStart = url.indexOf(evalSeparator, cursor)) >= 0) {
                char c;
                int i;
                String replace = null;
                boolean hasDigits = false;
                for (i = searchStart + 1; i != urlLength && '0' <= (c = url.charAt(i)) && c <= '9'; ++i) {
                }
                if (i != searchStart + 1 && "(eval)".regionMatches(0, url, i, 6)) {
                    cursor = i + 6;
                    replace = "(eval)";
                }
                if (replace == null) break;
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append(url.substring(0, searchStart));
                }
                sb.append(replace);
            }
            if (sb != null) {
                if (cursor != urlLength) {
                    sb.append(url.substring(cursor));
                }
                url = sb.toString();
            }
        }
        return url;
    }

    private static InputStream openSource(String sourceUrl) throws IOException {
        int hash = sourceUrl.indexOf(35);
        if (hash >= 0) {
            sourceUrl = sourceUrl.substring(0, hash);
        }
        if (sourceUrl.indexOf(58) < 0) {
            try {
                String pathFromHome;
                File f;
                String home;
                if (sourceUrl.startsWith("~/") && (home = System.getProperty("user.home")) != null && (f = new File(new File(home), pathFromHome = sourceUrl.substring(2))).exists()) {
                    return new FileInputStream(f);
                }
                File f2 = new File(sourceUrl);
                if (f2.exists()) {
                    return new FileInputStream(f2);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            sourceUrl = sourceUrl.startsWith("//") ? "http:" + sourceUrl : (sourceUrl.startsWith("/") ? "http://127.0.0.1" + sourceUrl : "http://" + sourceUrl);
        }
        return new URL(sourceUrl).openStream();
    }

    private static String readSource(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        int offset = 0;
        while ((n = is.read(buffer, 0, buffer.length - offset)) >= 0) {
            if ((offset += n) != buffer.length) continue;
            byte[] tmp = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, tmp, 0, offset);
            buffer = tmp;
        }
        return new String(buffer, 0, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceInfo registerSource(String sourceUrl, String source) {
        SourceInfo si;
        Hashtable hashtable = this.sourceNames;
        synchronized (hashtable) {
            si = (SourceInfo)this.sourceNames.get(sourceUrl);
            if (si == null) {
                si = new SourceInfo(sourceUrl, source);
                this.sourceNames.put(sourceUrl, si);
            } else if (!source.equals(si.getSource())) {
                si.setSource(source);
            }
        }
        return si;
    }

    private ScriptItem registerScript(SourceInfo si, DebuggableScript fnOrScript) {
        ScriptItem item = new ScriptItem(fnOrScript, si);
        si.updateLineInfo(item);
        this.scriptItems.put(fnOrScript, item);
        String name = fnOrScript.getFunctionName();
        if (name != null && name.length() > 0 && !name.equals("anonymous")) {
            this.functionNames.put(name, item);
        }
        this.loadedFile(si);
        return item;
    }

    void handleBreakpointHit(Context cx) {
        this.breakFlag = false;
        this.interrupted(cx);
    }

    private static String exceptionString(Throwable ex) {
        String msg;
        Throwable wrapped;
        if (ex instanceof JavaScriptException) {
            JavaScriptException jse = (JavaScriptException)ex;
            return ScriptRuntime.toString(jse.getValue());
        }
        if (ex instanceof EcmaError) {
            return ex.toString();
        }
        if (ex instanceof WrappedException && (wrapped = ((WrappedException)ex).getWrappedException()) != null) {
            ex = wrapped;
        }
        if ((msg = ex.toString()) == null || msg.length() == 0) {
            msg = ex.getClass().toString();
        }
        return msg;
    }

    void handleExceptionThrown(Context cx, Throwable ex, FrameHelper frame) {
        if (this.breakOnExceptions) {
            String url = frame.getUrl();
            int lineNumber = frame.getLineNumber();
            FileWindow w = this.getFileWindow(url);
            String msg = Main.exceptionString(ex);
            msg = msg + " (" + url + ", line " + lineNumber + ")";
            if (w != null) {
                Main.swingInvoke(new SetFilePosition(this, w, lineNumber));
            }
            MessageDialogWrapper.showMessageDialog(this, msg, "Exception in Script", 0);
            this.interrupted(cx);
        }
    }

    @Override
    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        return new FrameHelper(cx, this, fnOrScript);
    }

    void init() {
        JButton stepOutButton;
        JButton stepOverButton;
        JButton stepIntoButton;
        JButton goButton;
        JButton breakButton;
        JButton button;
        this.menubar = new Menubar(this);
        this.setJMenuBar(this.menubar);
        this.toolBar = new JToolBar();
        String[] toolTips = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        int count = 0;
        JButton focusButton = button = (breakButton = new JButton("Break"));
        button.setToolTipText("Break");
        button.setActionCommand("Break");
        button.addActionListener(this.menubar);
        button.setEnabled(true);
        button.setToolTipText(toolTips[count++]);
        button = goButton = new JButton("Go");
        button.setToolTipText("Go");
        button.setActionCommand("Go");
        button.addActionListener(this.menubar);
        button.setEnabled(false);
        button.setToolTipText(toolTips[count++]);
        button = stepIntoButton = new JButton("Step Into");
        button.setToolTipText("Step Into");
        button.setActionCommand("Step Into");
        button.addActionListener(this.menubar);
        button.setEnabled(false);
        button.setToolTipText(toolTips[count++]);
        button = stepOverButton = new JButton("Step Over");
        button.setToolTipText("Step Over");
        button.setActionCommand("Step Over");
        button.setEnabled(false);
        button.addActionListener(this.menubar);
        button.setToolTipText(toolTips[count++]);
        button = stepOutButton = new JButton("Step Out");
        button.setToolTipText("Step Out");
        button.setActionCommand("Step Out");
        button.setEnabled(false);
        button.addActionListener(this.menubar);
        button.setToolTipText(toolTips[count++]);
        Dimension dim = stepOverButton.getPreferredSize();
        breakButton.setPreferredSize(dim);
        breakButton.setMinimumSize(dim);
        breakButton.setMaximumSize(dim);
        breakButton.setSize(dim);
        goButton.setPreferredSize(dim);
        goButton.setMinimumSize(dim);
        goButton.setMaximumSize(dim);
        stepIntoButton.setPreferredSize(dim);
        stepIntoButton.setMinimumSize(dim);
        stepIntoButton.setMaximumSize(dim);
        stepOverButton.setPreferredSize(dim);
        stepOverButton.setMinimumSize(dim);
        stepOverButton.setMaximumSize(dim);
        stepOutButton.setPreferredSize(dim);
        stepOutButton.setMinimumSize(dim);
        stepOutButton.setMaximumSize(dim);
        this.toolBar.add(breakButton);
        this.toolBar.add(goButton);
        this.toolBar.add(stepIntoButton);
        this.toolBar.add(stepOverButton);
        this.toolBar.add(stepOutButton);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)contentPane, "Center");
        this.desk = new JDesktopPane();
        this.desk.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        this.context = new ContextWindow(this);
        this.context.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        this.split1 = new JSplitPane(0, this.desk, this.context);
        this.split1.setOneTouchExpandable(true);
        Main.setResizeWeight(this.split1, 0.66);
        contentPane.add((Component)this.split1, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Thread: ");
        contentPane.add((Component)this.statusBar, "South");
        this.dlg = new JFileChooser();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                String ext;
                if (f.isDirectory()) {
                    return true;
                }
                String n = f.getName();
                int i = n.lastIndexOf(46);
                return i > 0 && i < n.length() - 1 && (ext = n.substring(i + 1).toLowerCase()).equals("js");
            }

            @Override
            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(filter);
        final Main self = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                self.Exit();
            }
        });
    }

    Scriptable getScope() {
        return this.scopeProvider != null ? this.scopeProvider.getScope() : null;
    }

    FileWindow getFileWindow(String url) {
        if (url == null || url.equals("<stdin>")) {
            return null;
        }
        return (FileWindow)this.fileWindows.get(url);
    }

    void loadedFile(SourceInfo si) {
        String fileName = si.getUrl();
        FileWindow w = this.getFileWindow(fileName);
        if (w != null) {
            Main.swingInvoke(UpdateFileText.action(w));
            w.show();
        } else if (!fileName.equals("<stdin>")) {
            Main.swingInvoke(CreateFileWindow.action(this, si, -1));
        }
    }

    static void swingInvoke(Runnable f) {
        if (SwingUtilities.isEventDispatchThread()) {
            f.run();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(f);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    static void swingInvokeLater(Runnable f) {
        try {
            SwingUtilities.invokeLater(f);
        }
        catch (RuntimeException exc) {
            exc.printStackTrace();
        }
    }

    void contextSwitch(int frameIndex) {
        Context cx = this.getCurrentContext();
        ContextData contextData = ContextData.get(cx);
        ContextHelper helper = new ContextHelper();
        helper.attach(cx);
        if (cx != null) {
            int frameCount = contextData.getFrameCount();
            if (frameIndex < 0 || frameIndex >= frameCount) {
                helper.reset();
                return;
            }
            this.frameIndex = frameIndex;
            FrameHelper frame = contextData.getFrame(frameIndex);
            String sourceName = frame.getUrl();
            if (sourceName == null || sourceName.equals("<stdin>")) {
                helper.reset();
                return;
            }
            int lineNumber = frame.getLineNumber();
            this.frameIndex = frameIndex;
            FileWindow w = this.getFileWindow(sourceName);
            if (w != null) {
                SetFilePosition action = new SetFilePosition(this, w, lineNumber);
                action.run();
            } else {
                SourceInfo si = frame.getSourceInfo();
                CreateFileWindow.action(this, si, lineNumber).run();
            }
            helper.reset();
        }
    }

    public boolean isSourceEditingEnabled() {
        return this.sourceEditingEnabled;
    }

    void setSourceEditingEnabled(boolean b) {
        this.sourceEditingEnabled = b;
    }

    Context getCurrentContext() {
        return this.currentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupted(Context cx) {
        Object object;
        block59: {
            FrameHelper frame;
            String url;
            int frameCount;
            object = this.swingMonitor;
            synchronized (object) {
                if (SwingUtilities.isEventDispatchThread()) {
                    ++this.dispatcherIsWaiting;
                    if (this.nonDispatcherWaiting) {
                        EventQueue eventQ = Toolkit.getDefaultToolkit().getSystemEventQueue();
                        while (this.nonDispatcherWaiting) {
                            try {
                                AWTEvent event = eventQ.getNextEvent();
                                if (event instanceof ActiveEvent) {
                                    ((ActiveEvent)((Object)event)).dispatch();
                                } else {
                                    Object source = event.getSource();
                                    if (source instanceof Component) {
                                        Component comp = (Component)source;
                                        comp.dispatchEvent(event);
                                    } else if (source instanceof MenuComponent) {
                                        ((MenuComponent)source).dispatchEvent(event);
                                    }
                                }
                                if (this.returnValue == 6) {
                                    return;
                                }
                                this.swingMonitor.wait(1L);
                            }
                            catch (InterruptedException exc) {
                                return;
                            }
                        }
                    }
                } else {
                    while (this.isInterrupted || this.dispatcherIsWaiting > 0) {
                        try {
                            this.swingMonitor.wait();
                        }
                        catch (InterruptedException exc) {
                            return;
                        }
                    }
                    this.nonDispatcherWaiting = true;
                }
                this.isInterrupted = true;
            }
            this.currentContext = cx;
            ContextData contextData = ContextData.get(cx);
            Thread thread = Thread.currentThread();
            this.statusBar.setText("Thread: " + thread.toString());
            ThreadState state = (ThreadState)this.threadState.get(thread);
            int stopAtFrameDepth = -1;
            if (state != null) {
                stopAtFrameDepth = state.stopAtFrameDepth;
            }
            if (this.runToCursorFile != null && thread == this.runToCursorThread && (frameCount = contextData.getFrameCount()) > 0 && (url = (frame = contextData.getFrame(0)).getUrl()) != null && url.equals(this.runToCursorFile)) {
                int lineNumber = frame.getLineNumber();
                if (lineNumber == this.runToCursorLine) {
                    stopAtFrameDepth = -1;
                    this.runToCursorFile = null;
                } else {
                    FileWindow w = this.getFileWindow(url);
                    if (w == null || !w.isBreakPoint(lineNumber)) {
                        return;
                    }
                    this.runToCursorFile = null;
                }
            }
            if (stopAtFrameDepth <= 0 || contextData.getFrameCount() <= stopAtFrameDepth) {
                if (state != null) {
                    state.stopAtFrameDepth = -1;
                }
                this.threadState.remove(thread);
                frameCount = contextData.getFrameCount();
                this.frameIndex = frameCount - 1;
                int line = 0;
                if (frameCount != 0) {
                    int returnValue;
                    Object si;
                    FrameHelper frame2 = contextData.getFrame(0);
                    String url2 = frame2.getUrl();
                    contextData.breakNextLine = false;
                    line = frame2.getLineNumber();
                    int enterCount = 0;
                    boolean isDispatchThread = SwingUtilities.isEventDispatchThread();
                    if (!isDispatchThread) {
                        cx.exit();
                        while (Context.getCurrentContext() != null) {
                            Context.exit();
                            ++enterCount;
                        }
                    }
                    if (url2 != null && !url2.equals("<stdin>")) {
                        FileWindow w = this.getFileWindow(url2);
                        if (w != null) {
                            SetFilePosition action = new SetFilePosition(this, w, line);
                            Main.swingInvoke(action);
                        } else {
                            si = frame2.getSourceInfo();
                            Main.swingInvoke(CreateFileWindow.action(this, (SourceInfo)si, line));
                        }
                    }
                    Main.swingInvoke(new EnterInterrupt(this, cx));
                    Main.swingInvoke(new UpdateContext(this, cx));
                    if (!isDispatchThread) {
                        si = this.monitor;
                        synchronized (si) {
                            this.returnValue = -1;
                            try {
                                while (this.returnValue == -1) {
                                    this.monitor.wait();
                                }
                                returnValue = this.returnValue;
                            }
                            catch (InterruptedException exc) {
                                break block59;
                            }
                        }
                    }
                    EventQueue eventQ = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    this.returnValue = -1;
                    while (this.returnValue == -1) {
                        try {
                            AWTEvent event = eventQ.getNextEvent();
                            if (event instanceof ActiveEvent) {
                                ((ActiveEvent)((Object)event)).dispatch();
                                continue;
                            }
                            Object source = event.getSource();
                            if (source instanceof Component) {
                                Component comp = (Component)source;
                                comp.dispatchEvent(event);
                                continue;
                            }
                            if (!(source instanceof MenuComponent)) continue;
                            ((MenuComponent)source).dispatchEvent(event);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    returnValue = this.returnValue;
                    Main.swingInvoke(new ExitInterrupt(this));
                    if (!isDispatchThread) {
                        Context current = Context.enter(cx);
                        if (current != cx) {
                            System.out.println("debugger error: cx = " + cx + " current = " + current);
                        }
                        while (enterCount > 0) {
                            Context.enter();
                            --enterCount;
                        }
                    }
                    switch (returnValue) {
                        case 0: {
                            contextData.breakNextLine = true;
                            stopAtFrameDepth = contextData.getFrameCount();
                            if (state == null) {
                                state = new ThreadState();
                            }
                            state.stopAtFrameDepth = stopAtFrameDepth;
                            this.threadState.put(thread, state);
                            break;
                        }
                        case 1: {
                            contextData.breakNextLine = true;
                            if (state == null) break;
                            state.stopAtFrameDepth = -1;
                            break;
                        }
                        case 2: {
                            stopAtFrameDepth = contextData.getFrameCount() - 1;
                            if (stopAtFrameDepth <= 0) break;
                            contextData.breakNextLine = true;
                            if (state == null) {
                                state = new ThreadState();
                            }
                            state.stopAtFrameDepth = stopAtFrameDepth;
                            this.threadState.put(thread, state);
                            break;
                        }
                        case 5: {
                            contextData.breakNextLine = true;
                            if (state == null) break;
                            state.stopAtFrameDepth = -1;
                        }
                    }
                }
            }
        }
        object = this.swingMonitor;
        synchronized (object) {
            this.isInterrupted = false;
            if (SwingUtilities.isEventDispatchThread()) {
                --this.dispatcherIsWaiting;
            } else {
                this.nonDispatcherWaiting = false;
            }
            this.swingMonitor.notifyAll();
        }
    }

    String chooseFile(String title) {
        int returnVal;
        this.dlg.setDialogTitle(title);
        File CWD = null;
        String dir = System.getProperty("user.dir");
        if (dir != null) {
            CWD = new File(dir);
        }
        if (CWD != null) {
            this.dlg.setCurrentDirectory(CWD);
        }
        if ((returnVal = this.dlg.showOpenDialog(this)) == 0) {
            try {
                String result = this.dlg.getSelectedFile().getCanonicalPath();
                CWD = this.dlg.getSelectedFile().getParentFile();
                Properties props = System.getProperties();
                props.put("user.dir", CWD.getPath());
                System.setProperties(props);
                return result;
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    JInternalFrame getSelectedFrame() {
        JInternalFrame[] frames = this.desk.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isShowing()) continue;
            return frames[i];
        }
        return frames[frames.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void actionPerformed(ActionEvent e) {
        JDialog dlg;
        FileWindow w;
        String cmd = e.getActionCommand();
        int returnValue = -1;
        if (cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste")) {
            JInternalFrame f = this.getSelectedFrame();
            if (f != null && f instanceof ActionListener) {
                ((ActionListener)((Object)f)).actionPerformed(e);
            }
        } else if (cmd.equals("Step Over")) {
            returnValue = 0;
        } else if (cmd.equals("Step Into")) {
            returnValue = 1;
        } else if (cmd.equals("Step Out")) {
            returnValue = 2;
        } else if (cmd.equals("Go")) {
            returnValue = 3;
        } else if (cmd.equals("Break")) {
            this.doBreak();
        } else if (cmd.equals("Run to Cursor")) {
            returnValue = 5;
        } else if (cmd.equals("Exit")) {
            this.Exit();
        } else if (cmd.equals("Open")) {
            String fileName = this.chooseFile("Select a file to compile");
            if (fileName != null) {
                new Thread(new OpenFile(this, fileName)).start();
            }
        } else if (cmd.equals("Load")) {
            Scriptable scope = this.getScope();
            if (scope == null) {
                MessageDialogWrapper.showMessageDialog(this, "Can't run scripts: no scope available", "Run", 0);
            } else {
                String fileName = this.chooseFile("Select a file to execute");
                if (fileName != null) {
                    new Thread(new LoadFile(this, scope, fileName)).start();
                }
            }
        } else if (cmd.equals("Run")) {
            w = (FileWindow)this.getSelectedFrame();
            if (w != null) {
                w.load();
            }
        } else if (cmd.equals("Save")) {
            w = (FileWindow)this.getSelectedFrame();
            if (w != null) {
                w.save();
            }
        } else if (cmd.equals("More Windows...")) {
            dlg = new MoreWindows(this, this.fileWindows, "Window", "Files");
            ((MoreWindows)dlg).showDialog(this);
        } else if (cmd.equals("Console")) {
            if (this.console.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(this.console);
            }
            this.console.show();
            this.desk.getDesktopManager().activateFrame(this.console);
            this.console.consoleTextArea.requestFocus();
        } else if (!(cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste"))) {
            JInternalFrame[] frames;
            if (cmd.equals("Go to function...")) {
                dlg = new FindFunction(this, this.functionNames, "Go to function", "Function");
                ((FindFunction)dlg).showDialog(this);
            } else if (cmd.equals("Tile")) {
                frames = this.desk.getAllFrames();
                int count = frames.length;
                int cols = (int)Math.sqrt(count);
                int rows = cols;
                if (rows * cols < count && rows * ++cols < count) {
                    ++rows;
                }
                Dimension size = this.desk.getSize();
                int w2 = size.width / cols;
                int h = size.height / rows;
                int x = 0;
                int y = 0;
                for (int i2 = 0; i2 < rows; ++i2) {
                    int index;
                    for (int j = 0; j < cols && (index = i2 * cols + j) < frames.length; ++j) {
                        JInternalFrame f = frames[index];
                        try {
                            f.setIcon(false);
                            f.setMaximum(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.desk.getDesktopManager().setBoundsForFrame(f, x, y, w2, h);
                        x += w2;
                    }
                    y += h;
                    x = 0;
                }
            } else if (cmd.equals("Cascade")) {
                frames = this.desk.getAllFrames();
                int count = frames.length;
                int y = 0;
                int x = 0;
                int h = this.desk.getHeight();
                int d = h / count;
                if (d > 30) {
                    d = 30;
                }
                int i = count - 1;
                while (i >= 0) {
                    JInternalFrame f = frames[i];
                    try {
                        f.setIcon(false);
                        f.setMaximum(false);
                    }
                    catch (Exception i2) {
                        // empty catch block
                    }
                    Dimension dimen = f.getPreferredSize();
                    int w3 = dimen.width;
                    h = dimen.height;
                    this.desk.getDesktopManager().setBoundsForFrame(f, x, y, w3, h);
                    --i;
                    x += d;
                    y += d;
                }
            } else {
                FileWindow obj = this.getFileWindow(cmd);
                if (obj != null) {
                    FileWindow w4 = obj;
                    try {
                        if (w4.isIcon()) {
                            w4.setIcon(false);
                        }
                        w4.setVisible(true);
                        w4.moveToFront();
                        w4.setSelected(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (returnValue != -1) {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            Object object = this.monitor;
            synchronized (object) {
                this.returnValue = returnValue;
                this.monitor.notify();
            }
        }
    }

    void runToCursor(String fileName, int lineNumber, ActionEvent evt) {
        SourceInfo si = (SourceInfo)this.sourceNames.get(fileName);
        if (si == null) {
            System.out.println("debugger error: Couldn't find source: " + fileName);
        }
        if (si.breakableLine(lineNumber)) {
            this.runToCursorFile = fileName;
            this.runToCursorLine = lineNumber;
            this.actionPerformed(evt);
        }
    }

    JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    void removeWindow(FileWindow w) {
        this.fileWindows.remove(w.getUrl());
        JMenu windowMenu = this.getWindowMenu();
        int count = windowMenu.getItemCount();
        JMenuItem lastItem = windowMenu.getItem(count - 1);
        String name = SourceInfo.getShortName(w.getUrl());
        for (int i = 5; i < count; ++i) {
            int pos;
            String text;
            JMenuItem item = windowMenu.getItem(i);
            if (item == null || !(text = item.getText()).substring((pos = text.indexOf(32)) + 1).equals(name)) continue;
            windowMenu.remove(item);
            if (count == 6) {
                windowMenu.remove(4);
                break;
            }
            int j = i - 4;
            while (i < count - 1) {
                JMenuItem thisItem = windowMenu.getItem(i);
                if (thisItem != null) {
                    text = thisItem.getText();
                    if (text.equals("More Windows...")) break;
                    pos = text.indexOf(32);
                    thisItem.setText((char)(48 + j) + " " + text.substring(pos + 1));
                    thisItem.setMnemonic(48 + j);
                    ++j;
                }
                ++i;
            }
            if (count - 6 != 0 || lastItem == item || !lastItem.getText().equals("More Windows...")) break;
            windowMenu.remove(lastItem);
            break;
        }
        windowMenu.revalidate();
    }

    boolean stringIsCompilableUnit(String expr) {
        Context cx = Context.enter();
        boolean result = cx.stringIsCompilableUnit(expr);
        cx.exit();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String eval(String expr) {
        String resultString;
        Context cx = this.getCurrentContext();
        if (cx == null) {
            return "undefined";
        }
        ContextData contextData = ContextData.get(cx);
        ContextHelper helper = new ContextHelper();
        helper.attach(cx);
        if (this.frameIndex >= contextData.getFrameCount()) {
            helper.reset();
            return "undefined";
        }
        cx.setDebugger(null, null);
        cx.setGeneratingDebug(false);
        cx.setOptimizationLevel(-1);
        boolean savedBreakNextLine = contextData.breakNextLine;
        contextData.breakNextLine = false;
        try {
            Object result;
            Script script;
            int savedLevel = cx.getOptimizationLevel();
            try {
                cx.setOptimizationLevel(-1);
                script = cx.compileString(expr, "", 0, null);
            }
            finally {
                cx.setOptimizationLevel(savedLevel);
            }
            FrameHelper frame = contextData.getFrame(this.frameIndex);
            Scriptable scope = frame.getVariableObject();
            if (scope instanceof NativeCall && script instanceof Function) {
                NativeCall call = (NativeCall)scope;
                Function f = (Function)((Object)script);
                result = f.call(cx, scope, call.getThisObj(), ScriptRuntime.emptyArgs);
            } else {
                result = script.exec(cx, scope);
            }
            if (result == Undefined.instance) {
                result = "";
            }
            try {
                resultString = ScriptRuntime.toString(result);
            }
            catch (RuntimeException exc) {
                resultString = result.toString();
            }
        }
        catch (Exception exc) {
            resultString = exc.getMessage();
        }
        if (resultString == null) {
            resultString = "null";
        }
        cx.setDebugger(this, contextData);
        cx.setGeneratingDebug(true);
        cx.setOptimizationLevel(-1);
        contextData.breakNextLine = savedBreakNextLine;
        helper.reset();
        return resultString;
    }

    void Exit() {
        this.returnValue = 6;
        if (this.exitAction != null) {
            Main.swingInvokeLater(this.exitAction);
        }
    }

    static void setResizeWeight(JSplitPane pane, double weight) {
        try {
            Method m = JSplitPane.class.getMethod("setResizeWeight", Double.TYPE);
            m.invoke((Object)pane, new Double(weight));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    boolean shouldDispatchTo(Component source) {
        Component root = SwingUtilities.getRoot(source);
        if (root == this) {
            return true;
        }
        Enumeration e = this.toplevels.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            JFrame frame = (JFrame)this.toplevels.get(key);
            if (root != frame) continue;
            return true;
        }
        return false;
    }

    void addTopLevel(String key, JFrame frame) {
        if (frame != this) {
            this.toplevels.put(key, frame);
        }
    }

    JInternalFrame getFrameForUrl(URL url) {
        JInternalFrame[] frames = this.desk.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            FileWindow w = (FileWindow)frames[i];
            if (!url.toString().equals(w.getUrl())) continue;
            return w;
        }
        return null;
    }

    public void highlighLineInSelectedWindow(URL url, int lineNum) {
        FileWindow w = (FileWindow)this.getSelectedFrame();
        if (w != null && lineNum > -1) {
            Main.swingInvoke(new SetFilePosition(this, w, lineNum));
        }
    }

    public Object runSelectedWindow(URL scriptUrl) throws Exception {
        Object result = null;
        FileWindow w = (FileWindow)this.getSelectedFrame();
        w.toFront();
        if (w != null) {
            Scriptable scope = w.db.getScope();
            if (scope == null) {
                MessageDialogWrapper.showMessageDialog(w.db, "Can't load scripts: no scope available", "Run", 0);
                result = null;
            } else {
                String url = w.getUrl();
                Object executorThread = null;
                if (url != null) {
                    LoadFile executor = new LoadFile(w.db, scope, url, new StringReader(w.textArea.getText()), true);
                    executor.run();
                    result = executor.result;
                    if (executor.exception != null) {
                        throw executor.exception;
                    }
                }
            }
        }
        return result;
    }

    public Main(String title) {
        super(title);
        this.init();
    }

    public void setBreakOnExceptions(boolean value) {
        this.breakOnExceptions = value;
    }

    public void setBreakOnEnter(boolean value) {
        this.breakOnEnter = value;
    }

    public void setBreakOnReturn(boolean value) {
        this.breakOnReturn = value;
    }

    public void clearAllBreakpoints() {
        Enumeration e = this.sourceNames.elements();
        while (e.hasMoreElements()) {
            SourceInfo si = (SourceInfo)e.nextElement();
            si.removeAllBreakpoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        this.returnValue = 3;
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = this.returnValue;
            this.monitor.notifyAll();
        }
    }

    public void setScopeProvider(ScopeProvider p) {
        this.scopeProvider = p;
    }

    public void setExitAction(Runnable r) {
        this.exitAction = r;
    }

    public InputStream getIn() {
        return this.console.getIn();
    }

    public PrintStream getOut() {
        return this.console.getOut();
    }

    public PrintStream getErr() {
        return this.console.getErr();
    }

    public void openFile(URL scriptUrl, Scriptable scope, Runnable closeCallback) {
        if (scope == null) {
            MessageDialogWrapper.showMessageDialog(this, "Can't compile scripts: no scope available", "Open", 0);
        } else if (scriptUrl != null) {
            try {
                InputStreamReader reader = new InputStreamReader(scriptUrl.openStream());
                String fileName = null;
                fileName = scriptUrl.getProtocol().startsWith("vnd.sun.star.") ? scriptUrl.toString() : scriptUrl.getPath();
                this.officeScripts.addScript(fileName, scriptUrl, scope, closeCallback);
                Main.swingInvoke(new OpenFile(this, fileName, reader));
            }
            catch (IOException e) {
                MessageDialogWrapper.showMessageDialog(this, "Can't open stream for script: " + e.toString(), "Open", 0);
            }
        }
        this.split1.setDividerLocation(1.0);
    }

    public void openFile(String fileName) {
        Scriptable scope = this.getScope();
        if (scope == null) {
            MessageDialogWrapper.showMessageDialog(this, "Can't compile scripts: no scope available", "Open", 0);
        } else if (fileName != null) {
            new Thread(new OpenFile(this, fileName)).start();
        }
        this.split1.setDividerLocation(1.0);
    }

    public void openStream(InputStream in) {
        Scriptable scope = this.getScope();
        if (scope == null) {
            MessageDialogWrapper.showMessageDialog(this, "Can't compile scripts: no scope available", "Open", 0);
        } else if (in != null) {
            new Thread(new OpenFile(this, null, new InputStreamReader(in))).start();
        }
        this.split1.setDividerLocation(1.0);
        this.menubar.setSaveEnabled(false);
    }

    public static void main(String[] args) {
        try {
            mainThread = Thread.currentThread();
            final Main sdb = new Main("Rhino JavaScript Debugger");
            Main.swingInvoke(new Runnable(){

                @Override
                public void run() {
                    sdb.pack();
                    sdb.setSize(600, 460);
                    sdb.setVisible(true);
                }
            });
            sdb.setExitAction(new Runnable(){

                @Override
                public void run() {
                    System.exit(0);
                }
            });
            System.setIn(sdb.getIn());
            System.setOut(sdb.getOut());
            System.setErr(sdb.getErr());
            Context.addContextListener(sdb);
            sdb.setScopeProvider(new ScopeProvider(){

                @Override
                public Scriptable getScope() {
                    return org.mozilla.javascript.tools.shell.Main.getScope();
                }
            });
            org.mozilla.javascript.tools.shell.Main.exec(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeScript(String url) {
        this.fileWindows.remove(url);
        Hashtable hashtable = this.sourceNames;
        synchronized (hashtable) {
            this.sourceNames.remove(url);
        }
        hashtable = this.scriptItems;
        synchronized (hashtable) {
            for (Map.Entry me : this.scriptItems.entrySet()) {
                ScriptItem item = (ScriptItem)me.getValue();
                SourceInfo si = item.getSourceInfo();
                if (!si.getUrl().equals(url)) continue;
                this.scriptItems.remove(me.getKey());
                break;
            }
        }
        this.officeScripts.deleteScript(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScriptItem getScriptItem(DebuggableScript fnOrScript) {
        ScriptItem item = (ScriptItem)this.scriptItems.get(fnOrScript);
        if (item == null) {
            String url = this.getNormilizedUrl(fnOrScript);
            SourceInfo si = (SourceInfo)this.sourceNames.get(url);
            if (si == null && !fnOrScript.isGeneratedScript()) {
                String source = null;
                try (InputStream is = Main.openSource(url);){
                    source = Main.readSource(is);
                }
                catch (IOException ex) {
                    System.err.println("Failed to load source from " + url + ": " + ex);
                }
                if (source != null) {
                    si = this.registerSource(url, source);
                }
            }
            if (si != null) {
                item = this.registerScript(si, fnOrScript);
            }
        }
        return item;
    }

    public void showScriptWindow(URL url) {
        FileWindow w;
        String key = url.getPath();
        if (url.getProtocol().startsWith("vnd.sun.star")) {
            key = url.toString();
        }
        if ((w = this.getFileWindow(key)) != null) {
            this.desk.getDesktopManager().deiconifyFrame(w);
            this.desk.getDesktopManager().activateFrame(w);
            w.show();
            w.toFront();
        }
    }

    public void highlighLineInScriptWindow(URL url, int lineNum) {
        FileWindow w;
        String key = url.getPath();
        if (url.getProtocol().startsWith("vnd.sun.star")) {
            key = url.getPath();
        }
        if ((w = this.getFileWindow(key)) != null && lineNum > -1) {
            Main.swingInvoke(new SetFilePosition(this, w, lineNum));
        }
    }

    public Object runScriptWindow(URL scriptUrl) throws Exception {
        String key = scriptUrl.getPath();
        if (scriptUrl.getProtocol().startsWith("vnd.sun.star")) {
            key = scriptUrl.toString();
        }
        FileWindow w = this.getFileWindow(key);
        Object result = null;
        w.toFront();
        if (w != null) {
            Scriptable scope = w.db.officeScripts.getScriptScope(key);
            if (scope == null) {
                MessageDialogWrapper.showMessageDialog(w.db, "Can't load scripts: no scope available", "Run", 0);
                result = null;
            } else {
                String url = w.getUrl();
                Object executorThread = null;
                if (url != null) {
                    LoadFile executor = new LoadFile(w.db, scope, url, new StringReader(w.textArea.getText()), true);
                    executor.run();
                    result = executor.result;
                    if (executor.exception != null) {
                        throw executor.exception;
                    }
                }
            }
        }
        return result;
    }

    public boolean isModified(URL url) {
        String key = url.getPath();
        if (url.getProtocol().startsWith("vnd.sun.star")) {
            key = url.toString();
        }
        FileWindow w = this.getFileWindow(key);
        return w.isModified();
    }

    public String getText(URL url) {
        String key = url.toString();
        if (url.getProtocol().startsWith("vnd.sun.star")) {
            key = url.toString();
        }
        FileWindow w = this.getFileWindow(key);
        return w.getText();
    }

    class ThreadState {
        private int stopAtFrameDepth = -1;

        ThreadState() {
        }
    }
}

