/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.GlobalMasterRow;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerUtil;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.jfree.report.util.TextUtilities;
import org.libreoffice.report.pentaho.layoutprocessor.AbstractReportElementLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.FormatValueUtility;
import org.libreoffice.report.pentaho.layoutprocessor.ImageElementContext;
import org.libreoffice.report.pentaho.model.ImageElement;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class ImageElementLayoutController
extends AbstractReportElementLayoutController {
    private static final Log LOGGER = LogFactory.getLog(ImageElementLayoutController.class);
    private ImageElementContext context;

    @Override
    protected LayoutController delegateContentGeneration(ReportTarget reportTarget) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        ImageElement imageElement = (ImageElement)((Object)this.getNode());
        FormulaExpression formulaExpression = imageElement.getFormula();
        if (formulaExpression == null) {
            String string = imageElement.getImageData();
            this.generateImage(reportTarget, string, imageElement.getScaleMode(), imageElement.isPreserveIRI());
        } else {
            Object object = LayoutControllerUtil.evaluateExpression((FlowController)this.getFlowController(), (Object)((Object)imageElement), (Expression)formulaExpression);
            this.generateImage(reportTarget, object, imageElement.getScaleMode(), imageElement.isPreserveIRI());
        }
        return this.join(this.getFlowController());
    }

    private void generateImage(ReportTarget reportTarget, Object object, String string, boolean bl) throws ReportProcessingException, DataSourceException {
        if (object == null) {
            return;
        }
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "namespace", (Object)"http://jfreereport.sourceforge.net/namespaces/engine");
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "type", (Object)"image");
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "scale", (Object)string);
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "preserve-IRI", (Object)String.valueOf(bl));
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "image-context", (Object)this.createContext());
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "image-data", object);
        reportTarget.startElement(attributeMap);
        reportTarget.endElement(attributeMap);
    }

    protected ImageElementContext createContext() {
        if (this.context == null) {
            LayoutController layoutController = this.findParentCell();
            if (layoutController == null) {
                LOGGER.warn((Object)"Image is not contained in a table. Unable to calculate the image-size.");
                return null;
            }
            Element element = (Element)layoutController.getNode();
            int n = TextUtilities.parseInt((String)((String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-rows-spanned")), (int)1);
            int n2 = TextUtilities.parseInt((String)((String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-spanned")), (int)1);
            if (n < 1 || n2 < 1) {
                LOGGER.warn((Object)"Rowspan or colspan for image-size calculation was invalid.");
                return null;
            }
            LayoutController layoutController2 = layoutController.getParent();
            if (layoutController2 == null) {
                LOGGER.warn((Object)"Table-Cell has no parent. Unable to calculate the image-size.");
                return null;
            }
            Section section = (Section)layoutController2.getNode();
            int n3 = this.findNodeInSection(section, element, "covered-table-cell");
            if (n3 == -1) {
                LOGGER.warn((Object)"Table-Cell is not a direct child of the table-row. Unable to calculate the image-size.");
                return null;
            }
            LayoutController layoutController3 = layoutController2.getParent();
            if (layoutController3 == null) {
                LOGGER.warn((Object)"Table-Row has no Table. Unable to calculate the image-size.");
                return null;
            }
            Section section2 = (Section)layoutController3.getNode();
            Section section3 = (Section)section2.findFirstChild("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-columns");
            if (section3.getNodeCount() <= n3 + n2) {
                LOGGER.warn((Object)"The Table's defined columns do not match the col-span or col-position. Unable to calculate the image-size.");
                return null;
            }
            ImageElementContext imageElementContext = new ImageElementContext(n2, n);
            this.addColumnStyles(imageElementContext, section3, n3, n2);
            int n4 = this.findNodeInSection(section2, (Element)section, null);
            if (n4 == -1) {
                LOGGER.warn((Object)"Table-Cell is not a direct child of the table-row. Unable to calculate the image-size.");
                return null;
            }
            this.addRowStyles(imageElementContext, section2, n4, n);
            this.context = imageElementContext;
        }
        return this.context;
    }

    private int findNodeInSection(Section section, Element element, String string) {
        int n = 0;
        Node[] nodeArray = section.getNodeArray();
        String string2 = element.getNamespace();
        String string3 = element.getType();
        for (Node node : nodeArray) {
            Element element2;
            if (!(node instanceof Element) || !ObjectUtilities.equal((Object)(element2 = (Element)node).getNamespace(), (Object)string2) || !ObjectUtilities.equal((Object)element2.getType(), (Object)string3) && (string == null || !ObjectUtilities.equal((Object)element2.getType(), (Object)string))) continue;
            if (node == element) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private LayoutController findParentCell() {
        for (LayoutController layoutController = this.getParent(); layoutController != null; layoutController = layoutController.getParent()) {
            Element element;
            Object object = layoutController.getNode();
            if (!(object instanceof Element) || !"urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals((element = (Element)object).getNamespace()) || !"table-cell".equals(element.getType())) continue;
            return layoutController;
        }
        return null;
    }

    @Override
    public boolean isValueChanged() {
        ImageElement imageElement = (ImageElement)((Object)this.getNode());
        FormulaExpression formulaExpression = imageElement.getFormula();
        if (formulaExpression == null) {
            FlowController flowController = this.getFlowController();
            GlobalMasterRow globalMasterRow = flowController.getMasterRow();
            ReportDataRow reportDataRow = globalMasterRow.getReportDataRow();
            return reportDataRow.getCursor() == 0;
        }
        try {
            Formula formula = formulaExpression.getCompiledFormula();
            LValue lValue = formula.getRootReference();
            return FormatValueUtility.isReferenceChanged((LayoutController)this, lValue);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    void addColumnStyles(ImageElementContext imageElementContext, Section section, int n, int n2) {
        Node[] nodeArray = section.getNodeArray();
        int n3 = 0;
        for (Node node : nodeArray) {
            Element element = (Element)node;
            if (!ObjectUtilities.equal((Object)element.getNamespace(), (Object)"urn:oasis:names:tc:opendocument:xmlns:table:1.0") || !ObjectUtilities.equal((Object)element.getType(), (Object)"table-column")) continue;
            if (n3 >= n) {
                String string = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
                imageElementContext.setColStyle(n3 - n, string);
            }
            if (++n3 >= n + n2) break;
        }
    }

    void addRowStyles(ImageElementContext imageElementContext, Section section, int n, int n2) {
        Node[] nodeArray = section.getNodeArray();
        int n3 = 0;
        for (Node node : nodeArray) {
            Element element = (Element)node;
            if (!ObjectUtilities.equal((Object)element.getNamespace(), (Object)"urn:oasis:names:tc:opendocument:xmlns:table:1.0") || !ObjectUtilities.equal((Object)element.getType(), (Object)"table-row")) continue;
            if (n3 >= n) {
                String string = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
                imageElementContext.setRowStyle(n3 - n, string);
            }
            if (++n3 >= n + n2) break;
        }
    }
}

