/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.unoloader;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public final class UnoClassLoader
extends URLClassLoader {
    public UnoClassLoader(URL uRL, URL[] uRLArray, ClassLoader classLoader) throws MalformedURLException {
        super(UnoClassLoader.createUrls(uRL, uRLArray), classLoader);
    }

    public ClassLoader getClassLoader(URL uRL, Attributes attributes) throws MalformedURLException {
        String string;
        String string2 = string = attributes == null ? null : attributes.getValue("UNO-Type-Path");
        if (string == null) {
            string = "<>";
        }
        int n = 0;
        while (n < string.length()) {
            String string3;
            int n2;
            while (n < string.length() && string.charAt(n) == ' ') {
                ++n;
            }
            if (n >= string.length()) continue;
            if (string.charAt(n) == '<') {
                n2 = string.indexOf(62, n + 1);
                if (n2 < 0) {
                    string3 = string.substring(n + 1);
                    n = string.length();
                } else {
                    string3 = string.substring(n + 1, n2);
                    n = n2 + 1;
                }
            } else {
                n2 = string.indexOf(32, n + 1);
                if (n2 < 0) {
                    n2 = string.length();
                }
                string3 = string.substring(n, n2);
                n = n2;
            }
            this.addURL(new URL(uRL, string3));
        }
        return URLClassLoader.newInstance(new URL[]{uRL}, this);
    }

    public void execute(URL uRL, String[] stringArray) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String string;
        Attributes attributes = UnoClassLoader.getJarMainAttributes(uRL);
        String string2 = string = attributes == null ? null : attributes.getValue(Attributes.Name.MAIN_CLASS);
        if (string == null) {
            throw new ClassNotFoundException(uRL + " does not specify a main class");
        }
        try {
            this.getClassLoader(uRL, attributes).loadClass(string.replace('/', '.')).getMethod("main", String[].class).invoke(null, new Object[]{stringArray});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("impossible " + illegalAccessException);
        }
    }

    public static Attributes getJarMainAttributes(URL uRL) throws IOException {
        Manifest manifest;
        try (JarInputStream jarInputStream = new JarInputStream(uRL.openStream());){
            manifest = jarInputStream.getManifest();
        }
        return manifest == null ? null : manifest.getMainAttributes();
    }

    private static URL[] createUrls(URL uRL, URL[] uRLArray) throws MalformedURLException {
        URL[] uRLArray2 = new URL[4 + (uRLArray == null ? 0 : uRLArray.length)];
        uRLArray2[0] = new URL(uRL, "java_uno.jar");
        uRLArray2[1] = new URL(uRL, "juh.jar");
        uRLArray2[2] = new URL(uRL, "jurt.jar");
        uRLArray2[3] = new URL(uRL, "ridl.jar");
        if (uRLArray != null) {
            System.arraycopy(uRLArray, 0, uRLArray2, 4, uRLArray.length);
        }
        return uRLArray2;
    }
}

