/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class DateDifFunction
implements Function {
    public static final String YEARS_CODE = "y";
    public static final String MONTHS_CODE = "m";
    public static final String DAYS_CODE = "d";
    public static final String DAYS_IGNORING_YEARS = "yd";
    public static final String MONTHS_IGNORING_YEARS = "ym";
    public static final String DAYS_IGNORING_MONTHS_YEARS = "md";
    private static final long serialVersionUID = 81013707499607068L;

    @Override
    public String getCanonicalName() {
        return "DATEDIF";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int res;
        if (parameters.getParameterCount() != 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        String formatCode = typeRegistry.convertToText(parameters.getType(2), parameters.getValue(2));
        if (formatCode == null || "".equals(formatCode)) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (DAYS_CODE.equals(formatCode)) {
            Number date1 = typeRegistry.convertToNumber(parameters.getType(0), parameters.getValue(0));
            Number date2 = typeRegistry.convertToNumber(parameters.getType(1), parameters.getValue(1));
            BigDecimal dn1 = NumberUtil.performIntRounding(NumberUtil.getAsBigDecimal(date1));
            BigDecimal dn2 = NumberUtil.performIntRounding(NumberUtil.getAsBigDecimal(date2));
            return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(dn2.longValue() - dn1.longValue()));
        }
        Date date1 = typeRegistry.convertToDate(parameters.getType(0), parameters.getValue(0));
        Date date2 = typeRegistry.convertToDate(parameters.getType(1), parameters.getValue(1));
        if (date1 == null || date2 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        LocalizationContext localizationContext = context.getLocalizationContext();
        TimeZone timeZone = localizationContext.getTimeZone();
        Locale locale = localizationContext.getLocale();
        GregorianCalendar calandar1 = new GregorianCalendar(timeZone, locale);
        calandar1.setTime(date1);
        GregorianCalendar calandar2 = new GregorianCalendar(timeZone, locale);
        calandar2.setTime(date2);
        if (YEARS_CODE.equals(formatCode)) {
            res = Math.abs(calandar2.get(1) - calandar1.get(1));
        } else if (MONTHS_CODE.equals(formatCode)) {
            int month1 = calandar1.get(2);
            int month2 = calandar2.get(2);
            int year1 = calandar1.get(1);
            int year2 = calandar2.get(1);
            res = Math.abs(year2 - year1) * 12 + Math.abs(month2 - month1);
        } else if (DAYS_IGNORING_MONTHS_YEARS.equals(formatCode)) {
            calandar1.set(1, calandar2.get(1));
            calandar1.set(2, calandar2.get(2));
            res = Math.abs(calandar2.get(5) - calandar1.get(5));
        } else if (MONTHS_IGNORING_YEARS.equals(formatCode)) {
            int month1 = calandar1.get(2);
            int month2 = calandar2.get(2);
            res = Math.abs(month2 - month1);
        } else if (DAYS_IGNORING_YEARS.equals(formatCode)) {
            calandar1.set(1, calandar2.get(1));
            int dayOne = calandar1.get(6);
            int dayTwo = calandar2.get(6);
            res = Math.abs(dayOne - dayTwo);
        } else {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal((double)res));
    }
}

