/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XDialog;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.MainThreadDialogExecutor;
import com.sun.star.wiki.Settings;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiDialog;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;

public class WikiEditSettingDialog
extends WikiDialog {
    private static final String sOKMethod = "OK";
    private final String[] Methods = new String[]{"OK"};
    private final Map<String, String> setting;
    private final boolean addMode;
    private boolean m_bAllowURLChange = true;

    public WikiEditSettingDialog(XComponentContext xContext, String DialogURL) {
        super(xContext, DialogURL);
        super.setMethods(this.Methods);
        this.setting = new HashMap<String, String>();
        this.addMode = true;
        this.InsertThrobber(184, 20, 10, 10);
        this.InitStrings(xContext);
        this.InitSaveCheckbox(xContext, false);
    }

    public WikiEditSettingDialog(XComponentContext xContext, String DialogURL, Map<String, String> ht, boolean bAllowURLChange) {
        super(xContext, DialogURL);
        super.setMethods(this.Methods);
        this.setting = ht;
        boolean bInitSaveCheckBox = false;
        try {
            XPropertySet xUrlField = this.GetPropSet("UrlField");
            xUrlField.setPropertyValue("Text", (Object)ht.get("Url"));
            this.GetPropSet("UsernameField").setPropertyValue("Text", (Object)ht.get("Username"));
            if (Helper.PasswordStoringIsAllowed(this.m_xContext)) {
                String[] pPasswords = Helper.GetPasswordsForURLAndUser(this.m_xContext, ht.get("Url"), ht.get("Username"));
                bInitSaveCheckBox = pPasswords != null && pPasswords.length > 0 && pPasswords[0].equals(ht.get("Password"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.addMode = false;
        this.m_bAllowURLChange = bAllowURLChange;
        this.InsertThrobber(184, 20, 10, 10);
        this.InitStrings(xContext);
        this.InitSaveCheckbox(xContext, bInitSaveCheckBox);
    }

    @Override
    public boolean show() {
        this.SetThrobberVisible(false);
        this.EnableControls(true);
        boolean bResult = super.show();
        try {
            if (bResult && Helper.PasswordStoringIsAllowed(this.m_xContext) && (Short)this.GetPropSet("SaveBox").getPropertyValue("State") != 0) {
                String sURL = this.setting.get("Url");
                String sUserName = this.setting.get("Username");
                String sPassword = this.setting.get("Password");
                if (sURL != null && sURL.length() > 0 && sUserName != null && sUserName.length() > 0 && sPassword != null && sPassword.length() > 0) {
                    String[] pPasswords = new String[]{sPassword};
                    Helper.GetPasswordContainer(this.m_xContext).addPersistent(sURL, sUserName, pPasswords, Helper.GetInteractionHandler(this.m_xContext));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bResult;
    }

    private void EnableControls(boolean bEnable) {
        if (!bEnable) {
            this.SetFocusTo("CancelButton");
        }
        try {
            this.GetPropSet("UsernameField").setPropertyValue("Enabled", (Object)bEnable);
            this.GetPropSet("PasswordField").setPropertyValue("Enabled", (Object)bEnable);
            this.GetPropSet("OkButton").setPropertyValue("Enabled", (Object)bEnable);
            this.GetPropSet("HelpButton").setPropertyValue("Enabled", (Object)bEnable);
            if (bEnable) {
                this.GetPropSet("UrlField").setPropertyValue("Enabled", (Object)this.m_bAllowURLChange);
                this.GetPropSet("SaveBox").setPropertyValue("Enabled", (Object)Helper.PasswordStoringIsAllowed(this.m_xContext));
                if (this.m_bAllowURLChange) {
                    this.SetFocusTo("UrlField");
                } else {
                    this.SetFocusTo("UsernameField");
                }
            } else {
                this.GetPropSet("UrlField").setPropertyValue("Enabled", (Object)Boolean.FALSE);
                this.GetPropSet("SaveBox").setPropertyValue("Enabled", (Object)Boolean.FALSE);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void InitStrings(XComponentContext xContext) {
        try {
            this.SetTitle(Helper.GetLocalizedString(xContext, 26));
            this.GetPropSet("UrlLabel").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 16));
            this.GetPropSet("UsernameLabel").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 17));
            this.GetPropSet("PasswordLabel").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 18));
            this.GetPropSet("AccountLine").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 27));
            this.GetPropSet("WikiLine").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 28));
            this.GetPropSet("SaveBox").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 29));
            this.GetPropSet("OkButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xContext, 9));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void InitSaveCheckbox(XComponentContext xContext, boolean bInitSaveCheckBox) {
        XPropertySet xSaveCheck = this.GetPropSet("SaveBox");
        try {
            xSaveCheck.setPropertyValue("State", (Object)(bInitSaveCheckBox ? (short)1 : 0));
            xSaveCheck.setPropertyValue("Enabled", (Object)Helper.PasswordStoringIsAllowed(xContext));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void DoLogin() {
        String sRedirectURL = "";
        String sURL = "";
        try {
            sURL = (String)this.GetPropSet("UrlField").getPropertyValue("Text");
            String sUserName = (String)this.GetPropSet("UsernameField").getPropertyValue("Text");
            String sPassword = (String)this.GetPropSet("PasswordField").getPropertyValue("Text");
            boolean bAllowIndex = true;
            do {
                if (sRedirectURL.length() > 0) {
                    sURL = sRedirectURL;
                    sRedirectURL = "";
                }
                if (sURL.length() > 0) {
                    URI aURI = new URI(sURL);
                    HttpURLConnection connGet = Helper.PrepareMethod("GET", aURI, this.m_xContext);
                    connGet.setInstanceFollowRedirects(false);
                    connGet.connect();
                    int nResultCode = connGet.getResponseCode();
                    String sWebPage = null;
                    if (nResultCode == 200) {
                        sWebPage = Helper.ReadResponseBody(connGet);
                    } else if (nResultCode >= 301 && nResultCode <= 303 || nResultCode == 307) {
                        sRedirectURL = connGet.getHeaderField("Location");
                    }
                    if (sWebPage != null && sWebPage.length() > 0) {
                        String sMainURL = Helper.GetMainURL(sWebPage, sURL);
                        if (sMainURL.length() == 0) {
                            sRedirectURL = Helper.GetRedirectURL(sWebPage, sURL);
                            if (sRedirectURL.length() != 0) continue;
                            Helper.ShowError(this.m_xContext, this.m_xDialog, 26, 2, sURL, false);
                            continue;
                        }
                        URI aMainURI = new URI(sMainURL);
                        if (!(sUserName.length() <= 0 && sPassword.length() <= 0 || Helper.Login(aMainURI, sUserName, sPassword, this.m_xContext))) {
                            Helper.ShowError(this.m_xContext, this.m_xDialog, 26, 3, null, false);
                            continue;
                        }
                        this.setting.put("Url", aMainURI.toASCIIString());
                        this.setting.put("Username", sUserName);
                        this.setting.put("Password", sPassword);
                        if (this.addMode) {
                            Settings.getSettings(this.m_xContext).addWikiCon(this.setting);
                            Settings.getSettings(this.m_xContext).storeConfiguration();
                        }
                        this.m_bAction = true;
                        continue;
                    }
                    if (sRedirectURL != null && sRedirectURL.length() != 0) continue;
                    if (sURL.length() > 0 && !sURL.endsWith("index.php") && bAllowIndex) {
                        sRedirectURL = sURL + "/index.php";
                        bAllowIndex = false;
                        continue;
                    }
                    Helper.ShowError(this.m_xContext, this.m_xDialog, 26, 4, null, false);
                    continue;
                }
                Helper.ShowError(this.m_xContext, this.m_xDialog, 26, 5, null, false);
            } while (sRedirectURL != null && sRedirectURL.length() > 0);
        }
        catch (WikiCancelException sUserName) {
        }
        catch (SSLException essl) {
            if (Helper.IsConnectionAllowed()) {
                Helper.ShowError(this.m_xContext, this.m_xDialog, 26, 25, null, false);
            }
            essl.printStackTrace();
        }
        catch (Exception ex) {
            if (Helper.IsConnectionAllowed()) {
                Helper.ShowError(this.m_xContext, this.m_xDialog, 26, 2, sURL, false);
            }
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean callHandlerMethod(XDialog xDialog, Object EventObject2, String MethodName) {
        if (MethodName.equals(sOKMethod)) {
            this.EnableControls(false);
            this.SetThrobberVisible(true);
            this.SetThrobberActive(true);
            if (Helper.AllowThreadUsage(this.m_xContext)) {
                final XDialog xDialogForThread = xDialog;
                final XComponentContext xContext = this.m_xContext;
                this.m_bThreadFinished = false;
                this.m_aThread = new Thread("com.sun.star.thread.WikiEditorSendingThread"){

                    @Override
                    public void run() {
                        try {
                            Thread.yield();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        WikiEditSettingDialog.this.DoLogin();
                        WikiEditSettingDialog.this.EnableControls(true);
                        WikiEditSettingDialog.this.SetThrobberActive(false);
                        WikiEditSettingDialog.this.SetThrobberVisible(false);
                        WikiEditSettingDialog.this.ThreadStop(true);
                        if (WikiEditSettingDialog.this.m_bAction) {
                            MainThreadDialogExecutor.Close(xContext, xDialogForThread);
                        }
                    }
                };
                this.m_aThread.start();
            } else {
                try {
                    this.DoLogin();
                }
                catch (Exception exception) {
                }
                finally {
                    this.EnableControls(true);
                    this.SetThrobberActive(false);
                    this.SetThrobberVisible(false);
                    if (this.m_bAction) {
                        xDialog.endExecute();
                    }
                    Helper.AllowConnection(true);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void windowClosed(EventObject e) {
        this.ThreadStop(false);
    }
}

