/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LayoutProcessState;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.style.resolver.StyleResolver;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.output.ChainingOutputProcessor;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ChainingLayoutProcess
implements LayoutProcess {
    private LayoutProcess chainedLayoutProcess;
    private ChainingOutputProcessor outputProcessor;
    private InputFeed inputFeed;

    public ChainingLayoutProcess(LayoutProcess layoutProcess) {
        this.chainedLayoutProcess = layoutProcess;
        this.outputProcessor = new ChainingOutputProcessor(layoutProcess.getOutputProcessor());
    }

    @Override
    public InputFeed getInputFeed() {
        if (this.inputFeed == null) {
            this.inputFeed = this.outputProcessor.createInputFeed(this);
        }
        return this.inputFeed;
    }

    @Override
    public StyleResolver getStyleResolver() {
        return this.chainedLayoutProcess.getStyleResolver();
    }

    @Override
    public DocumentContext getDocumentContext() {
        return this.chainedLayoutProcess.getDocumentContext();
    }

    @Override
    public OutputProcessorMetaData getOutputMetaData() {
        return this.chainedLayoutProcess.getOutputMetaData();
    }

    @Override
    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.chainedLayoutProcess.getResourceManager();
    }

    @Override
    public void pageBreakEncountered(CSSValue cSSValue, PseudoPage[] pseudoPageArray) throws NormalizationException {
        this.getInputFeed().handlePageBreakEncountered(cSSValue, pseudoPageArray);
    }

    @Override
    public boolean isPagebreakEncountered() {
        return this.getInputFeed().isPagebreakEncountered();
    }

    public LayoutProcess getChainedLayoutProcess() {
        return this.chainedLayoutProcess;
    }

    public void setChainedLayoutProcess(LayoutProcess layoutProcess) {
        this.chainedLayoutProcess = layoutProcess;
    }

    @Override
    public LayoutProcessState saveState() throws StateException {
        ChainingLayoutProcessState chainingLayoutProcessState = new ChainingLayoutProcessState();
        chainingLayoutProcessState.setInputFeed(this.inputFeed.saveState());
        chainingLayoutProcessState.setChainedLayoutProcess(this.chainedLayoutProcess.saveState());
        return chainingLayoutProcessState;
    }

    @Override
    public Normalizer getNormalizer() {
        if (this.inputFeed == null) {
            throw new IllegalStateException("We cant have come that far without an input feed.");
        }
        return this.inputFeed.getCurrentNormalizer();
    }

    private static class ChainingLayoutProcessState
    implements LayoutProcessState {
        private LayoutProcessState chainedLayoutProcess;
        private State inputFeed;

        private ChainingLayoutProcessState() {
        }

        public LayoutProcessState getChainedLayoutProcess() {
            return this.chainedLayoutProcess;
        }

        public void setChainedLayoutProcess(LayoutProcessState layoutProcessState) {
            this.chainedLayoutProcess = layoutProcessState;
        }

        public State getInputFeed() {
            return this.inputFeed;
        }

        public void setInputFeed(State state) {
            this.inputFeed = state;
        }

        @Override
        public LayoutProcess restore(OutputProcessor outputProcessor) throws StateException {
            LayoutProcess layoutProcess = this.chainedLayoutProcess.restore(outputProcessor);
            ChainingLayoutProcess chainingLayoutProcess = new ChainingLayoutProcess(layoutProcess);
            chainingLayoutProcess.outputProcessor = new ChainingOutputProcessor(outputProcessor);
            if (this.inputFeed != null) {
                chainingLayoutProcess.inputFeed = (InputFeed)this.inputFeed.restore(chainingLayoutProcess);
                if (chainingLayoutProcess.inputFeed == null) {
                    throw new StateException();
                }
            }
            return chainingLayoutProcess;
        }
    }
}

