/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SubSetTableModel
implements TableModel {
    private int start;
    private int end;
    private TableModel model;
    private TableEventTranslator eventHandler;

    public SubSetTableModel(int n, int n2, TableModel tableModel) {
        if (n < 0) {
            throw new IllegalArgumentException("Start < 0");
        }
        if (n2 <= n) {
            throw new IllegalArgumentException("end < start");
        }
        if (tableModel == null) {
            throw new NullPointerException();
        }
        if (n2 >= tableModel.getRowCount()) {
            throw new IllegalArgumentException("End >= Model.RowCount");
        }
        this.start = n;
        this.end = n2;
        this.model = tableModel;
        this.eventHandler = new TableEventTranslator();
    }

    private int getClientRowIndex(int n) {
        return n + this.start;
    }

    @Override
    public int getRowCount() {
        int n = this.model.getRowCount();
        return n - this.start - (n - this.end);
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.model.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.model.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.model.isCellEditable(this.getClientRowIndex(n), n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.model.getValueAt(this.getClientRowIndex(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.model.setValueAt(object, this.getClientRowIndex(n), n2);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.eventHandler.addTableModelListener(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.eventHandler.removeTableModelListener(tableModelListener);
    }

    protected TableModel getEnclosedModel() {
        return this.model;
    }

    protected int getStart() {
        return this.start;
    }

    protected int getEnd() {
        return this.end;
    }

    private final class TableEventTranslator
    implements TableModelListener {
        private final ArrayList listeners = new ArrayList();

        private TableEventTranslator() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n;
            int n2 = tableModelEvent.getFirstRow();
            if (tableModelEvent.getFirstRow() > 0) {
                n2 -= SubSetTableModel.this.getStart();
            }
            if ((n = tableModelEvent.getLastRow()) > 0) {
                n -= SubSetTableModel.this.getStart();
                n -= SubSetTableModel.this.getEnclosedModel().getRowCount() - SubSetTableModel.this.getEnd();
            }
            int n3 = tableModelEvent.getType();
            int n4 = tableModelEvent.getColumn();
            TableModelEvent tableModelEvent2 = new TableModelEvent(SubSetTableModel.this, n2, n, n4, n3);
            for (int i = 0; i < this.listeners.size(); ++i) {
                TableModelListener tableModelListener = (TableModelListener)this.listeners.get(i);
                tableModelListener.tableChanged(tableModelEvent2);
            }
        }

        protected void addTableModelListener(TableModelListener tableModelListener) {
            this.listeners.add(tableModelListener);
        }

        protected void removeTableModelListener(TableModelListener tableModelListener) {
            this.listeners.remove(tableModelListener);
        }
    }
}

