/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.layoutprocessor;

import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.SectionLayoutController;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.libreoffice.report.pentaho.layoutprocessor.OfficeRepeatingStructureLayoutController;
import org.libreoffice.report.pentaho.layoutprocessor.VariablesCollection;
import org.libreoffice.report.pentaho.model.OfficeGroup;
import org.libreoffice.report.pentaho.model.OfficeGroupSection;

public class OfficeGroupLayoutController
extends SectionLayoutController
implements OfficeRepeatingStructureLayoutController {
    private static final int STATE_PROCESS_REPEATING_HEADER = 0;
    private static final int STATE_PROCESS_REPEATING_FOOTER = 1;
    public static final int STATE_PROCESS_NORMAL_FLOW = 3;
    private boolean waitForJoin;
    private int state;
    private VariablesCollection variablesCollection;
    private boolean repeatHeader;
    private boolean repeatFooter;

    public void initialize(Object object, FlowController flowController, LayoutController layoutController) throws DataSourceException, ReportDataFactoryException, ReportProcessingException {
        super.initialize(object, flowController, layoutController);
        this.state = 0;
        this.variablesCollection = new VariablesCollection(this.computeVariablesPrefix());
        OfficeGroup officeGroup = (OfficeGroup)this.getElement();
        OfficeGroupSection officeGroupSection = officeGroup.getHeader();
        this.repeatHeader = officeGroupSection != null && officeGroupSection.isRepeatSection();
        OfficeGroupSection officeGroupSection2 = officeGroup.getFooter();
        this.repeatFooter = officeGroupSection2 != null && officeGroupSection2.isRepeatSection();
    }

    protected LayoutController processContent(ReportTarget reportTarget) throws DataSourceException, ReportProcessingException, ReportDataFactoryException {
        if (this.state == 0) {
            OfficeGroupLayoutController officeGroupLayoutController = (OfficeGroupLayoutController)this.clone();
            officeGroupLayoutController.state = 1;
            if (!this.repeatHeader) {
                return officeGroupLayoutController;
            }
            OfficeGroup officeGroup = (OfficeGroup)this.getElement();
            OfficeGroupSection officeGroupSection = officeGroup.getHeader();
            if (officeGroupSection == null) {
                return officeGroupLayoutController;
            }
            officeGroupLayoutController.waitForJoin = true;
            return this.processChild(officeGroupLayoutController, (Node)officeGroupSection, this.getFlowController());
        }
        if (this.state == 1) {
            OfficeGroupLayoutController officeGroupLayoutController = (OfficeGroupLayoutController)this.clone();
            officeGroupLayoutController.state = 3;
            if (!this.repeatFooter) {
                return officeGroupLayoutController;
            }
            OfficeGroup officeGroup = (OfficeGroup)this.getElement();
            OfficeGroupSection officeGroupSection = officeGroup.getFooter();
            if (officeGroupSection == null) {
                return officeGroupLayoutController;
            }
            officeGroupLayoutController.waitForJoin = true;
            return this.processChild(officeGroupLayoutController, (Node)officeGroupSection, this.getFlowController());
        }
        return super.processContent(reportTarget);
    }

    public LayoutController join(FlowController flowController) {
        if (this.waitForJoin) {
            OfficeGroupLayoutController officeGroupLayoutController = (OfficeGroupLayoutController)this.clone();
            officeGroupLayoutController.setProcessingState(1);
            officeGroupLayoutController.setFlowController(flowController);
            officeGroupLayoutController.waitForJoin = false;
            return officeGroupLayoutController;
        }
        return super.join(flowController);
    }

    @Override
    public boolean isNormalFlowProcessing() {
        return this.state == 3;
    }

    private String computeVariablesPrefix() {
        int n = 0;
        for (OfficeGroupLayoutController officeGroupLayoutController = this; officeGroupLayoutController != null; officeGroupLayoutController = officeGroupLayoutController.getParent()) {
            if (!(officeGroupLayoutController instanceof OfficeGroupLayoutController)) continue;
            ++n;
        }
        return "auto_group_" + n + "_";
    }

    @Override
    public VariablesCollection getVariablesCollection() {
        return this.variablesCollection;
    }

    protected AttributeMap computeAttributes(FlowController flowController, Element element, ReportTarget reportTarget) throws DataSourceException {
        AttributeMap attributeMap = new AttributeMap(super.computeAttributes(flowController, element, reportTarget));
        String string = String.valueOf(this.repeatHeader || this.repeatFooter);
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "repeating-header-or-footer", (Object)string);
        attributeMap.makeReadOnly();
        return attributeMap;
    }
}

