/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumeration;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.DateTime;
import com.sun.star.util.XRefreshable;
import com.sun.star.util.XUpdatable;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class TextFieldHandler {
    private XTextFieldsSupplier xTextFieldsSupplier;
    private final XMultiServiceFactory xMSFDoc;

    public TextFieldHandler(XMultiServiceFactory xMultiServiceFactory, XTextDocument xTextDocument) {
        this.xMSFDoc = xMultiServiceFactory;
        this.xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)xTextDocument);
    }

    private void refreshTextFields() {
        XRefreshable xRefreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)this.xTextFieldsSupplier.getTextFields());
        xRefreshable.refresh();
    }

    public String getUserFieldContent(XTextCursor xTextCursor) {
        try {
            XTextRange xTextRange = xTextCursor.getEnd();
            Object object = Helper.getUnoPropertyValue(xTextRange, "TextField");
            if (AnyConverter.isVoid((Object)object)) {
                return PropertyNames.EMPTY_STRING;
            }
            XDependentTextField xDependentTextField = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)object);
            XPropertySet xPropertySet = xDependentTextField.getTextFieldMaster();
            return (String)xPropertySet.getPropertyValue("Content");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return PropertyNames.EMPTY_STRING;
        }
    }

    public void insertUserField(XTextCursor xTextCursor, String string, String string2) {
        try {
            Object object;
            XInterface xInterface = (XInterface)this.xMSFDoc.createInstance("com.sun.star.text.TextField.User");
            XDependentTextField xDependentTextField = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)xInterface);
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xInterface);
            if (this.xTextFieldsSupplier.getTextFieldMasters().hasByName("com.sun.star.text.FieldMaster.User." + string)) {
                object = this.xTextFieldsSupplier.getTextFieldMasters().getByName("com.sun.star.text.FieldMaster.User." + string);
                XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)object);
                xComponent.dispose();
            }
            object = this.createUserField(string, string2);
            xDependentTextField.attachTextFieldMaster(object);
            xTextCursor.getText().insertTextContent((XTextRange)xTextCursor, xTextContent, false);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private XPropertySet createUserField(String string, String string2) throws Exception {
        Object object = this.xMSFDoc.createInstance("com.sun.star.text.FieldMaster.User");
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
        xPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)string);
        xPropertySet.setPropertyValue("Content", (Object)string2);
        return xPropertySet;
    }

    private XDependentTextField[] getTextFieldsByProperty(String string, Object object, String string2) {
        try {
            ArrayList<XDependentTextField> arrayList = new ArrayList<XDependentTextField>();
            if (this.xTextFieldsSupplier.getTextFields().hasElements()) {
                XEnumeration xEnumeration = this.xTextFieldsSupplier.getTextFields().createEnumeration();
                while (xEnumeration.hasMoreElements()) {
                    Object object2 = xEnumeration.nextElement();
                    XDependentTextField xDependentTextField = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)object2);
                    XPropertySet xPropertySet = xDependentTextField.getTextFieldMaster();
                    if (!xPropertySet.getPropertySetInfo().hasPropertyByName(string)) continue;
                    Object object3 = xPropertySet.getPropertyValue(string);
                    if (AnyConverter.isString((Object)object3)) {
                        String string3;
                        if (!string2.equals("String") || !(string3 = AnyConverter.toString((Object)object3)).equals(object)) continue;
                        arrayList.add(xDependentTextField);
                        continue;
                    }
                    if (!AnyConverter.isShort((Object)object3) || !string2.equals("Short")) continue;
                    short s = (Short)object;
                    short s2 = AnyConverter.toShort((Object)object3);
                    if (s2 != s) continue;
                    arrayList.add(xDependentTextField);
                }
            }
            if (arrayList.size() > 0) {
                XDependentTextField[] xDependentTextFieldArray = new XDependentTextField[arrayList.size()];
                arrayList.toArray(xDependentTextFieldArray);
                return xDependentTextFieldArray;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    public void changeUserFieldContent(String string, String string2) {
        try {
            XDependentTextField[] xDependentTextFieldArray = this.getTextFieldsByProperty(PropertyNames.PROPERTY_NAME, string, "String");
            if (xDependentTextFieldArray != null) {
                for (int i = 0; i < xDependentTextFieldArray.length; ++i) {
                    xDependentTextFieldArray[i].getTextFieldMaster().setPropertyValue("Content", (Object)string2);
                }
                this.refreshTextFields();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void updateDocInfoFields() {
        try {
            XEnumeration xEnumeration = this.xTextFieldsSupplier.getTextFields().createEnumeration();
            while (xEnumeration.hasMoreElements()) {
                XUpdatable xUpdatable;
                Object object = xEnumeration.nextElement();
                XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object);
                if (xServiceInfo.supportsService("com.sun.star.text.TextField.ExtendedUser")) {
                    xUpdatable = (XUpdatable)UnoRuntime.queryInterface(XUpdatable.class, (Object)object);
                    xUpdatable.update();
                }
                if (!xServiceInfo.supportsService("com.sun.star.text.TextField.User")) continue;
                xUpdatable = (XUpdatable)UnoRuntime.queryInterface(XUpdatable.class, (Object)object);
                xUpdatable.update();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateDateFields() {
        try {
            XEnumeration xEnumeration = this.xTextFieldsSupplier.getTextFields().createEnumeration();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            DateTime dateTime = new DateTime();
            dateTime.Day = (short)gregorianCalendar.get(5);
            dateTime.Year = (short)gregorianCalendar.get(1);
            dateTime.Month = (short)gregorianCalendar.get(2);
            dateTime.Month = (short)(dateTime.Month + 1);
            while (xEnumeration.hasMoreElements()) {
                Object object = xEnumeration.nextElement();
                XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object);
                if (!xServiceInfo.supportsService("com.sun.star.text.TextField.DateTime")) continue;
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
                xPropertySet.setPropertyValue("IsFixed", (Object)Boolean.FALSE);
                xPropertySet.setPropertyValue("DateTimeValue", (Object)dateTime);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fixDateFields(boolean bl) {
        try {
            XEnumeration xEnumeration = this.xTextFieldsSupplier.getTextFields().createEnumeration();
            while (xEnumeration.hasMoreElements()) {
                Object object = xEnumeration.nextElement();
                XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object);
                if (!xServiceInfo.supportsService("com.sun.star.text.TextField.DateTime")) continue;
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
                xPropertySet.setPropertyValue("IsFixed", (Object)bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

