/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.BaseMemoryNode;
import org.hsqldb.CachedRow;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Table;

class PointerNode
extends BaseMemoryNode {
    int iData = -1;
    private Table tTable;
    private Node nPrimary;

    PointerNode(CachedRow cachedRow, int n) {
        this.tTable = cachedRow.getTable();
        this.iData = cachedRow.iPos;
        this.nPrimary = cachedRow.nPrimaryNode == null ? this : cachedRow.nPrimaryNode;
    }

    @Override
    void delete() {
        super.delete();
        this.nPrimary = null;
        this.tTable = null;
    }

    @Override
    int getKey() {
        return this.iData;
    }

    @Override
    Row getRow() throws HsqlException {
        if (this.iData == -1) {
            return null;
        }
        CachedRow cachedRow = this.tTable.getRow(this.iData, this.nPrimary);
        return cachedRow;
    }

    @Override
    Object[] getData() throws HsqlException {
        return this.getRow().getData();
    }
}

