/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.generator.ContentGenerator;
import org.jfree.layouting.renderer.Renderer;

public class PrintContentGenerator
implements ContentGenerator {
    private static final Log logger = LogFactory.getLog(PrintContentGenerator.class);
    private Renderer renderer;

    public PrintContentGenerator(LayoutProcess layoutProcess) {
        this.renderer = layoutProcess.getOutputProcessor().createRenderer(layoutProcess);
    }

    public PrintContentGenerator(Renderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void startedDocument(PageContext pageContext) {
        logger.debug((Object)"<document>");
        this.renderer.startedDocument(pageContext);
    }

    @Override
    public void startedFlow(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)("<flow tag='" + layoutContext.getTagName() + "'>"));
        this.renderer.startedFlow(layoutContext);
    }

    @Override
    public void startedTable(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table>");
        this.renderer.startedTable(layoutContext);
    }

    @Override
    public void startedTableColumnGroup(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-col-group>");
        this.renderer.startedTableColumnGroup(layoutContext);
    }

    @Override
    public void startedTableColumn(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-col>");
        this.renderer.startedTableColumn(layoutContext);
    }

    @Override
    public void startedTableSection(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-section>");
        this.renderer.startedTableSection(layoutContext);
    }

    @Override
    public void startedTableRow(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-row>");
        this.renderer.startedTableRow(layoutContext);
    }

    @Override
    public void startedTableCell(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-cell>");
        this.renderer.startedTableCell(layoutContext);
    }

    @Override
    public void startedBlock(LayoutContext layoutContext) throws NormalizationException {
        String string = layoutContext.getTagName();
        logger.debug((Object)("<block tag='" + string + "'>"));
        this.renderer.startedBlock(layoutContext);
    }

    @Override
    public void startedRootInline(LayoutContext layoutContext) throws NormalizationException {
        String string = layoutContext.getTagName();
        logger.debug((Object)("<paragraph tag='" + string + "'>"));
        this.renderer.startedRootInline(layoutContext);
    }

    @Override
    public void startedMarker(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<marker>");
        this.renderer.startedMarker(layoutContext);
    }

    @Override
    public void startedInline(LayoutContext layoutContext) throws NormalizationException {
        String string = layoutContext.getTagName();
        logger.debug((Object)("<inline tag='" + string + "'>"));
        this.renderer.startedInline(layoutContext);
    }

    @Override
    public void addContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        logger.debug((Object)("<content>" + contentToken + "</content>"));
        this.renderer.addContent(layoutContext, contentToken);
    }

    @Override
    public void finishedInline() throws NormalizationException {
        logger.debug((Object)"</inline>");
        this.renderer.finishedInline();
    }

    @Override
    public void finishedMarker() throws NormalizationException {
        logger.debug((Object)"</marker>");
        this.renderer.finishedMarker();
    }

    @Override
    public void finishedRootInline() throws NormalizationException {
        logger.debug((Object)"</paragraph>");
        this.renderer.finishedRootInline();
    }

    @Override
    public void finishedBlock() throws NormalizationException {
        logger.debug((Object)"</block>");
        this.renderer.finishedBlock();
    }

    @Override
    public void finishedTableCell() throws NormalizationException {
        logger.debug((Object)"</table-cell>");
        this.renderer.finishedTableCell();
    }

    @Override
    public void finishedTableRow() throws NormalizationException {
        logger.debug((Object)"</table-row>");
        this.renderer.finishedTableRow();
    }

    @Override
    public void finishedTableSection() throws NormalizationException {
        logger.debug((Object)"</table-section>");
        this.renderer.finishedTableSection();
    }

    @Override
    public void finishedTableColumn() throws NormalizationException {
        logger.debug((Object)"</table-col>");
        this.renderer.finishedTableColumn();
    }

    @Override
    public void finishedTableColumnGroup() throws NormalizationException {
        logger.debug((Object)"</table-col-group>");
        this.renderer.finishedTableColumnGroup();
    }

    @Override
    public void finishedTable() throws NormalizationException {
        logger.debug((Object)"</table>");
        this.renderer.finishedTable();
    }

    @Override
    public void finishedFlow() throws NormalizationException {
        logger.debug((Object)"</flow>");
        this.renderer.finishedFlow();
    }

    @Override
    public void finishedDocument() throws NormalizationException {
        logger.debug((Object)"</document>");
        this.renderer.finishedDocument();
    }

    @Override
    public State saveState() throws StateException {
        return new PrintContentGeneratorState(this.renderer.saveState());
    }

    @Override
    public void handlePageBreak(PageContext pageContext) {
        this.renderer.handlePageBreak(pageContext);
    }

    @Override
    public void startedPassThrough(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<pass-through>");
        this.renderer.startedPassThrough(layoutContext);
    }

    @Override
    public void addPassThroughContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        logger.debug((Object)("<pass-through-content>" + contentToken + "</pass-through-content>"));
        this.renderer.addPassThroughContent(layoutContext, contentToken);
    }

    @Override
    public void finishedPassThrough() throws NormalizationException {
        logger.debug((Object)"</pass-through>");
        this.renderer.finishedPassThrough();
    }

    @Override
    public void startedTableCaption(LayoutContext layoutContext) throws NormalizationException {
        logger.debug((Object)"<table-caption>");
        this.renderer.startedTableCaption(layoutContext);
    }

    @Override
    public void finishedTableCaption() throws NormalizationException {
        logger.debug((Object)"</table-caption>");
        this.renderer.finishedTableCaption();
    }

    @Override
    public Renderer getRenderer() {
        return this.renderer;
    }

    private static class PrintContentGeneratorState
    implements State {
        private State renderer;

        private PrintContentGeneratorState(State state) {
            this.renderer = state;
        }

        @Override
        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            Renderer renderer = (Renderer)this.renderer.restore(layoutProcess);
            return new PrintContentGenerator(renderer);
        }
    }
}

