/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model;

import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.NodeLayoutProperties;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;

public abstract class RenderNode
implements Cloneable {
    public static final int HORIZONTAL_AXIS = 0;
    public static final int VERTICAL_AXIS = 1;
    private RenderBox parent;
    private RenderNode prev;
    private RenderNode next;
    private long changeTracker;
    private long width;
    private long height;
    private long x;
    private long y;
    private boolean frozen;
    private boolean hibernated;
    private Object instanceId = new Object();
    private NodeLayoutProperties layoutProperties = new NodeLayoutProperties();
    private LayoutContext layoutContext;
    private boolean dirty;
    private long maximumBoxWidth;
    private long minimumChunkWidth;
    private boolean icmMetricsFinished;
    private long stickyMarker;
    private ComputedLayoutProperties computedLayoutProperties;

    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        this.layoutProperties.setAlignmentBaseline(layoutContext.getValue(LineStyleKeys.ALIGNMENT_BASELINE));
        CSSValue cSSValue = layoutContext.getValue(LineStyleKeys.ALIGNMENT_ADJUST);
        this.layoutProperties.setAlignmentAdjust(cSSValue);
        if (cSSValue instanceof CSSNumericValue) {
            this.layoutProperties.setAlignmentAdjustResolved(RenderLength.convertToInternal(cSSValue, layoutContext, outputProcessorMetaData));
        }
        CSSValue cSSValue2 = layoutContext.getValue(LineStyleKeys.BASELINE_SHIFT);
        this.layoutProperties.setBaselineShift(cSSValue2);
        if (cSSValue2 instanceof CSSNumericValue) {
            this.layoutProperties.setBaselineShiftResolved(RenderLength.convertToInternal(cSSValue2, layoutContext, outputProcessorMetaData));
        }
        this.layoutProperties.setVerticalAlignment(this.normalizeAlignment(layoutContext.getValue(LineStyleKeys.VERTICAL_ALIGN)));
        this.layoutProperties.setNamespace(layoutContext.getNamespace());
        this.layoutProperties.setTagName(layoutContext.getTagName());
        this.layoutContext = layoutContext;
    }

    public ComputedLayoutProperties getComputedLayoutProperties() {
        return this.computedLayoutProperties;
    }

    public void setComputedLayoutProperties(ComputedLayoutProperties computedLayoutProperties) {
        this.computedLayoutProperties = computedLayoutProperties;
    }

    public LayoutContext getLayoutContext() {
        return this.layoutContext;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public String getNamespace() {
        return this.layoutProperties.getNamespace();
    }

    public String getTagName() {
        return this.layoutProperties.getTagName();
    }

    protected CSSValue normalizeAlignment(CSSValue cSSValue) {
        return cSSValue;
    }

    public CSSValue getVerticalAlignment() {
        return this.layoutProperties.getVerticalAlignment();
    }

    public RenderLength getBaselineShiftResolved() {
        return this.layoutProperties.getBaselineShiftResolved();
    }

    public CSSValue getAlignmentBaseline() {
        return this.layoutProperties.getAlignmentBaseline();
    }

    public CSSValue getBaselineShift() {
        return this.layoutProperties.getBaselineShift();
    }

    public CSSValue getAlignmentAdjust() {
        return this.layoutProperties.getAlignmentAdjust();
    }

    public RenderLength getAlignmentAdjustResolved() {
        return this.layoutProperties.getAlignmentAdjustResolved();
    }

    public PageContext getPageContext() {
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.getPageContext();
        }
        return null;
    }

    public Object getInstanceId() {
        return this.instanceId;
    }

    public int getMajorAxis() {
        return this.layoutProperties.getMajorAxis();
    }

    protected void setMajorAxis(int n) {
        this.layoutProperties.setMajorAxis(n);
    }

    public int getMinorAxis() {
        return this.layoutProperties.getMinorAxis();
    }

    protected void setMinorAxis(int n) {
        this.layoutProperties.setMinorAxis(n);
        this.updateChangeTracker();
    }

    public void setWidth(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Width cannot be negative: " + l);
        }
        this.width = l;
        this.updateChangeTracker();
    }

    public long getWidth() {
        return this.width;
    }

    public void setHeight(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Height cannot be negative: " + l);
        }
        this.height = l;
    }

    public long getHeight() {
        return this.height;
    }

    public long getX() {
        return this.x;
    }

    public void setX(long l) {
        this.x = l;
        this.updateChangeTracker();
    }

    public final void setPosition(int n, long l) {
        if (n == 0) {
            this.setX(l);
        } else {
            this.setY(l);
        }
    }

    public final long getPosition(int n) {
        if (n == 0) {
            return this.getX();
        }
        return this.getY();
    }

    public final void setDimension(int n, long l) {
        if (n == 0) {
            this.setWidth(l);
        } else {
            this.setHeight(l);
        }
    }

    public final long getDimension(int n) {
        if (n == 0) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    public long getY() {
        return this.y;
    }

    public void setY(long l) {
        this.y = l;
    }

    public RenderBox getParent() {
        return this.parent;
    }

    protected void setParent(RenderBox renderBox) {
        this.parent = renderBox;
        if (renderBox != null && this.prev == renderBox) {
            throw new IllegalStateException();
        }
    }

    public RenderNode getVisiblePrev() {
        for (RenderNode renderNode = this.prev; renderNode != null; renderNode = renderNode.getPrev()) {
            if (renderNode.isIgnorableForRendering()) continue;
            return renderNode;
        }
        return null;
    }

    public RenderNode getPrev() {
        return this.prev;
    }

    protected void setPrev(RenderNode renderNode) {
        this.prev = renderNode;
        if (renderNode != null && renderNode == this.parent) {
            throw new IllegalStateException();
        }
    }

    public RenderNode getVisibleNext() {
        for (RenderNode renderNode = this.next; renderNode != null; renderNode = renderNode.getNext()) {
            if (renderNode.isIgnorableForRendering()) continue;
            return renderNode;
        }
        return null;
    }

    public RenderNode getNext() {
        return this.next;
    }

    protected void setNext(RenderNode renderNode) {
        this.next = renderNode;
    }

    public LogicalPageBox getLogicalPage() {
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            return renderBox.getLogicalPage();
        }
        return null;
    }

    public NormalFlowRenderBox getNormalFlow() {
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            return renderBox.getNormalFlow();
        }
        return null;
    }

    public Object clone() {
        try {
            RenderNode renderNode = (RenderNode)super.clone();
            return renderNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone failed for some reason.");
        }
    }

    public RenderNode derive(boolean bl) {
        RenderNode renderNode = (RenderNode)this.clone();
        renderNode.parent = null;
        renderNode.next = null;
        renderNode.prev = null;
        renderNode.hibernated = false;
        return renderNode;
    }

    public RenderNode hibernate() {
        RenderNode renderNode = (RenderNode)this.clone();
        renderNode.parent = null;
        renderNode.next = null;
        renderNode.prev = null;
        renderNode.hibernated = true;
        return renderNode;
    }

    public RenderNode deriveFrozen(boolean bl) {
        RenderNode renderNode = (RenderNode)this.clone();
        renderNode.parent = null;
        renderNode.next = null;
        renderNode.prev = null;
        renderNode.frozen = true;
        renderNode.hibernated = false;
        return renderNode;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean isHibernated() {
        return this.hibernated;
    }

    protected void setHibernated(boolean bl) {
        this.hibernated = bl;
    }

    public RenderNode findNodeById(Object object) {
        if (object == this.getInstanceId()) {
            return this;
        }
        return null;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public RenderBox getParentBlockContext() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof BlockRenderBox) {
            return this.parent;
        }
        return this.parent.getParentBlockContext();
    }

    public boolean isDiscardable() {
        return false;
    }

    public boolean isIgnorableForRendering() {
        return this.isEmpty();
    }

    public NodeLayoutProperties getNodeLayoutProperties() {
        return this.layoutProperties;
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean isDirectionLTR() {
        return true;
    }

    public void updateChangeTracker() {
        ++this.changeTracker;
        if (this.parent != null) {
            this.parent.updateChangeTracker();
        }
    }

    public long getChangeTracker() {
        return this.changeTracker;
    }

    public long getStickyMarker() {
        return this.stickyMarker;
    }

    public void setStickyMarker(long l) {
        this.stickyMarker = l;
    }

    public long getEffectiveMarginTop() {
        return 0L;
    }

    public long getEffectiveMarginBottom() {
        return 0L;
    }

    public long getMaximumBoxWidth() {
        return this.maximumBoxWidth;
    }

    public void setMaximumBoxWidth(long l) {
        this.maximumBoxWidth = l;
    }

    public long getMinimumChunkWidth() {
        return this.minimumChunkWidth;
    }

    public void setMinimumChunkWidth(long l) {
        this.minimumChunkWidth = l;
    }

    public boolean isIcmMetricsFinished() {
        return this.icmMetricsFinished;
    }

    public void setIcmMetricsFinished(boolean bl) {
        this.icmMetricsFinished = bl;
    }
}

