/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.bridges.java_remote;

import com.sun.star.bridge.XBridge;
import com.sun.star.lib.uno.Proxy;
import com.sun.star.lib.uno.bridges.java_remote.RequestHandler;
import com.sun.star.lib.util.AsynchronousFinalizer;
import com.sun.star.uno.IQueryInterface;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

final class ProxyFactory {
    private static final Method METHOD_EQUALS;
    private static final Method METHOD_HASH_CODE;
    private static final Method METHOD_TO_STRING;
    private static final Method METHOD_QUERY_INTERFACE;
    private static final Method METHOD_IS_SAME;
    private static final Method METHOD_GET_OID;
    private static final Object debugCountLock;
    private static int debugCount;
    private final RequestHandler requestHandler;
    private final XBridge bridge;
    private final AsynchronousFinalizer asynchronousFinalizer = new AsynchronousFinalizer();

    public ProxyFactory(RequestHandler requestHandler, XBridge xBridge) {
        this.requestHandler = requestHandler;
        this.bridge = xBridge;
    }

    public Object create(String string, Type type) {
        return java.lang.reflect.Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Proxy.class, IQueryInterface.class, type.getZClass()}, (InvocationHandler)new Handler(string, type));
    }

    public boolean isProxy(Object object) {
        if (java.lang.reflect.Proxy.isProxyClass(object.getClass())) {
            InvocationHandler invocationHandler = java.lang.reflect.Proxy.getInvocationHandler(object);
            return invocationHandler instanceof Handler && ((Handler)invocationHandler).matches(this);
        }
        return false;
    }

    public void dispose() throws InterruptedException {
        this.asynchronousFinalizer.drain();
    }

    public static XBridge getBridge(Object object) {
        InvocationHandler invocationHandler;
        if (java.lang.reflect.Proxy.isProxyClass(object.getClass()) && (invocationHandler = java.lang.reflect.Proxy.getInvocationHandler(object)) instanceof Handler) {
            return ((Handler)invocationHandler).getBridge();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            return debugCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incrementDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            ++debugCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decrementDebugCount() {
        Object object = debugCountLock;
        synchronized (object) {
            --debugCount;
        }
    }

    static {
        try {
            METHOD_EQUALS = Object.class.getMethod("equals", Object.class);
            METHOD_HASH_CODE = Object.class.getMethod("hashCode", null);
            METHOD_TO_STRING = Object.class.getMethod("toString", null);
            METHOD_QUERY_INTERFACE = IQueryInterface.class.getMethod("queryInterface", Type.class);
            METHOD_IS_SAME = IQueryInterface.class.getMethod("isSame", Object.class);
            METHOD_GET_OID = IQueryInterface.class.getMethod("getOid", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExceptionInInitializerError(noSuchMethodException);
        }
        debugCountLock = new Object();
        debugCount = 0;
    }

    private final class Handler
    implements InvocationHandler {
        private final String oid;
        private final Type type;
        private int dummy = 0;

        public Handler(String string, Type type) {
            this.oid = string;
            this.type = type;
            ProxyFactory.incrementDebugCount();
        }

        public boolean matches(ProxyFactory proxyFactory) {
            return ProxyFactory.this == proxyFactory;
        }

        public XBridge getBridge() {
            return ProxyFactory.this.bridge;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.equals(METHOD_EQUALS) || method.equals(METHOD_IS_SAME)) {
                return objectArray[0] != null && this.oid.equals(UnoRuntime.generateOid((Object)objectArray[0]));
            }
            if (method.equals(METHOD_HASH_CODE)) {
                return this.oid.hashCode();
            }
            if (method.equals(METHOD_TO_STRING)) {
                return "[Proxy:" + System.identityHashCode(object) + "," + this.oid + "," + this.type + "]";
            }
            if (method.equals(METHOD_QUERY_INTERFACE)) {
                return objectArray[0].equals(this.type) ? object : this.request("queryInterface", objectArray);
            }
            if (method.equals(METHOD_GET_OID)) {
                return this.oid;
            }
            return this.request(method.getName(), objectArray);
        }

        protected void finalize() {
            ProxyFactory.decrementDebugCount();
            ProxyFactory.this.asynchronousFinalizer.add(new AsynchronousFinalizer.Job(){

                @Override
                public void run() throws Throwable {
                    Handler.this.request("release", null);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object request(String string, Object[] objectArray) throws Throwable {
            Object object = ProxyFactory.this.requestHandler.sendRequest(this.oid, this.type, string, objectArray);
            Handler handler = this;
            synchronized (handler) {
                ++this.dummy;
            }
            return object;
        }
    }
}

