/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.form;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XRadioButton;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.DatabaseControl;
import com.sun.star.wizards.document.TimeStampControl;
import com.sun.star.wizards.form.FormDocument;
import com.sun.star.wizards.text.TextStyleHandler;
import com.sun.star.wizards.ui.UIConsts;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.WizardDialog;
import com.sun.star.wizards.ui.event.XItemListenerAdapter;

public class StyleApplier {
    private final XPropertySet xPageStylePropertySet;
    private final XMultiServiceFactory xMSF;
    private final XRadioButton optNoBorder;
    private final XRadioButton opt3DLook;
    private final XListBox lstStyles;
    private final FormDocument curFormDocument;
    private short iOldLayoutPos;
    private String[] StyleNames;
    private String[] FileNames;
    private static final int SOBACKGROUNDCOLOR = 0;
    private static final int SODBTEXTCOLOR = 1;
    private static final int SOLABELTEXTCOLOR = 2;
    private static final int SOBORDERCOLOR = 5;
    private Short IBorderValue = 1;

    public StyleApplier(WizardDialog wizardDialog, FormDocument formDocument) {
        this.curFormDocument = formDocument;
        this.xMSF = this.curFormDocument.xMSF;
        TextStyleHandler textStyleHandler = new TextStyleHandler(this.curFormDocument.xTextDocument);
        this.xPageStylePropertySet = textStyleHandler.getStyleByName("PageStyles", "Standard");
        short s = 700;
        Integer n = 7;
        String string = wizardDialog.m_oResource.getResText("RID_FORM_86");
        String string2 = wizardDialog.m_oResource.getResText("RID_FORM_29");
        String string3 = wizardDialog.m_oResource.getResText("RID_FORM_30");
        String string4 = wizardDialog.m_oResource.getResText("RID_FORM_31");
        String string5 = wizardDialog.m_oResource.getResText("RID_FORM_28");
        this.setStyles();
        short[] sArray = new short[]{0};
        Object[] objectArray = new Object[7];
        objectArray[0] = UIConsts.INTEGERS[8];
        objectArray[1] = string;
        objectArray[2] = 92;
        objectArray[3] = 25;
        objectArray[4] = n;
        short s2 = s;
        s = (short)(s + 1);
        objectArray[5] = s2;
        objectArray[6] = 90;
        wizardDialog.insertLabel("lblStyles", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray);
        Object[] objectArray2 = new Object[9];
        objectArray2[0] = 143;
        objectArray2[1] = "HID:WIZARDS_HID_DLGFORM_LSTSTYLES";
        objectArray2[2] = 92;
        objectArray2[3] = 35;
        objectArray2[4] = sArray;
        objectArray2[5] = n;
        objectArray2[6] = this.StyleNames;
        short s3 = s;
        s = (short)(s + 1);
        objectArray2[7] = s3;
        objectArray2[8] = 90;
        this.lstStyles = wizardDialog.insertListBox("lstStyles", null, (XItemListener)new XItemListenerAdapter(){

            public void itemStateChanged(ItemEvent itemEvent) {
                StyleApplier.this.changeLayout();
            }
        }, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.SELECTED_ITEMS, PropertyNames.PROPERTY_STEP, PropertyNames.STRING_ITEM_LIST, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray2);
        Object[] objectArray3 = new Object[9];
        objectArray3[0] = UIConsts.INTEGERS[10];
        objectArray3[1] = "HID:WIZARDS_HID_DLGFORM_CMDNOBORDER";
        objectArray3[2] = string2;
        objectArray3[3] = 196;
        objectArray3[4] = 39;
        objectArray3[5] = n;
        short s4 = s;
        s = (short)(s + 1);
        objectArray3[6] = s4;
        objectArray3[7] = "0";
        objectArray3[8] = 93;
        this.optNoBorder = wizardDialog.insertRadioButton("otpNoBorder", (XItemListener)new XItemListenerAdapter(){

            public void itemStateChanged(ItemEvent itemEvent) {
                StyleApplier.this.changeBorderLayouts();
            }
        }, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tag", PropertyNames.PROPERTY_WIDTH}, objectArray3);
        Object[] objectArray4 = new Object[10];
        objectArray4[0] = UIConsts.INTEGERS[10];
        objectArray4[1] = "HID:WIZARDS_HID_DLGFORM_CMD3DBORDER";
        objectArray4[2] = string3;
        objectArray4[3] = 196;
        objectArray4[4] = 53;
        objectArray4[5] = (short)1;
        objectArray4[6] = n;
        short s5 = s;
        s = (short)(s + 1);
        objectArray4[7] = s5;
        objectArray4[8] = "1";
        objectArray4[9] = 93;
        this.opt3DLook = wizardDialog.insertRadioButton("otp3DLook", (XItemListener)new XItemListenerAdapter(){

            public void itemStateChanged(ItemEvent itemEvent) {
                StyleApplier.this.changeBorderLayouts();
            }
        }, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STATE, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tag", PropertyNames.PROPERTY_WIDTH}, objectArray4);
        Object[] objectArray5 = new Object[9];
        objectArray5[0] = UIConsts.INTEGERS[10];
        objectArray5[1] = "HID:WIZARDS_HID_DLGFORM_CMDSIMPLEBORDER";
        objectArray5[2] = string4;
        objectArray5[3] = 196;
        objectArray5[4] = 67;
        objectArray5[5] = n;
        short s6 = s;
        s = (short)(s + 1);
        objectArray5[6] = s6;
        objectArray5[7] = "2";
        objectArray5[8] = 93;
        wizardDialog.insertRadioButton("otpFlat", (XItemListener)new XItemListenerAdapter(){

            public void itemStateChanged(ItemEvent itemEvent) {
                StyleApplier.this.changeBorderLayouts();
            }
        }, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tag", PropertyNames.PROPERTY_WIDTH}, objectArray5);
        Object[] objectArray6 = new Object[7];
        objectArray6[0] = UIConsts.INTEGERS[8];
        objectArray6[1] = string5;
        objectArray6[2] = 192;
        objectArray6[3] = 25;
        objectArray6[4] = n;
        short s7 = s;
        s = (short)(s + 1);
        objectArray6[5] = s7;
        objectArray6[6] = 98;
        wizardDialog.insertFixedLine("lnFieldBorder", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray6);
    }

    private void setStyles() {
        try {
            Object object = Configuration.getConfigurationRoot((XMultiServiceFactory)this.xMSF, (String)"org.openoffice.Office.FormWizard/FormWizard/Styles", (boolean)false);
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
            String[] stringArray = xNameAccess.getElementNames();
            this.StyleNames = new String[stringArray.length];
            this.FileNames = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2 = xNameAccess.getByName(stringArray[i]);
                this.StyleNames[i] = (String)Helper.getUnoPropertyValue((Object)object2, (String)PropertyNames.PROPERTY_NAME);
                this.FileNames[i] = (String)Helper.getUnoPropertyValue((Object)object2, (String)"CssHref");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private short getStyleIndex() {
        try {
            short[] sArray = (short[])AnyConverter.toArray((Object)Helper.getUnoPropertyValue((Object)UnoDialog.getModel((Object)this.lstStyles), (String)PropertyNames.SELECTED_ITEMS));
            if (sArray != null) {
                return sArray[0];
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.err);
        }
        return -1;
    }

    public void applyStyle(boolean bl) {
        short s = this.getStyleIndex();
        if ((s != this.iOldLayoutPos || bl) && s > -1) {
            this.iOldLayoutPos = s;
            String string = this.FileNames[s];
            int[] nArray = this.getStyleColors(string);
            this.applyDBControlProperties(nArray);
        }
    }

    private void changeLayout() {
        short s = this.lstStyles.getSelectedItemPos();
        if (s != this.iOldLayoutPos) {
            this.iOldLayoutPos = s;
            String string = this.FileNames[s];
            int[] nArray = this.getStyleColors(string);
            this.applyDBControlProperties(nArray);
        }
        this.curFormDocument.unlockallControllers();
    }

    public Short getBorderType() {
        return this.IBorderValue;
    }

    private void changeBorderLayouts() {
        try {
            this.curFormDocument.xTextDocument.lockControllers();
            this.IBorderValue = this.optNoBorder.getState() ? Short.valueOf((short)0) : (this.opt3DLook.getState() ? Short.valueOf((short)1) : Short.valueOf((short)2));
            for (int i = 0; i < this.curFormDocument.oControlForms.size(); ++i) {
                DatabaseControl[] databaseControlArray;
                FormDocument.ControlForm controlForm = this.curFormDocument.oControlForms.get(i);
                if (controlForm.getArrangemode() == 3) {
                    databaseControlArray = controlForm.getGridControl();
                    databaseControlArray.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)this.IBorderValue);
                    continue;
                }
                databaseControlArray = controlForm.getDatabaseControls();
                for (int j = 0; j < databaseControlArray.length; ++j) {
                    if (databaseControlArray[j].xServiceInfo.supportsService("com.sun.star.drawing.ShapeCollection")) {
                        TimeStampControl timeStampControl = (TimeStampControl)databaseControlArray[j];
                        for (int k = 0; k < 2; ++k) {
                            XPropertySet xPropertySet = timeStampControl.getControlofGroupShapeByIndex(k);
                            if (xPropertySet == null || !xPropertySet.getPropertySetInfo().hasPropertyByName(PropertyNames.PROPERTY_BORDER)) continue;
                            xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)this.IBorderValue);
                        }
                        continue;
                    }
                    if (!databaseControlArray[j].xPropertySet.getPropertySetInfo().hasPropertyByName(PropertyNames.PROPERTY_BORDER)) continue;
                    databaseControlArray[j].xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)this.IBorderValue);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        this.curFormDocument.unlockallControllers();
    }

    private int getStyleColor(String[] stringArray, String string, String string2) {
        int n = JavaTools.FieldInList((String[])stringArray, (String)string);
        if (n > -1) {
            String string3 = PropertyNames.EMPTY_STRING;
            while (string3.indexOf(125) < 0 && n < stringArray.length - 1) {
                String string4;
                if ((string4 = stringArray[n++]).indexOf(string2) <= 0 || string4.indexOf(58) <= 0) continue;
                String[] stringArray2 = JavaTools.ArrayoutofString((String)string4, (String)":");
                String string5 = stringArray2[1];
                if ((string5 = string5.trim()).indexOf(35) <= -1) continue;
                string5 = JavaTools.replaceSubString((String)string5, (String)PropertyNames.EMPTY_STRING, (String)PropertyNames.SEMI_COLON);
                string5 = JavaTools.replaceSubString((String)string5, (String)PropertyNames.EMPTY_STRING, (String)PropertyNames.SPACE);
                return Integer.decode(string5);
            }
        }
        return -1;
    }

    private String getStylePath() {
        String string = "";
        try {
            string = FileAccess.getOfficePath((XMultiServiceFactory)this.xMSF, (String)"Config", (String)"", (String)"");
            string = FileAccess.combinePaths((XMultiServiceFactory)this.xMSF, (String)string, (String)"/wizard/form/styles");
        }
        catch (NoValidPathException noValidPathException) {
            // empty catch block
        }
        return string;
    }

    private int[] getStyleColors(String string) {
        String string2 = this.getStylePath() + "/" + string;
        int[] nArray = new int[6];
        String[] stringArray = FileAccess.getDataFromTextFile((XMultiServiceFactory)this.xMSF, (String)string2);
        if (stringArray != null) {
            nArray[0] = this.getStyleColor(stringArray, ".toctitle {", "background-color:");
            nArray[1] = this.getStyleColor(stringArray, ".doctitle {", "color:");
            nArray[2] = this.getStyleColor(stringArray, ".toctitle {", "color:");
            nArray[5] = this.getStyleColor(stringArray, ".tcolor {", "border-color:");
        }
        return nArray;
    }

    private void setDBControlColors(XPropertySet xPropertySet, int[] nArray) {
        try {
            if (xPropertySet.getPropertySetInfo().hasPropertyByName("TextColor") && nArray[1] > -1) {
                xPropertySet.setPropertyValue("TextColor", (Object)Integer.decode("#00000"));
            }
            if (xPropertySet.getPropertySetInfo().hasPropertyByName("BackgroundColor")) {
                xPropertySet.setPropertyValue("BackgroundColor", (Object)Integer.decode("#DDDDDD"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void applyDBControlProperties(int[] nArray) {
        try {
            for (int i = 0; i < this.curFormDocument.oControlForms.size(); ++i) {
                FormDocument.ControlForm controlForm = this.curFormDocument.oControlForms.get(i);
                if (controlForm.getArrangemode() == 3) {
                    if (nArray[2] > -1) {
                        controlForm.oGridControl.xPropertySet.setPropertyValue("TextColor", (Object)nArray[1]);
                    }
                    controlForm.oGridControl.xPropertySet.setPropertyValue("BackgroundColor", (Object)Integer.decode("#DDDDDD"));
                    continue;
                }
                DatabaseControl[] databaseControlArray = controlForm.getDatabaseControls();
                for (int j = 0; j < databaseControlArray.length; ++j) {
                    DatabaseControl databaseControl;
                    if (nArray[1] <= -1 || (databaseControl = databaseControlArray[j]) == null) continue;
                    if (databaseControl.xServiceInfo.supportsService("com.sun.star.drawing.ShapeCollection")) {
                        TimeStampControl timeStampControl = (TimeStampControl)databaseControl;
                        for (int k = 0; k < 2; ++k) {
                            XPropertySet xPropertySet = timeStampControl.getControlofGroupShapeByIndex(k);
                            if (xPropertySet == null) continue;
                            this.setDBControlColors(xPropertySet, nArray);
                        }
                        continue;
                    }
                    this.setDBControlColors(databaseControl.xPropertySet, nArray);
                }
                Control[] controlArray = controlForm.getLabelControls();
                for (int j = 0; j < controlArray.length; ++j) {
                    if (nArray[2] <= -1) continue;
                    controlArray[j].xPropertySet.setPropertyValue("TextColor", (Object)nArray[2]);
                }
            }
            this.xPageStylePropertySet.setPropertyValue("BackColor", (Object)nArray[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

