/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.lang.IllegalArgumentException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class UnoUrl {
    private static final String FORMAT_ERROR = "syntax: [uno:]connection-type,parameters;protocol-name,parameters;objectname";
    private static final String VALUE_CHAR_SET = "!$&'()*+-./:?@_~";
    private static final String OID_CHAR_SET = "!$&'()*+-./:?@_~,=";
    private final UnoUrlPart connection;
    private final UnoUrlPart protocol;
    private final String rootOid;

    private UnoUrl(UnoUrlPart unoUrlPart, UnoUrlPart unoUrlPart2, String string) {
        this.connection = unoUrlPart;
        this.protocol = unoUrlPart2;
        this.rootOid = string;
    }

    public String getConnection() {
        return this.connection.getPartTypeName();
    }

    public String getProtocol() {
        return this.protocol.getPartTypeName();
    }

    public String getRootOid() {
        return this.rootOid;
    }

    public HashMap<String, String> getProtocolParameters() {
        return this.protocol.getPartParameters();
    }

    public HashMap<String, String> getConnectionParameters() {
        return this.connection.getPartParameters();
    }

    public String getProtocolParametersAsString() {
        return this.protocol.getUninterpretedParameterString();
    }

    public String getConnectionParametersAsString() {
        return this.connection.getUninterpretedParameterString();
    }

    public String getProtocolAndParametersAsString() {
        return this.protocol.getUninterpretedString();
    }

    public String getConnectionAndParametersAsString() {
        return this.connection.getUninterpretedString();
    }

    private static String decodeUTF8(String string) throws IllegalArgumentException {
        if (!string.contains("%")) {
            return string;
        }
        try {
            int n = string.length();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            for (int i = 0; i < n; ++i) {
                int n2 = string.charAt(i);
                if (n2 == 37) {
                    if (i + 3 > n) {
                        throw new IllegalArgumentException("Incomplete trailing escape (%) pattern");
                    }
                    try {
                        n2 = Integer.parseInt(string.substring(i + 1, i + 3), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException((Throwable)numberFormatException);
                    }
                    if (n2 < 0) {
                        throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - negative value");
                    }
                    i += 2;
                }
                byteBuffer.put((byte)(n2 & 0xFF));
            }
            byte[] byArray = new byte[byteBuffer.position()];
            System.arraycopy(byteBuffer.array(), 0, byArray, 0, byArray.length);
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException((Throwable)unsupportedEncodingException, "Couldn't convert parameter string to UTF-8 string");
        }
    }

    private static HashMap<String, String> buildParamHashMap(String string) throws IllegalArgumentException {
        char c;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        do {
            c = ',';
            StringBuffer stringBuffer = new StringBuffer();
            while (n < string.length()) {
                char c2 = string.charAt(n++);
                c = c2;
                if (c2 == '=') break;
                stringBuffer.append(c);
            }
            String string2 = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            while (n < string.length() && (c = string.charAt(n++)) != ',' && c != ';') {
                stringBuffer.append(c);
            }
            String string3 = stringBuffer.toString();
            if (string2.length() <= 0 || string3.length() <= 0) continue;
            if (!UnoUrl.isAlphaNumeric(string2)) {
                throw new IllegalArgumentException("The parameter key '" + string2 + "' may only consist of alpha numeric ASCII characters.");
            }
            if (!UnoUrl.isValidString(string3, "!$&'()*+-./:?@_~%")) {
                throw new IllegalArgumentException("The parameter value for key '" + string2 + "' contains illegal characters.");
            }
            hashMap.put(string2, UnoUrl.decodeUTF8(string3));
        } while (n < string.length() && c == 44);
        return hashMap;
    }

    private static UnoUrlPart parseUnoUrlPart(String string) throws IllegalArgumentException {
        String string2;
        String string3;
        int n = string.indexOf(44);
        if (n != -1) {
            string3 = string.substring(0, n).trim();
            string2 = string.substring(n + 1).trim();
        } else {
            string3 = string;
            string2 = "";
        }
        if (!UnoUrl.isAlphaNumeric(string3)) {
            throw new IllegalArgumentException("The part name '" + string3 + "' may only consist of alpha numeric ASCII characters.");
        }
        HashMap<String, String> hashMap = UnoUrl.buildParamHashMap(string2);
        return new UnoUrlPart(string2, string3, hashMap);
    }

    private static boolean isAlphaNumeric(String string) {
        return UnoUrl.isValidString(string, null);
    }

    private static boolean isValidString(String string, String string2) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            char c = string.charAt(i);
            boolean bl2 = bl = 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9';
            if (!bl && string2 != null) {
                boolean bl3 = bl = string2.indexOf(c) != -1;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static UnoUrl parseUnoUrl(String string) throws IllegalArgumentException {
        String string2;
        String string3 = string;
        int n = string3.indexOf(58);
        if (n != -1 && !"uno".equals(string2 = string3.substring(0, n).trim())) {
            throw new IllegalArgumentException("Uno Urls must start with 'uno:'. syntax: [uno:]connection-type,parameters;protocol-name,parameters;objectname");
        }
        if ((n = (string3 = string3.substring(n + 1).trim()).indexOf(59)) == -1) {
            throw new IllegalArgumentException("'" + string + "' is an invalid Uno Url. " + FORMAT_ERROR);
        }
        string2 = string3.substring(0, n).trim();
        string3 = string3.substring(n + 1).trim();
        UnoUrlPart unoUrlPart = UnoUrl.parseUnoUrlPart(string2);
        n = string3.indexOf(59);
        if (n == -1) {
            throw new IllegalArgumentException("'" + string + "' is an invalid Uno Url. " + FORMAT_ERROR);
        }
        String string4 = string3.substring(0, n).trim();
        string3 = string3.substring(n + 1).trim();
        UnoUrlPart unoUrlPart2 = UnoUrl.parseUnoUrlPart(string4);
        String string5 = string3.trim();
        if (!UnoUrl.isValidString(string5, OID_CHAR_SET)) {
            throw new IllegalArgumentException("Root OID '" + string5 + "' contains illegal characters.");
        }
        return new UnoUrl(unoUrlPart, unoUrlPart2, string5);
    }

    private static class UnoUrlPart {
        private final String partTypeName;
        private final HashMap<String, String> partParameters;
        private final String uninterpretedParameterString;

        public UnoUrlPart(String string, String string2, HashMap<String, String> hashMap) {
            this.uninterpretedParameterString = string;
            this.partTypeName = string2;
            this.partParameters = hashMap;
        }

        public String getPartTypeName() {
            return this.partTypeName;
        }

        public HashMap<String, String> getPartParameters() {
            return this.partParameters;
        }

        public String getUninterpretedParameterString() {
            return this.uninterpretedParameterString;
        }

        public String getUninterpretedString() {
            StringBuffer stringBuffer = new StringBuffer(this.partTypeName);
            if (this.uninterpretedParameterString.length() > 0) {
                stringBuffer.append(',');
                stringBuffer.append(this.uninterpretedParameterString);
            }
            return stringBuffer.toString();
        }
    }
}

