/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.gitlog;

import net.sourceforge.plantuml.gitlog.GNode;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class MagicBox {
    private final ISkinParam skinParam;
    private final GNode node;
    private final HColor fontColor;

    public MagicBox(ISkinParam skinParam, GNode node) {
        this.skinParam = skinParam;
        this.node = node;
        Style style = StyleSignatureBasic.of(SName.root, SName.element, SName.gitDiagram).getMergedStyle(skinParam.getCurrentStyleBuilder());
        this.fontColor = style.value(PName.FontColor).asColor(skinParam.getIHtmlColorSet());
    }

    private TextBlock getSmallBlock() {
        FontConfiguration fc = FontConfiguration.create(UFont.monospaced(15).bold(), this.fontColor, this.fontColor, null);
        return this.node.getDisplay().create(fc, HorizontalAlignment.CENTER, this.skinParam);
    }

    private TextBlock getCommentBlock() {
        if (this.node.getComment() != null && this.node.isTop()) {
            FontConfiguration tag = FontConfiguration.create(UFont.sansSerif(13), this.fontColor, this.fontColor, null);
            return Display.create(this.node.getComment()).create(tag, HorizontalAlignment.CENTER, this.skinParam);
        }
        return TextBlockUtils.empty(0.0, 0.0);
    }

    public XDimension2D getBigDim(StringBounder stringBounder) {
        XDimension2D dimComment = this.getCommentBlock().calculateDimension(stringBounder);
        XDimension2D dimSmall = this.getSmallBlock().calculateDimension(stringBounder);
        XDimension2D mergeTB = dimComment.mergeTB(dimSmall);
        return mergeTB.delta(8.0, 2.0);
    }

    public void drawBorder(UGraphic ug, XDimension2D sizeInDot) {
        TextBlock comment = this.getCommentBlock();
        TextBlock small = this.getSmallBlock();
        double moveY = comment.calculateDimension(ug.getStringBounder()).getHeight();
        URectangle rect = URectangle.build(sizeInDot.getWidth(), sizeInDot.getHeight() - moveY).rounded(8.0);
        ug.apply(UStroke.withThickness(1.5)).apply(UTranslate.dy(moveY)).draw(rect);
        comment.drawU(ug);
        double deltaWidth = rect.getWidth() - small.calculateDimension(ug.getStringBounder()).getWidth();
        double deltaHeight = rect.getHeight() - small.calculateDimension(ug.getStringBounder()).getHeight();
        small.drawU(ug.apply(new UTranslate(deltaWidth / 2.0, moveY + deltaHeight / 2.0)));
    }
}

