/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import java.awt.Color;
import jcckit.graphic.Anchor;
import jcckit.graphic.FontStyle;
import jcckit.graphic.ShapeAttributes;
import jcckit.graphic.TextAttributes;
import jcckit.util.ConfigParameters;

public class BasicGraphicAttributes
extends ShapeAttributes
implements TextAttributes {
    public static final String TEXT_COLOR_KEY = "textColor";
    public static final String FONT_NAME_KEY = "fontName";
    public static final String FONT_STYLE_KEY = "fontStyle";
    public static final String FONT_SIZE_KEY = "fontSize";
    public static final String HORIZONTAL_ANCHOR_KEY = "horizontalAnchor";
    public static final String VERTICAL_ANCHOR_KEY = "verticalAnchor";
    public static final String ORIENTATION_ANGLE_KEY = "orientationAngle";
    private final Color _textColor;
    private final String _fontName;
    private final FontStyle _fontStyle;
    private final double _fontSize;
    private final double _orientationAngle;
    private final Anchor _horizontalAnchor;
    private final Anchor _verticalAnchor;

    public BasicGraphicAttributes(ConfigParameters config) {
        super(config);
        this._textColor = config.getColor(TEXT_COLOR_KEY, null);
        this._fontName = config.get(FONT_NAME_KEY, null);
        this._fontStyle = FontStyle.getFontStyle(config, FONT_STYLE_KEY, FontStyle.NORMAL);
        this._fontSize = config.getDouble(FONT_SIZE_KEY, 0.0);
        this._orientationAngle = config.getDouble(ORIENTATION_ANGLE_KEY, 0.0);
        this._horizontalAnchor = Anchor.getHorizontalAnchor(config, HORIZONTAL_ANCHOR_KEY, Anchor.LEFT_BOTTOM);
        this._verticalAnchor = Anchor.getVerticalAnchor(config, VERTICAL_ANCHOR_KEY, Anchor.CENTER);
    }

    public BasicGraphicAttributes(Color fillColor, Color lineColor, double lineThickness, double[] linePattern, Color textColor, String fontName, FontStyle fontStyle, double fontSize, double orientationAngle, Anchor horizontalAnchor, Anchor verticalAnchor) {
        super(fillColor, lineColor, lineThickness, linePattern);
        this._textColor = textColor;
        this._fontName = fontName;
        this._fontStyle = fontStyle;
        this._fontSize = fontSize;
        this._orientationAngle = orientationAngle;
        this._horizontalAnchor = horizontalAnchor;
        this._verticalAnchor = verticalAnchor;
    }

    @Override
    public Color getTextColor() {
        return this._textColor;
    }

    @Override
    public String getFontName() {
        return this._fontName;
    }

    @Override
    public FontStyle getFontStyle() {
        return this._fontStyle;
    }

    @Override
    public double getFontSize() {
        return this._fontSize;
    }

    @Override
    public double getOrientationAngle() {
        return this._orientationAngle;
    }

    @Override
    public Anchor getHorizontalAnchor() {
        return this._horizontalAnchor;
    }

    @Override
    public Anchor getVerticalAnchor() {
        return this._verticalAnchor;
    }
}

