/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.CTM;
import org.apache.fop.area.DestinationData;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.NormalFlow;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlock;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.Visibility;
import org.apache.fop.util.ColorUtil;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.fop.util.ContentHandlerFactoryRegistry;
import org.apache.fop.util.ConversionUtils;
import org.apache.fop.util.DefaultErrorListener;
import org.apache.fop.util.LanguageTags;
import org.apache.fop.util.XMLUtil;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.util.QName;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class AreaTreeParser {
    protected static final Log log = LogFactory.getLog(AreaTreeParser.class);
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();

    public void parse(Source src, AreaTreeModel treeModel, FOUserAgent userAgent) throws TransformerException {
        Transformer transformer = tFactory.newTransformer();
        transformer.setErrorListener((ErrorListener)new DefaultErrorListener(log));
        SAXResult res = new SAXResult(this.getContentHandler(treeModel, userAgent));
        transformer.transform(src, res);
    }

    public ContentHandler getContentHandler(AreaTreeModel treeModel, FOUserAgent userAgent) {
        ElementMappingRegistry elementMappingRegistry = userAgent.getElementMappingRegistry();
        return new Handler(treeModel, userAgent, elementMappingRegistry);
    }

    private static class Handler
    extends DefaultHandler {
        private Map<String, AbstractMaker> makers = new HashMap<String, AbstractMaker>();
        private AreaTreeModel treeModel;
        private FOUserAgent userAgent;
        private ElementMappingRegistry elementMappingRegistry;
        private Attributes lastAttributes;
        private CharBuffer content = CharBuffer.allocate(64);
        private boolean ignoreCharacters = true;
        private PageViewport currentPageViewport;
        private Map<String, PageViewport> pageViewportsByKey = new HashMap<String, PageViewport>();
        private Set<String> idFirstsAssigned = new HashSet<String>();
        private Stack<Object> areaStack = new Stack();
        private boolean firstFlow;
        private Stack<String> delegateStack = new Stack();
        private ContentHandler delegate;
        private DOMImplementation domImplementation;
        private Locator locator;
        private static final Object[] SUBSET_COMMON = new Object[]{Trait.PROD_ID, Trait.LAYER};
        private static final Object[] SUBSET_LINK = new Object[]{Trait.INTERNAL_LINK, Trait.EXTERNAL_LINK};
        private static final Object[] SUBSET_COLOR = new Object[]{Trait.BACKGROUND, Trait.COLOR};
        private static final Object[] SUBSET_FONT = new Object[]{Trait.FONT, Trait.FONT_SIZE, Trait.BLINK, Trait.OVERLINE, Trait.OVERLINE_COLOR, Trait.LINETHROUGH, Trait.LINETHROUGH_COLOR, Trait.UNDERLINE, Trait.UNDERLINE_COLOR};
        private static final Object[] SUBSET_BOX = new Object[]{Trait.BORDER_BEFORE, Trait.BORDER_AFTER, Trait.BORDER_START, Trait.BORDER_END, Trait.SPACE_BEFORE, Trait.SPACE_AFTER, Trait.SPACE_START, Trait.SPACE_END, Trait.PADDING_BEFORE, Trait.PADDING_AFTER, Trait.PADDING_START, Trait.PADDING_END, Trait.START_INDENT, Trait.END_INDENT, Trait.IS_REFERENCE_AREA, Trait.IS_VIEWPORT_AREA};
        private static final Object[] SUBSET_BORDER_PADDING = new Object[]{Trait.BORDER_BEFORE, Trait.BORDER_AFTER, Trait.BORDER_START, Trait.BORDER_END, Trait.PADDING_BEFORE, Trait.PADDING_AFTER, Trait.PADDING_START, Trait.PADDING_END};

        public Handler(AreaTreeModel treeModel, FOUserAgent userAgent, ElementMappingRegistry elementMappingRegistry) {
            this.treeModel = treeModel;
            this.userAgent = userAgent;
            this.elementMappingRegistry = elementMappingRegistry;
            this.makers.put("areaTree", new AreaTreeMaker());
            this.makers.put("page", new PageMaker());
            this.makers.put("pageSequence", new PageSequenceMaker());
            this.makers.put("title", new TitleMaker());
            this.makers.put("pageViewport", new PageViewportMaker());
            this.makers.put("regionViewport", new RegionViewportMaker());
            this.makers.put("regionBefore", new RegionBeforeMaker());
            this.makers.put("regionAfter", new RegionAfterMaker());
            this.makers.put("regionStart", new RegionStartMaker());
            this.makers.put("regionEnd", new RegionEndMaker());
            this.makers.put("regionBody", new RegionBodyMaker());
            this.makers.put("flow", new FlowMaker());
            this.makers.put("mainReference", new MainReferenceMaker());
            this.makers.put("span", new SpanMaker());
            this.makers.put("footnote", new FootnoteMaker());
            this.makers.put("beforeFloat", new BeforeFloatMaker());
            this.makers.put("block", new BlockMaker());
            this.makers.put("lineArea", new LineAreaMaker());
            this.makers.put("inline", new InlineMaker());
            this.makers.put("inlineblock", new InlineBlockMaker());
            this.makers.put("inlineparent", new InlineParentMaker());
            this.makers.put("inlineblockparent", new InlineBlockParentMaker());
            this.makers.put("text", new TextMaker());
            this.makers.put("word", new WordMaker());
            this.makers.put("space", new SpaceMaker());
            this.makers.put("leader", new LeaderMaker());
            this.makers.put("viewport", new InlineViewportMaker());
            this.makers.put("container", new ContainerMaker());
            this.makers.put("image", new ImageMaker());
            this.makers.put("foreignObject", new ForeignObjectMaker());
            this.makers.put("bookmarkTree", new BookmarkTreeMaker());
            this.makers.put("bookmark", new BookmarkMaker());
            this.makers.put("destination", new DestinationMaker());
        }

        private Area findAreaType(Class clazz) {
            if (this.areaStack.size() > 0) {
                int pos;
                Object obj = null;
                for (pos = this.areaStack.size() - 1; pos >= 0 && !clazz.isInstance(obj = this.areaStack.get(pos)); --pos) {
                }
                if (pos >= 0) {
                    return obj;
                }
            }
            return null;
        }

        private RegionViewport getCurrentRegionViewport() {
            return (RegionViewport)this.findAreaType(RegionViewport.class);
        }

        private BodyRegion getCurrentBodyRegion() {
            return (BodyRegion)this.findAreaType(BodyRegion.class);
        }

        private BlockParent getCurrentBlockParent() {
            return (BlockParent)this.findAreaType(BlockParent.class);
        }

        private AbstractTextArea getCurrentText() {
            return (AbstractTextArea)this.findAreaType(AbstractTextArea.class);
        }

        private InlineViewport getCurrentViewport() {
            return (InlineViewport)this.findAreaType(InlineViewport.class);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private Locator getLocator() {
            return this.locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.delegate != null) {
                this.delegateStack.push(qName);
                this.delegate.startElement(uri, localName, qName, attributes);
            } else if (this.domImplementation != null) {
                TransformerHandler handler;
                try {
                    handler = tFactory.newTransformerHandler();
                }
                catch (TransformerConfigurationException e) {
                    throw new SAXException("Error creating a new TransformerHandler", e);
                }
                Document doc = this.domImplementation.createDocument(uri, qName, null);
                doc.removeChild(doc.getDocumentElement());
                handler.setResult(new DOMResult(doc));
                Area parent = (Area)this.areaStack.peek();
                ((ForeignObject)parent).setDocument(doc);
                this.domImplementation = null;
                this.delegate = handler;
                this.delegateStack.push(qName);
                this.delegate.startDocument();
                this.delegate.startElement(uri, localName, qName, attributes);
            } else {
                boolean handled = true;
                if ("".equals(uri)) {
                    if (localName.equals("structureTree")) {
                        this.delegate = new DefaultHandler();
                        this.delegateStack.push(qName);
                        this.delegate.startDocument();
                        this.delegate.startElement(uri, localName, qName, attributes);
                    } else {
                        handled = this.startAreaTreeElement(localName, attributes);
                    }
                } else {
                    ContentHandlerFactoryRegistry registry = this.userAgent.getContentHandlerFactoryRegistry();
                    ContentHandlerFactory factory = registry.getFactory(uri);
                    if (factory != null) {
                        this.delegate = factory.createContentHandler();
                        this.delegateStack.push(qName);
                        this.delegate.startDocument();
                        this.delegate.startElement(uri, localName, qName, attributes);
                    } else {
                        handled = false;
                    }
                }
                if (!handled) {
                    if (uri == null || uri.length() == 0) {
                        throw new SAXException("Unhandled element " + localName + " in namespace: " + uri);
                    }
                    log.warn((Object)("Unhandled element " + localName + " in namespace: " + uri));
                }
            }
        }

        private boolean startAreaTreeElement(String localName, Attributes attributes) throws SAXException {
            this.lastAttributes = new AttributesImpl(attributes);
            Maker maker = this.makers.get(localName);
            this.content.clear();
            this.ignoreCharacters = true;
            if (maker != null) {
                this.ignoreCharacters = maker.ignoreCharacters();
                maker.startElement(attributes);
            } else if (!"extension-attachments".equals(localName)) {
                return false;
            }
            return true;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.delegate != null) {
                this.delegate.endElement(uri, localName, qName);
                this.delegateStack.pop();
                if (this.delegateStack.size() == 0) {
                    this.delegate.endDocument();
                    if (this.delegate instanceof ContentHandlerFactory.ObjectSource) {
                        Object obj = ((ContentHandlerFactory.ObjectSource)((Object)this.delegate)).getObject();
                        this.handleExternallyGeneratedObject(obj);
                    }
                    this.delegate = null;
                }
            } else if ("".equals(uri)) {
                Maker maker = this.makers.get(localName);
                if (maker != null) {
                    maker.endElement();
                    this.content.clear();
                }
                this.ignoreCharacters = true;
            }
        }

        private void pushNewRegionReference(Attributes attributes, int side) {
            String regionName = attributes.getValue("name");
            RegionViewport rv = this.getCurrentRegionViewport();
            RegionReference reg = new RegionReference(side, regionName, rv);
            Handler.transferForeignObjects(attributes, reg);
            reg.setCTM(Handler.getAttributeAsCTM(attributes, "ctm"));
            this.setAreaAttributes(attributes, reg);
            this.setTraits(attributes, reg, SUBSET_BORDER_PADDING);
            rv.setRegionReference(reg);
            this.currentPageViewport.getPage().setRegionViewport(side, rv);
            this.areaStack.push(reg);
        }

        private void assertObjectOfClass(Object obj, Class clazz) {
            if (!clazz.isInstance(obj)) {
                throw new IllegalStateException("Object is not an instance of " + clazz.getName() + " but of " + obj.getClass().getName());
            }
        }

        protected void handleExternallyGeneratedObject(Object obj) {
            if (this.areaStack.size() == 0 && obj instanceof ExtensionAttachment) {
                ExtensionAttachment attachment = (ExtensionAttachment)obj;
                if (this.currentPageViewport == null) {
                    this.treeModel.handleOffDocumentItem(new OffDocumentExtensionAttachment(attachment));
                } else {
                    this.currentPageViewport.addExtensionAttachment(attachment);
                }
            } else {
                Object o = this.areaStack.peek();
                if (o instanceof AreaTreeObject && obj instanceof ExtensionAttachment) {
                    AreaTreeObject ato = (AreaTreeObject)o;
                    ExtensionAttachment attachment = (ExtensionAttachment)obj;
                    ato.addExtensionAttachment(attachment);
                } else {
                    log.warn((Object)("Don't know how to handle externally generated object: " + obj));
                }
            }
        }

        private void setAreaAttributes(Attributes attributes, Area area) {
            area.setIPD(Integer.parseInt(attributes.getValue("ipd")));
            area.setBPD(Integer.parseInt(attributes.getValue("bpd")));
            area.setBidiLevel(XMLUtil.getAttributeAsInt(attributes, "level", -1));
        }

        private void setTraits(Attributes attributes, Area area, Object[] traitSubset) {
            int i = traitSubset.length;
            while (--i >= 0) {
                String fontName;
                Integer trait = (Integer)traitSubset[i];
                String traitName = Trait.getTraitName(trait);
                String value = attributes.getValue(traitName);
                if (value != null) {
                    Class cl = Trait.getTraitClass(trait);
                    if (cl == Integer.class) {
                        area.addTrait(trait, Integer.valueOf(value));
                        continue;
                    }
                    if (cl == Boolean.class) {
                        area.addTrait(trait, Boolean.valueOf(value));
                        continue;
                    }
                    if (cl == String.class) {
                        area.addTrait(trait, value);
                        if (!Trait.PROD_ID.equals(trait) || this.idFirstsAssigned.contains(value) || this.currentPageViewport == null) continue;
                        this.currentPageViewport.setFirstWithID(value);
                        this.idFirstsAssigned.add(value);
                        continue;
                    }
                    if (cl == Color.class) {
                        try {
                            area.addTrait(trait, ColorUtil.parseColorString(this.userAgent, value));
                            continue;
                        }
                        catch (PropertyException e) {
                            throw new IllegalArgumentException(e.getMessage());
                        }
                    }
                    if (cl == Trait.InternalLink.class) {
                        area.addTrait(trait, new Trait.InternalLink(value));
                        continue;
                    }
                    if (cl == Trait.ExternalLink.class) {
                        area.addTrait(trait, Trait.ExternalLink.makeFromTraitValue(value));
                        continue;
                    }
                    if (cl == Trait.Background.class) {
                        Trait.Background bkg = new Trait.Background();
                        try {
                            Color col = ColorUtil.parseColorString(this.userAgent, attributes.getValue("bkg-color"));
                            bkg.setColor(col);
                        }
                        catch (PropertyException e) {
                            throw new IllegalArgumentException(e.getMessage());
                        }
                        String uri = attributes.getValue("bkg-img");
                        if (uri != null) {
                            ResourceEventProducer eventProducer;
                            bkg.setURL(uri);
                            try {
                                ImageManager manager = this.userAgent.getImageManager();
                                ImageSessionContext sessionContext = this.userAgent.getImageSessionContext();
                                ImageInfo info = manager.getImageInfo(uri, sessionContext);
                                bkg.setImageInfo(info);
                            }
                            catch (ImageException e) {
                                eventProducer = ResourceEventProducer.Provider.get(this.userAgent.getEventBroadcaster());
                                eventProducer.imageError(this, uri, e, this.getLocator());
                            }
                            catch (FileNotFoundException fnfe) {
                                eventProducer = ResourceEventProducer.Provider.get(this.userAgent.getEventBroadcaster());
                                eventProducer.imageNotFound(this, uri, fnfe, this.getLocator());
                            }
                            catch (IOException ioe) {
                                eventProducer = ResourceEventProducer.Provider.get(this.userAgent.getEventBroadcaster());
                                eventProducer.imageIOError(this, uri, ioe, this.getLocator());
                            }
                            String repeat = attributes.getValue("bkg-repeat");
                            if (repeat != null) {
                                bkg.setRepeat(repeat);
                            }
                            bkg.setHoriz(XMLUtil.getAttributeAsInt(attributes, "bkg-horz-offset", 0));
                            bkg.setVertical(XMLUtil.getAttributeAsInt(attributes, "bkg-vert-offset", 0));
                        }
                        area.addTrait(trait, bkg);
                        continue;
                    }
                    if (cl != BorderProps.class) continue;
                    area.addTrait(trait, BorderProps.valueOf(this.userAgent, value));
                    continue;
                }
                if (!Trait.FONT.equals(trait) || (fontName = attributes.getValue("font-name")) == null) continue;
                String fontStyle = attributes.getValue("font-style");
                int fontWeight = XMLUtil.getAttributeAsInt(attributes, "font-weight", 400);
                area.addTrait(trait, FontInfo.createFontKey(fontName, fontStyle, fontWeight));
            }
        }

        private static CTM getAttributeAsCTM(Attributes attributes, String name) {
            String s = attributes.getValue(name).trim();
            if (s.startsWith("[") && s.endsWith("]")) {
                double[] values = ConversionUtils.toDoubleArray(s = s.substring(1, s.length() - 1), "\\s");
                if (values.length != 6) {
                    throw new IllegalArgumentException("CTM must consist of 6 double values!");
                }
                return new CTM(values[0], values[1], values[2], values[3], values[4], values[5]);
            }
            throw new IllegalArgumentException("CTM must be surrounded by square brackets!");
        }

        private static void transferForeignObjects(Attributes atts, AreaTreeObject ato) {
            int c = atts.getLength();
            for (int i = 0; i < c; ++i) {
                String ns = atts.getURI(i);
                if (ns.length() <= 0 || "http://www.w3.org/2000/xmlns/".equals(ns)) continue;
                QName qname = new QName(ns, atts.getQName(i));
                ato.setForeignAttribute(qname, atts.getValue(i));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(ch, start, length);
            } else if (!this.ignoreCharacters) {
                int maxLength = this.content.capacity() - this.content.position();
                if (maxLength < length) {
                    CharBuffer newContent = CharBuffer.allocate(this.content.position() + length);
                    this.content.flip();
                    newContent.put(this.content);
                    this.content = newContent;
                }
                this.content.limit(this.content.capacity());
                this.content.put(ch, start, length);
                if (this.content.position() < this.content.limit()) {
                    this.content.limit(this.content.position());
                }
            }
        }

        private class DestinationMaker
        extends AbstractMaker {
            private DestinationMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                String[] linkdata = Trait.InternalLink.parseXMLAttribute(Handler.this.lastAttributes.getValue("internal-link"));
                PageViewport pv = (PageViewport)Handler.this.pageViewportsByKey.get(linkdata[0]);
                DestinationData dest = new DestinationData(linkdata[1]);
                ArrayList<PageViewport> pages = new ArrayList<PageViewport>();
                pages.add(pv);
                dest.resolveIDRef(linkdata[1], pages);
                Handler.this.areaStack.push(dest);
            }

            @Override
            public void endElement() {
                Object tos = Handler.this.areaStack.pop();
                Handler.this.assertObjectOfClass(tos, DestinationData.class);
                Handler.this.treeModel.handleOffDocumentItem((DestinationData)tos);
            }
        }

        private class BookmarkMaker
        extends AbstractMaker {
            private BookmarkMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                String title = attributes.getValue("title");
                boolean showChildren = XMLUtil.getAttributeAsBoolean(attributes, "show-children", false);
                String[] linkdata = Trait.InternalLink.parseXMLAttribute(attributes.getValue("internal-link"));
                PageViewport pv = (PageViewport)Handler.this.pageViewportsByKey.get(linkdata[0]);
                BookmarkData bm = new BookmarkData(title, showChildren, pv, linkdata[1]);
                Object tos = Handler.this.areaStack.peek();
                if (tos instanceof BookmarkData) {
                    BookmarkData parent = (BookmarkData)tos;
                    parent.addSubData(bm);
                }
                Handler.this.areaStack.push(bm);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), BookmarkData.class);
            }
        }

        private class BookmarkTreeMaker
        extends AbstractMaker {
            private BookmarkTreeMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                BookmarkData bm = new BookmarkData();
                Handler.this.areaStack.push(bm);
            }

            @Override
            public void endElement() {
                Object tos = Handler.this.areaStack.pop();
                Handler.this.assertObjectOfClass(tos, BookmarkData.class);
                Handler.this.treeModel.handleOffDocumentItem((BookmarkData)tos);
            }
        }

        private class ForeignObjectMaker
        extends AbstractMaker {
            private ForeignObjectMaker() {
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
                String ns = attributes.getValue("ns");
                Handler.this.domImplementation = Handler.this.elementMappingRegistry.getDOMImplementationForNamespace(ns);
                if (Handler.this.domImplementation == null) {
                    throw new SAXException("No DOMImplementation could be identified to handle namespace: " + ns);
                }
                ForeignObject foreign = new ForeignObject(ns);
                Handler.transferForeignObjects(attributes, foreign);
                Handler.this.setAreaAttributes(attributes, foreign);
                Handler.this.setTraits(attributes, foreign, SUBSET_COMMON);
                Handler.this.getCurrentViewport().setContent(foreign);
                Handler.this.areaStack.push(foreign);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), ForeignObject.class);
            }
        }

        private class ImageMaker
        extends AbstractMaker {
            private ImageMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                String url = attributes.getValue("url");
                Image image = new Image(url);
                Handler.transferForeignObjects(attributes, image);
                Handler.this.setAreaAttributes(attributes, image);
                Handler.this.setTraits(attributes, image, SUBSET_COMMON);
                Handler.this.getCurrentViewport().setContent(image);
            }
        }

        private class InlineViewportMaker
        extends AbstractMaker {
            private InlineViewportMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                int level = XMLUtil.getAttributeAsInt(attributes, "level", -1);
                InlineViewport viewport = new InlineViewport(null, level);
                Handler.transferForeignObjects(attributes, viewport);
                Handler.this.setAreaAttributes(attributes, viewport);
                Handler.this.setTraits(attributes, viewport, SUBSET_COMMON);
                Handler.this.setTraits(attributes, viewport, SUBSET_BOX);
                Handler.this.setTraits(attributes, viewport, SUBSET_COLOR);
                viewport.setContentPosition(XMLUtil.getAttributeAsRectangle2D(attributes, "pos"));
                viewport.setClip(XMLUtil.getAttributeAsBoolean(attributes, "clip", false));
                viewport.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(viewport);
                Handler.this.areaStack.push(viewport);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineViewport.class);
            }
        }

        private class ContainerMaker
        extends AbstractMaker {
            private ContainerMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Container container = new Container();
                Handler.transferForeignObjects(attributes, container);
                InlineViewport parent = (InlineViewport)Handler.this.areaStack.peek();
                parent.setContent(container);
                Handler.this.areaStack.push(container);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), Container.class);
            }
        }

        private class LeaderMaker
        extends AbstractMaker {
            private LeaderMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Leader leader = new Leader();
                Handler.transferForeignObjects(attributes, leader);
                Handler.this.setAreaAttributes(attributes, leader);
                Handler.this.setTraits(attributes, leader, SUBSET_COMMON);
                Handler.this.setTraits(attributes, leader, SUBSET_BOX);
                Handler.this.setTraits(attributes, leader, SUBSET_COLOR);
                Handler.this.setTraits(attributes, leader, SUBSET_FONT);
                leader.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                String ruleStyle = attributes.getValue("ruleStyle");
                if (ruleStyle != null) {
                    leader.setRuleStyle(ruleStyle);
                }
                leader.setRuleThickness(XMLUtil.getAttributeAsInt(attributes, "ruleThickness", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(leader);
            }
        }

        private class SpaceMaker
        extends AbstractMaker {
            private SpaceMaker() {
            }

            @Override
            public void endElement() {
                int offset = XMLUtil.getAttributeAsInt(Handler.this.lastAttributes, "offset", 0);
                if (Handler.this.content.position() > 0) {
                    Handler.this.content.flip();
                    boolean adjustable = XMLUtil.getAttributeAsBoolean(Handler.this.lastAttributes, "adj", true);
                    int level = XMLUtil.getAttributeAsInt(Handler.this.lastAttributes, "level", -1);
                    SpaceArea space = new SpaceArea(offset, level, Handler.this.content.charAt(0), adjustable);
                    AbstractTextArea text = Handler.this.getCurrentText();
                    space.setParentArea(text);
                    text.addChildArea(space);
                } else {
                    Space space = new Space();
                    Handler.this.setAreaAttributes(Handler.this.lastAttributes, space);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_COMMON);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_BOX);
                    Handler.this.setTraits(Handler.this.lastAttributes, space, SUBSET_COLOR);
                    space.setBlockProgressionOffset(offset);
                    Area parent = (Area)Handler.this.areaStack.peek();
                    parent.addChildArea(space);
                }
            }

            @Override
            public boolean ignoreCharacters() {
                return false;
            }
        }

        private class WordMaker
        extends AbstractMaker {
            private WordMaker() {
            }

            @Override
            public void endElement() {
                int offset = XMLUtil.getAttributeAsInt(Handler.this.lastAttributes, "offset", 0);
                int[] letterAdjust = ConversionUtils.toIntArray(Handler.this.lastAttributes.getValue("letter-adjust"), "\\s");
                int level = XMLUtil.getAttributeAsInt(Handler.this.lastAttributes, "level", -1);
                boolean reversed = XMLUtil.getAttributeAsBoolean(Handler.this.lastAttributes, "reversed", false);
                int[][] gposAdjustments = XMLUtil.getAttributeAsPositionAdjustments(Handler.this.lastAttributes, "position-adjust");
                Handler.this.content.flip();
                WordArea word = new WordArea(offset, level, Handler.this.content.toString().trim(), letterAdjust, null, gposAdjustments, reversed);
                AbstractTextArea text = Handler.this.getCurrentText();
                word.setParentArea(text);
                text.addChildArea(word);
            }

            @Override
            public boolean ignoreCharacters() {
                return false;
            }
        }

        private class TextMaker
        extends AbstractMaker {
            private TextMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                if (Handler.this.getCurrentText() != null) {
                    throw new IllegalStateException("Current Text must be null");
                }
                TextArea text = new TextArea();
                Handler.this.setAreaAttributes(attributes, text);
                Handler.this.setTraits(attributes, text, SUBSET_COMMON);
                Handler.this.setTraits(attributes, text, SUBSET_BOX);
                Handler.this.setTraits(attributes, text, SUBSET_COLOR);
                Handler.this.setTraits(attributes, text, SUBSET_FONT);
                text.setBaselineOffset(XMLUtil.getAttributeAsInt(attributes, "baseline", 0));
                text.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                text.setTextLetterSpaceAdjust(XMLUtil.getAttributeAsInt(attributes, "tlsadjust", 0));
                text.setTextWordSpaceAdjust(XMLUtil.getAttributeAsInt(attributes, "twsadjust", 0));
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(text);
                Handler.this.areaStack.push(text);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), TextArea.class);
            }
        }

        private class InlineBlockParentMaker
        extends AbstractMaker {
            private InlineBlockParentMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                InlineBlockParent ibp = new InlineBlockParent();
                Handler.transferForeignObjects(attributes, ibp);
                ibp.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, ibp);
                Handler.this.setTraits(attributes, ibp, SUBSET_COMMON);
                Handler.this.setTraits(attributes, ibp, SUBSET_BOX);
                Handler.this.setTraits(attributes, ibp, SUBSET_COLOR);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(ibp);
                Handler.this.areaStack.push(ibp);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineBlockParent.class);
            }
        }

        private class InlineParentMaker
        extends AbstractMaker {
            private InlineParentMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                InlineParent ip = new InlineParent();
                Handler.transferForeignObjects(attributes, ip);
                ip.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, ip);
                Handler.this.setTraits(attributes, ip, SUBSET_COMMON);
                Handler.this.setTraits(attributes, ip, SUBSET_BOX);
                Handler.this.setTraits(attributes, ip, SUBSET_COLOR);
                Handler.this.setTraits(attributes, ip, SUBSET_LINK);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(ip);
                Handler.this.areaStack.push(ip);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineParent.class);
            }
        }

        private class InlineBlockMaker
        extends AbstractMaker {
            private InlineBlockMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Block block = new Block();
                if (attributes.getValue("left-offset") != null) {
                    block.setXOffset(XMLUtil.getAttributeAsInt(attributes, "left-offset", 0));
                }
                if (attributes.getValue("top-offset") != null) {
                    block.setYOffset(XMLUtil.getAttributeAsInt(attributes, "top-offset", 0));
                }
                Handler.transferForeignObjects(attributes, block);
                Handler.this.setAreaAttributes(attributes, block);
                Handler.this.setTraits(attributes, block, SUBSET_COMMON);
                Handler.this.setTraits(attributes, block, SUBSET_BOX);
                Handler.this.setTraits(attributes, block, SUBSET_COLOR);
                Area parent = (Area)Handler.this.areaStack.peek();
                InlineBlock inlineBlock = new InlineBlock(block);
                parent.addChildArea(inlineBlock);
                Handler.this.areaStack.push(inlineBlock);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineBlock.class);
            }
        }

        private class InlineMaker
        extends AbstractMaker {
            private InlineMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                InlineArea inl = new InlineArea();
                Handler.transferForeignObjects(attributes, inl);
                inl.setBlockProgressionOffset(XMLUtil.getAttributeAsInt(attributes, "offset", 0));
                Handler.this.setAreaAttributes(attributes, inl);
                Handler.this.setTraits(attributes, inl, SUBSET_COMMON);
                Handler.this.setTraits(attributes, inl, SUBSET_BOX);
                Handler.this.setTraits(attributes, inl, SUBSET_COLOR);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(inl);
                Handler.this.areaStack.push(inl);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), InlineArea.class);
            }
        }

        private class LineAreaMaker
        extends AbstractMaker {
            private LineAreaMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                LineArea line = new LineArea();
                Handler.this.setAreaAttributes(attributes, line);
                Handler.this.setTraits(attributes, line, SUBSET_COMMON);
                Handler.this.setTraits(attributes, line, SUBSET_BOX);
                Handler.this.setTraits(attributes, line, SUBSET_COLOR);
                BlockParent parent = Handler.this.getCurrentBlockParent();
                parent.addChildArea(line);
                Handler.this.areaStack.push(line);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), LineArea.class);
            }
        }

        private class BlockMaker
        extends AbstractMaker {
            private BlockMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Block block;
                boolean isViewport = XMLUtil.getAttributeAsBoolean(attributes, "is-viewport-area", false);
                if (isViewport) {
                    BlockViewport bv = new BlockViewport();
                    bv.setClip(XMLUtil.getAttributeAsBoolean(attributes, "clipped", false));
                    bv.setCTM(Handler.getAttributeAsCTM(attributes, "ctm"));
                    if (bv.getPositioning() != 1) {
                        bv.setXOffset(XMLUtil.getAttributeAsInt(attributes, "left-position", 0));
                        bv.setYOffset(XMLUtil.getAttributeAsInt(attributes, "top-position", 0));
                    }
                    block = bv;
                } else {
                    block = new Block();
                }
                String positioning = attributes.getValue("positioning");
                if ("absolute".equalsIgnoreCase(positioning)) {
                    block.setPositioning(2);
                } else if ("fixed".equalsIgnoreCase(positioning)) {
                    block.setPositioning(3);
                } else if ("relative".equalsIgnoreCase(positioning)) {
                    block.setPositioning(1);
                } else {
                    block.setPositioning(0);
                }
                if (attributes.getValue("left-offset") != null) {
                    block.setXOffset(XMLUtil.getAttributeAsInt(attributes, "left-offset", 0));
                }
                if (attributes.getValue("top-offset") != null) {
                    block.setYOffset(XMLUtil.getAttributeAsInt(attributes, "top-offset", 0));
                }
                if (attributes.getValue("visibility") != null) {
                    block.addTrait(Trait.VISIBILITY, Visibility.valueOf(attributes.getValue("visibility")));
                }
                Handler.transferForeignObjects(attributes, block);
                Handler.this.setAreaAttributes(attributes, block);
                Handler.this.setTraits(attributes, block, SUBSET_COMMON);
                Handler.this.setTraits(attributes, block, SUBSET_BOX);
                Handler.this.setTraits(attributes, block, SUBSET_COLOR);
                Area parent = (Area)Handler.this.areaStack.peek();
                parent.addChildArea(block);
                Handler.this.areaStack.push(block);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), Block.class);
            }
        }

        private class BeforeFloatMaker
        extends AbstractMaker {
            private BeforeFloatMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                BeforeFloat bf = Handler.this.getCurrentBodyRegion().getBeforeFloat();
                Handler.transferForeignObjects(attributes, bf);
                Handler.this.areaStack.push(bf);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), BeforeFloat.class);
            }
        }

        private class FootnoteMaker
        extends AbstractMaker {
            private FootnoteMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Footnote fn = Handler.this.getCurrentBodyRegion().getFootnote();
                Handler.transferForeignObjects(attributes, fn);
                fn.setTop(XMLUtil.getAttributeAsInt(attributes, "top-offset", 0));
                Handler.this.areaStack.push(fn);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), Footnote.class);
            }
        }

        private class SpanMaker
        extends AbstractMaker {
            private SpanMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                String inlineDirection;
                int ipd = XMLUtil.getAttributeAsInt(attributes, "ipd", 0);
                int columnCount = XMLUtil.getAttributeAsInt(attributes, "columnCount", 1);
                BodyRegion body = Handler.this.getCurrentBodyRegion();
                Span span = new Span(columnCount, body.getColumnGap(), ipd);
                String blockDirection = attributes.getValue("block-progression-direction");
                if (blockDirection != null) {
                    span.addTrait(Trait.BLOCK_PROGRESSION_DIRECTION, Direction.valueOf(blockDirection));
                }
                if ((inlineDirection = attributes.getValue("inline-progression-direction")) != null) {
                    span.addTrait(Trait.INLINE_PROGRESSION_DIRECTION, Direction.valueOf(inlineDirection));
                }
                Handler.transferForeignObjects(attributes, span);
                Handler.this.setAreaAttributes(attributes, span);
                body.getMainReference().getSpans().add(span);
                Handler.this.firstFlow = true;
            }
        }

        private class MainReferenceMaker
        extends AbstractMaker {
            private MainReferenceMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                MainReference mr = Handler.this.getCurrentBodyRegion().getMainReference();
                Handler.transferForeignObjects(attributes, mr);
                Handler.this.setAreaAttributes(attributes, mr);
            }
        }

        private class FlowMaker
        extends AbstractMaker {
            private FlowMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                BodyRegion body = Handler.this.getCurrentBodyRegion();
                if (!Handler.this.firstFlow) {
                    body.getMainReference().getCurrentSpan().moveToNextFlow();
                } else {
                    Handler.this.firstFlow = false;
                }
                NormalFlow flow = body.getMainReference().getCurrentSpan().getCurrentFlow();
                Handler.transferForeignObjects(attributes, flow);
                Handler.this.setAreaAttributes(attributes, flow);
                Handler.this.areaStack.push(flow);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), NormalFlow.class);
            }
        }

        private class RegionBodyMaker
        extends AbstractMaker {
            private RegionBodyMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                BodyRegion body = Handler.this.getCurrentBodyRegion();
                if (body != null) {
                    throw new IllegalStateException("Current BodyRegion must be null");
                }
                String regionName = attributes.getValue("name");
                int columnCount = XMLUtil.getAttributeAsInt(attributes, "columnCount", 1);
                int columnGap = XMLUtil.getAttributeAsInt(attributes, "columnGap", 0);
                RegionViewport rv = Handler.this.getCurrentRegionViewport();
                body = new BodyRegion(58, regionName, rv, columnCount, columnGap);
                Handler.transferForeignObjects(attributes, body);
                body.setCTM(Handler.getAttributeAsCTM(attributes, "ctm"));
                Handler.this.setAreaAttributes(attributes, body);
                Handler.this.setTraits(attributes, body, SUBSET_BORDER_PADDING);
                rv.setRegionReference(body);
                Handler.this.currentPageViewport.getPage().setRegionViewport(58, rv);
                Handler.this.areaStack.push(body);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), BodyRegion.class);
            }
        }

        private class RegionEndMaker
        extends AbstractMaker {
            private RegionEndMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 59);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionReference.class);
            }
        }

        private class RegionStartMaker
        extends AbstractMaker {
            private RegionStartMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 61);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionReference.class);
            }
        }

        private class RegionAfterMaker
        extends AbstractMaker {
            private RegionAfterMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 56);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionReference.class);
            }
        }

        private class RegionBeforeMaker
        extends AbstractMaker {
            private RegionBeforeMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Handler.this.pushNewRegionReference(attributes, 57);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionReference.class);
            }
        }

        private class RegionViewportMaker
        extends AbstractMaker {
            private RegionViewportMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                RegionViewport rv = Handler.this.getCurrentRegionViewport();
                if (rv != null) {
                    throw new IllegalStateException("Current RegionViewport must be null");
                }
                Rectangle2D viewArea = XMLUtil.getAttributeAsRectangle2D(attributes, "rect");
                rv = new RegionViewport(viewArea);
                Handler.transferForeignObjects(attributes, rv);
                rv.setClip(XMLUtil.getAttributeAsBoolean(attributes, "clipped", false));
                Handler.this.setAreaAttributes(attributes, rv);
                Handler.this.setTraits(attributes, rv, SUBSET_COMMON);
                Handler.this.setTraits(attributes, rv, SUBSET_BOX);
                Handler.this.setTraits(attributes, rv, SUBSET_COLOR);
                Handler.this.areaStack.push(rv);
            }

            @Override
            public void endElement() {
                Handler.this.assertObjectOfClass(Handler.this.areaStack.pop(), RegionViewport.class);
            }
        }

        private class PageMaker
        extends AbstractMaker {
            private PageMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Page p = new Page();
                Handler.this.currentPageViewport.setPage(p);
            }

            @Override
            public void endElement() {
                Handler.this.treeModel.addPage(Handler.this.currentPageViewport);
                Handler.this.currentPageViewport = null;
            }
        }

        private class PageViewportMaker
        extends AbstractMaker {
            private PageViewportMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                if (!Handler.this.areaStack.isEmpty()) {
                    PageSequence pageSequence = (PageSequence)Handler.this.areaStack.peek();
                    Handler.this.treeModel.startPageSequence(pageSequence);
                    Handler.this.areaStack.pop();
                }
                if (Handler.this.currentPageViewport != null) {
                    throw new IllegalStateException("currentPageViewport must be null");
                }
                Rectangle viewArea = XMLUtil.getAttributeAsRectangle(attributes, "bounds");
                int pageNumber = XMLUtil.getAttributeAsInt(attributes, "nr", -1);
                String key = attributes.getValue("key");
                String pageNumberString = attributes.getValue("formatted-nr");
                String pageMaster = attributes.getValue("simple-page-master-name");
                boolean blank = XMLUtil.getAttributeAsBoolean(attributes, "blank", false);
                Handler.this.currentPageViewport = new PageViewport(viewArea, pageNumber, pageNumberString, pageMaster, blank);
                Handler.transferForeignObjects(attributes, Handler.this.currentPageViewport);
                Handler.this.currentPageViewport.setKey(key);
                Handler.this.pageViewportsByKey.put(key, Handler.this.currentPageViewport);
            }
        }

        private class TitleMaker
        extends AbstractMaker {
            private TitleMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                LineArea line = new LineArea();
                Handler.transferForeignObjects(attributes, line);
                Handler.this.areaStack.push(line);
            }

            @Override
            public void endElement() {
                LineArea line = (LineArea)Handler.this.areaStack.pop();
                PageSequence pageSequence = (PageSequence)Handler.this.areaStack.peek();
                pageSequence.setTitle(line);
            }
        }

        private class PageSequenceMaker
        extends AbstractMaker {
            private PageSequenceMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                PageSequence pageSequence = new PageSequence(null);
                String lang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                if (lang != null) {
                    pageSequence.setLocale(LanguageTags.toLocale(lang));
                }
                Handler.transferForeignObjects(attributes, pageSequence);
                Handler.this.areaStack.push(pageSequence);
            }
        }

        private class AreaTreeMaker
        extends AbstractMaker {
            private AreaTreeMaker() {
            }

            @Override
            public void startElement(Attributes attributes) {
                Handler.this.idFirstsAssigned.clear();
            }
        }

        private abstract class AbstractMaker
        implements Maker {
            private AbstractMaker() {
            }

            @Override
            public void startElement(Attributes attributes) throws SAXException {
            }

            @Override
            public void endElement() {
            }

            @Override
            public boolean ignoreCharacters() {
                return true;
            }
        }

        private static interface Maker {
            public void startElement(Attributes var1) throws SAXException;

            public void endElement();

            public boolean ignoreCharacters();
        }
    }
}

