/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;

public class InstructionSpot
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final LinkRendering inlinkRendering;
    private final String spot;

    public InstructionSpot(String spot, LinkRendering inlinkRendering, Swimlane swimlane) {
        super(swimlane);
        this.spot = spot;
        this.inlinkRendering = inlinkRendering;
        if (inlinkRendering == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile result = factory.spot(this.getSwimlaneIn(), this.spot);
        result = this.eventuallyAddNote(factory, result, result.getSwimlaneIn());
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    @Override
    public void add(Instruction other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean kill() {
        this.killed = true;
        return true;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }
}

