/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.List;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.fonts.AFPBase12FontCollection;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.AFPFontInfo;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;

public class AFPFontCollection
implements FontCollection {
    private final AFPEventProducer eventProducer;
    private final List<AFPFontInfo> fontInfoList;

    public AFPFontCollection(EventBroadcaster eventBroadcaster, List<AFPFontInfo> fontInfoList) {
        this.eventProducer = AFPEventProducer.Provider.get(eventBroadcaster);
        this.fontInfoList = fontInfoList;
    }

    @Override
    public int setup(int start, FontInfo fontInfo) {
        int num = 1;
        if (this.fontInfoList != null && this.fontInfoList.size() > 0) {
            for (AFPFontInfo afpFontInfo : this.fontInfoList) {
                AFPFont afpFont = afpFontInfo.getAFPFont();
                List<FontTriplet> tripletList = afpFontInfo.getFontTriplets();
                for (FontTriplet triplet : tripletList) {
                    fontInfo.addMetrics("F" + num, afpFont);
                    fontInfo.addFontProperties("F" + num, triplet.getName(), triplet.getStyle(), triplet.getWeight());
                    ++num;
                }
            }
            this.checkDefaultFontAvailable(fontInfo, "normal", 400);
            this.checkDefaultFontAvailable(fontInfo, "italic", 400);
            this.checkDefaultFontAvailable(fontInfo, "normal", 700);
            this.checkDefaultFontAvailable(fontInfo, "italic", 700);
        } else {
            this.eventProducer.warnDefaultFontSetup(this);
            AFPBase12FontCollection base12FontCollection = new AFPBase12FontCollection(this.eventProducer);
            num = base12FontCollection.setup(num, fontInfo);
        }
        return num;
    }

    private void checkDefaultFontAvailable(FontInfo fontInfo, String style, int weight) {
        if (!fontInfo.hasFont("any", style, weight)) {
            this.eventProducer.warnMissingDefaultFont(this, style, weight);
        }
    }
}

