/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TileMarged
implements Tile {
    private final Tile tile;
    private final double x1;
    private final double x2;
    private final double y1;
    private final double y2;

    public TileMarged(Tile tile, double x1, double x2, double y1, double y2) {
        this.tile = tile;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.tile.drawU(ug.apply(new UTranslate(this.x1, this.y1)));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.tile.getPreferredHeight(stringBounder) + this.y1 + this.y2;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        this.tile.addConstraints(stringBounder);
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.tile.getMinX(stringBounder);
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.tile.getMaxX(stringBounder).addFixed(this.x1 + this.x2);
    }

    @Override
    public Event getEvent() {
        return this.tile.getEvent();
    }
}

