/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolStack
extends USymbol {
    USymbolStack() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.STACK;
    }

    private void drawQueue(UGraphic ug, double width, double height, boolean shadowing, double roundCorner) {
        double border = 15.0;
        URectangle rect = new URectangle(width - 30.0, height, roundCorner, roundCorner);
        if (shadowing) {
            rect.setDeltaShadow(3.0);
        }
        ug.apply(new UChangeColor(null)).apply(new UTranslate(15.0, 0.0)).draw(rect);
        UPath path = new UPath();
        if (roundCorner == 0.0) {
            path.moveTo(0.0, 0.0);
            path.lineTo(15.0, 0.0);
            path.lineTo(15.0, height);
            path.lineTo(width - 15.0, height);
            path.lineTo(width - 15.0, 0.0);
            path.lineTo(width, 0.0);
        } else {
            path.moveTo(0.0, 0.0);
            path.lineTo(15.0 - roundCorner / 2.0, 0.0);
            path.arcTo(new Point2D.Double(15.0, roundCorner / 2.0), roundCorner / 2.0, 0.0, 1.0);
            path.lineTo(15.0, height - roundCorner / 2.0);
            path.arcTo(new Point2D.Double(15.0 + roundCorner / 2.0, height), roundCorner / 2.0, 0.0, 0.0);
            path.lineTo(width - 15.0 - roundCorner / 2.0, height);
            path.arcTo(new Point2D.Double(width - 15.0, height - roundCorner / 2.0), roundCorner / 2.0, 0.0, 0.0);
            path.lineTo(width - 15.0, roundCorner / 2.0);
            path.arcTo(new Point2D.Double(width - 15.0 + roundCorner / 2.0, 0.0), roundCorner / 2.0, 0.0, 1.0);
            path.lineTo(width, 0.0);
        }
        ug.apply(new UChangeBackColor(null)).draw(path);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(25.0, 25.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, USymbolStack.this.getRectangleStencil(dim), new UStroke());
                ug = symbolContext.apply(ug);
                USymbolStack.this.drawQueue(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolStack.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolStack.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(TextBlock title, HorizontalAlignment labelAlignment, TextBlock stereotype, double width, double height, SymbolContext symbolContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }
}

