/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.DaysAsDates;
import net.sourceforge.plantuml.project3.Failable;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;

public class ComplementDates
implements ComplementPattern {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexConcat(new RegexLeaf("YEAR1" + suffix, "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH1" + suffix, "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY1" + suffix, "([\\d]{1,2})"), new RegexLeaf("[%s]+to[%s]+"), new RegexLeaf("YEAR2" + suffix, "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH2" + suffix, "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY2" + suffix, "([\\d]{1,2})"));
    }

    public Subject getSubject(GanttDiagram project, RegexResult arg) {
        DayAsDate date1 = this.getDate(arg, "1");
        DayAsDate date2 = this.getDate(arg, "2");
        return new DaysAsDates(date1, date2);
    }

    private DayAsDate getDate(RegexResult arg, String suffix) {
        int day = Integer.parseInt(arg.get("DAY" + suffix, 0));
        int month = Integer.parseInt(arg.get("MONTH" + suffix, 0));
        int year = Integer.parseInt(arg.get("YEAR" + suffix, 0));
        return DayAsDate.create(year, month, day);
    }

    @Override
    public Failable<Complement> getComplement(GanttDiagram system, RegexResult arg, String suffix) {
        int day1 = Integer.parseInt(arg.get("DAY1" + suffix, 0));
        int month1 = Integer.parseInt(arg.get("MONTH1" + suffix, 0));
        int year1 = Integer.parseInt(arg.get("YEAR1" + suffix, 0));
        DayAsDate date1 = DayAsDate.create(year1, month1, day1);
        int day2 = Integer.parseInt(arg.get("DAY2" + suffix, 0));
        int month2 = Integer.parseInt(arg.get("MONTH2" + suffix, 0));
        int year2 = Integer.parseInt(arg.get("YEAR2" + suffix, 0));
        DayAsDate date2 = DayAsDate.create(year2, month2, day2);
        return Failable.ok(new DaysAsDates(date1, date2));
    }
}

