/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.Load;
import net.sourceforge.plantuml.project3.LoadInDays;
import net.sourceforge.plantuml.project3.LoadPlanable;
import net.sourceforge.plantuml.project3.TaskAttribute;
import net.sourceforge.plantuml.project3.Value;

public class Solver3 {
    private final Map<TaskAttribute, Value> values = new LinkedHashMap<TaskAttribute, Value>();
    private final LoadPlanable loadPlanable;

    public Solver3(LoadPlanable loadPlanable) {
        this.loadPlanable = loadPlanable;
    }

    public void setData(TaskAttribute attribute, Value value) {
        Instant previousInstant;
        Value previous = this.values.remove((Object)attribute);
        if (previous != null && attribute == TaskAttribute.START && (previousInstant = (Instant)previous).compareTo((Instant)value) > 0) {
            value = previous;
        }
        this.values.put(attribute, value);
        if (this.values.size() > 2) {
            this.removeFirstElement();
        }
        assert (this.values.size() <= 2);
    }

    private void removeFirstElement() {
        Iterator<Map.Entry<TaskAttribute, Value>> it = this.values.entrySet().iterator();
        it.next();
        it.remove();
    }

    public Value getData(TaskAttribute attribute) {
        Value result = this.values.get((Object)attribute);
        if (result == null) {
            if (attribute == TaskAttribute.END) {
                return this.computeEnd();
            }
            if (attribute == TaskAttribute.START) {
                return this.computeStart();
            }
            return LoadInDays.inDay(1);
        }
        return result;
    }

    private Instant computeEnd() {
        Instant current = (Instant)this.values.get((Object)TaskAttribute.START);
        int fullLoad = ((Load)this.values.get((Object)TaskAttribute.LOAD)).getFullLoad();
        while (fullLoad > 0) {
            fullLoad -= this.loadPlanable.getLoadAt(current);
            current = current.increment();
        }
        return current.decrement();
    }

    private Instant computeStart() {
        Instant current = (Instant)this.values.get((Object)TaskAttribute.END);
        int fullLoad = ((Load)this.values.get((Object)TaskAttribute.LOAD)).getFullLoad();
        while (fullLoad > 0) {
            fullLoad -= this.loadPlanable.getLoadAt(current);
            current = current.decrement();
        }
        return current.increment();
    }
}

