/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UFontContext;

public class UFont {
    private final Font font;
    private final String family;

    public UFont(String fontFamily, int fontStyle, int fontSize) {
        this(new Font(fontFamily, fontStyle, fontSize), fontFamily);
    }

    public static UFont serif(int size) {
        return new UFont("Serif", 0, size);
    }

    public static UFont sansSerif(int size) {
        return new UFont("SansSerif", 0, size);
    }

    public static UFont courier(int size) {
        return new UFont("Courier", 0, size);
    }

    public static UFont byDefault(int size) {
        return UFont.sansSerif(12);
    }

    public UFont goTikz(int delta) {
        return new UFont(new Font("Serif", this.getStyle(), this.getSize() + delta), "Serif");
    }

    public static UFont monospaced(int size) {
        return new UFont("Monospaced", 0, size);
    }

    private UFont(Font font, String family) {
        this.font = font;
        this.family = family;
    }

    public final Font getFont() {
        return this.font;
    }

    public FontConfiguration toFont2(HtmlColor color, boolean useUnderlineForHyperlink, HtmlColor hyperlinkColor, int tabSize) {
        return new FontConfiguration(this, color, hyperlinkColor, useUnderlineForHyperlink, tabSize);
    }

    public UFont scaled(double scale) {
        if (scale == 1.0) {
            return this;
        }
        float current = this.font.getSize2D();
        return this.withSize((float)((double)current * scale));
    }

    public UFont withSize(float size) {
        return new UFont(this.font.deriveFont(size), this.family);
    }

    public UFont withStyle(int style) {
        return new UFont(this.font.deriveFont(style), this.family);
    }

    public UFont bold() {
        return this.withStyle(1);
    }

    public UFont italic() {
        return this.withStyle(2);
    }

    public int getStyle() {
        return this.font.getStyle();
    }

    public int getSize() {
        return this.font.getSize();
    }

    public double getSize2D() {
        return this.font.getSize2D();
    }

    public boolean isBold() {
        return this.font.isBold();
    }

    public boolean isItalic() {
        return this.font.isItalic();
    }

    public String getFamily(UFontContext context) {
        if (context == UFontContext.EPS) {
            if (this.family == null) {
                return "Times-Roman";
            }
            return this.font.getPSName();
        }
        if (context == UFontContext.SVG) {
            if (this.family.equalsIgnoreCase("sansserif")) {
                return "sans-serif";
            }
            return this.family;
        }
        return this.family;
    }

    public String toString() {
        return this.font.toString();
    }

    public int hashCode() {
        return this.font.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UFont)) {
            return false;
        }
        return this.font.equals(((UFont)obj).font);
    }

    @Deprecated
    public static UFont getCurrentFont(Graphics2D g2d) {
        throw new UnsupportedOperationException();
    }

    public LineMetrics getLineMetrics(Graphics2D gg, String text) {
        FontRenderContext frc = gg.getFontRenderContext();
        return this.font.getLineMetrics(text, frc);
    }

    public FontMetrics getFontMetrics() {
        return TextBlockUtils.getFontMetrics(this.getFont());
    }
}

