/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.suggest.SuggestEngineResult;
import net.sourceforge.plantuml.suggest.SuggestEngineStatus;

public class ErrorUml {
    private final String error;
    private final ErrorUmlType type;
    private SuggestEngineResult suggest;
    private final LineLocation lineLocation;

    public ErrorUml(ErrorUmlType type, String error, LineLocation lineLocation) {
        if (error == null || type == null) {
            throw new IllegalArgumentException();
        }
        this.error = error;
        this.type = type;
        this.lineLocation = lineLocation;
    }

    public boolean equals(Object obj) {
        ErrorUml this2 = (ErrorUml)obj;
        return this.type == this2.type && this.getPosition() == this2.getPosition() && this.error.equals(this2.error);
    }

    public int hashCode() {
        return this.error.hashCode() + this.type.hashCode() + this.getPosition() + (this.suggest == null ? 0 : this.suggest.hashCode());
    }

    public String toString() {
        return this.type.toString() + " " + this.getPosition() + " " + this.error + " " + this.suggest;
    }

    public final String getError() {
        return this.error;
    }

    public final ErrorUmlType getType() {
        return this.type;
    }

    public final int getPosition() {
        return this.lineLocation.getPosition();
    }

    public final LineLocation getLineLocation() {
        return this.lineLocation;
    }

    public final SuggestEngineResult getSuggest() {
        return this.suggest;
    }

    public final boolean hasSuggest() {
        return this.suggest != null && this.suggest.getStatus() == SuggestEngineStatus.ONE_SUGGESTION;
    }

    public void setSuggest(SuggestEngineResult suggest) {
        this.suggest = suggest;
    }
}

