/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.NewpagedDiagram;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShowByGender;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShowByVisibility;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandAffineTransform;
import net.sourceforge.plantuml.command.CommandAffineTransformMultiline;
import net.sourceforge.plantuml.command.CommandCaption;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandDecoratorMultine;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandFooter;
import net.sourceforge.plantuml.command.CommandHeader;
import net.sourceforge.plantuml.command.CommandHideUnlinked;
import net.sourceforge.plantuml.command.CommandMinwidth;
import net.sourceforge.plantuml.command.CommandMultilinesFooter;
import net.sourceforge.plantuml.command.CommandMultilinesHeader;
import net.sourceforge.plantuml.command.CommandMultilinesLegend;
import net.sourceforge.plantuml.command.CommandMultilinesTitle;
import net.sourceforge.plantuml.command.CommandNope;
import net.sourceforge.plantuml.command.CommandPragma;
import net.sourceforge.plantuml.command.CommandRotate;
import net.sourceforge.plantuml.command.CommandScale;
import net.sourceforge.plantuml.command.CommandScaleMaxHeight;
import net.sourceforge.plantuml.command.CommandScaleMaxWidth;
import net.sourceforge.plantuml.command.CommandScaleMaxWidthAndHeight;
import net.sourceforge.plantuml.command.CommandScaleWidthAndHeight;
import net.sourceforge.plantuml.command.CommandScaleWidthOrHeight;
import net.sourceforge.plantuml.command.CommandSkinParam;
import net.sourceforge.plantuml.command.CommandSkinParamMultilines;
import net.sourceforge.plantuml.command.CommandSpriteFile;
import net.sourceforge.plantuml.command.CommandTitle;
import net.sourceforge.plantuml.command.FactorySpriteCommand;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.suggest.SuggestEngine;
import net.sourceforge.plantuml.suggest.SuggestEngineResult;
import net.sourceforge.plantuml.suggest.SuggestEngineStatus;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class UmlDiagramFactoryOld
extends PSystemAbstractFactory {
    private final List<Command> cmds = this.createCommands();

    protected UmlDiagramFactoryOld() {
        this(DiagramType.UML);
    }

    protected UmlDiagramFactoryOld(DiagramType type) {
        super(type);
    }

    @Override
    public final Diagram createSystem(UmlSource source) {
        IteratorCounter2 it = source.iterator2();
        CharSequence2 startLine = (CharSequence2)it.next();
        if (!StartUtils.isArobaseStartDiagram(startLine)) {
            throw new UnsupportedOperationException();
        }
        if (source.isEmpty()) {
            return this.buildEmptyError(source, startLine.getLocation());
        }
        AbstractPSystem sys = this.createEmptyDiagram();
        while (it.hasNext()) {
            if (StartUtils.isArobaseEndDiagram(it.peek())) {
                if (sys == null) {
                    return null;
                }
                String err = sys.checkFinalError();
                if (err != null) {
                    return this.buildExecutionError(source, err, it.peek().getLocation());
                }
                if (source.getTotalLineCount() == 2) {
                    return this.buildEmptyError(source, it.peek().getLocation());
                }
                sys.makeDiagramReady();
                if (!sys.isOk()) {
                    return null;
                }
                sys.setSource(source);
                return sys;
            }
            if (!((sys = this.executeOneLine(sys, source, it)) instanceof PSystemError)) continue;
            return sys;
        }
        sys.setSource(source);
        return sys;
    }

    private AbstractPSystem executeOneLine(AbstractPSystem sys, UmlSource source, IteratorCounter2 it) {
        CommandControl commandControl = this.isValid2(it);
        if (commandControl == CommandControl.NOT_OK) {
            SuggestEngine engine;
            SuggestEngineResult result;
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", it.peek().getLocation());
            if (OptionFlags.getInstance().isUseSuggestEngine2() && (result = (engine = new SuggestEngine(source, this)).tryToSuggest(sys)).getStatus() == SuggestEngineStatus.ONE_SUGGESTION) {
                err.setSuggest(result);
            }
            sys = new PSystemError(source, err, null);
        } else if (commandControl == CommandControl.OK_PARTIAL) {
            IteratorCounter2 saved = it.cloneMe();
            CommandExecutionResult result = this.manageMultiline2(it, sys);
            if (!result.isOk()) {
                ErrorUml err = new ErrorUml(ErrorUmlType.EXECUTION_ERROR, result.getError(), ((CharSequence2)saved.next()).getLocation());
                sys = new PSystemError(source, err, null);
            }
        } else if (commandControl == CommandControl.OK) {
            CharSequence line = (CharSequence)it.next();
            BlocLines lines = BlocLines.single(line);
            Command cmd = this.getFirstCommandOkForLines(lines);
            CommandExecutionResult result = sys.executeCommand(cmd, lines);
            if (!result.isOk()) {
                ErrorUml err = new ErrorUml(ErrorUmlType.EXECUTION_ERROR, result.getError(), ((CharSequence2)line).getLocation());
                sys = new PSystemError(source, err, result.getDebugLines());
            }
            if (result.getNewDiagram() != null) {
                sys = result.getNewDiagram();
            }
        } else assert (false);
        return sys;
    }

    public CommandControl isValid2(IteratorCounter2 it) {
        BlocLines lines = BlocLines.single(it.peek());
        for (Command cmd : this.cmds) {
            CommandControl result = cmd.isValid(lines);
            if (result == CommandControl.OK) {
                return result;
            }
            if (result != CommandControl.OK_PARTIAL || this.isMultilineCommandOk(it.cloneMe(), cmd) == null) continue;
            return result;
        }
        return CommandControl.NOT_OK;
    }

    private boolean isNextLineBracket(IteratorCounter2 it) {
        it.next();
        return StringUtils.trin(it.peek()).equals("{");
    }

    public CommandControl goForwardMultiline(IteratorCounter2 it) {
        BlocLines lines = BlocLines.single(it.peek());
        for (Command cmd : this.cmds) {
            CommandControl result = cmd.isValid(lines);
            if (result == CommandControl.OK) {
                throw new IllegalStateException();
            }
            if (result != CommandControl.OK_PARTIAL || this.isMultilineCommandOk(it, cmd) == null) continue;
            return result;
        }
        return CommandControl.NOT_OK;
    }

    private CommandExecutionResult manageMissingBracket(IteratorCounter2 it, AbstractPSystem system) {
        for (Command cmd : this.cmds) {
            SingleLineCommand2 cmd2;
            if (!(cmd instanceof SingleLineCommand2) || !(cmd2 = (SingleLineCommand2)cmd).syntaxWithFinalBracket() || this.isMultilineBracketOk(it.cloneMe(), cmd) == null) continue;
            BlocLines lines = this.isMultilineBracketOk(it, cmd);
            if (system instanceof NewpagedDiagram) {
                NewpagedDiagram newpagedDiagram = (NewpagedDiagram)system;
                return cmd.execute(newpagedDiagram.getLastDiagram(), lines);
            }
            return cmd.execute(system, lines);
        }
        return CommandExecutionResult.error("No bracket");
    }

    private BlocLines isMultilineBracketOk(IteratorCounter2 it, Command cmd) {
        BlocLines lines = new BlocLines();
        int nb = 0;
        while (it.hasNext()) {
            CommandControl result = cmd.isValid(lines = this.addOneSingleLineManageEmbedded2(it, lines));
            if (result == CommandControl.NOT_OK) {
                return null;
            }
            if (result == CommandControl.OK) {
                return lines;
            }
            if (++nb <= 1) continue;
            return null;
        }
        return null;
    }

    private CommandExecutionResult manageMultiline2(IteratorCounter2 it, AbstractPSystem system) {
        for (Command cmd : this.cmds) {
            if (this.isMultilineCommandOk(it.cloneMe(), cmd) == null) continue;
            BlocLines lines = this.isMultilineCommandOk(it, cmd);
            if (system instanceof NewpagedDiagram) {
                NewpagedDiagram newpagedDiagram = (NewpagedDiagram)system;
                return cmd.execute(newpagedDiagram.getLastDiagram(), lines);
            }
            return cmd.execute(system, lines);
        }
        return CommandExecutionResult.ok();
    }

    private BlocLines isMultilineCommandOk(IteratorCounter2 it, Command cmd) {
        BlocLines lines = new BlocLines();
        int nb = 0;
        while (it.hasNext()) {
            CommandControl result = cmd.isValid(lines = this.addOneSingleLineManageEmbedded2(it, lines));
            if (result == CommandControl.NOT_OK) {
                return null;
            }
            if (result == CommandControl.OK) {
                return lines;
            }
            if (!(cmd instanceof CommandDecoratorMultine) || ++nb <= ((CommandDecoratorMultine)cmd).getNbMaxLines()) continue;
            return null;
        }
        return null;
    }

    private BlocLines addOneSingleLineManageEmbedded2(IteratorCounter2 it, BlocLines lines) {
        CharSequence linetoBeAdded = (CharSequence)it.next();
        lines = lines.add2(linetoBeAdded);
        if (StringUtils.trinNoTrace(linetoBeAdded).equals("{{")) {
            while (it.hasNext()) {
                CharSequence s = (CharSequence)it.next();
                lines = lines.add2(s);
                if (!StringUtils.trinNoTrace(s).equals("}}")) continue;
                return lines;
            }
        }
        return lines;
    }

    public final CommandControl isValid(BlocLines lines) {
        for (Command cmd : this.cmds) {
            CommandControl result = cmd.isValid(lines);
            if (result == CommandControl.OK) {
                return result;
            }
            if (result != CommandControl.OK_PARTIAL) continue;
            return result;
        }
        return CommandControl.NOT_OK;
    }

    private Command getFirstCommandOkForLines(BlocLines lines) {
        for (Command cmd : this.cmds) {
            CommandControl result = cmd.isValid(lines);
            if (result != CommandControl.OK) continue;
            return cmd;
        }
        throw new IllegalArgumentException();
    }

    protected abstract List<Command> createCommands();

    public abstract AbstractPSystem createEmptyDiagram();

    protected final void addCommonCommands(List<Command> cmds) {
        cmds.add(new CommandNope());
        cmds.add(new CommandPragma());
        cmds.add(new CommandTitle());
        cmds.add(new CommandCaption());
        cmds.add(new CommandMultilinesTitle());
        cmds.add(new CommandMultilinesLegend());
        cmds.add(new CommandFooter());
        cmds.add(new CommandMultilinesFooter());
        cmds.add(new CommandHeader());
        cmds.add(new CommandMultilinesHeader());
        cmds.add(new CommandSkinParam());
        cmds.add(new CommandSkinParamMultilines());
        cmds.add(new CommandMinwidth());
        cmds.add(new CommandRotate());
        cmds.add(new CommandScale());
        cmds.add(new CommandScaleWidthAndHeight());
        cmds.add(new CommandScaleWidthOrHeight());
        cmds.add(new CommandScaleMaxWidth());
        cmds.add(new CommandScaleMaxHeight());
        cmds.add(new CommandScaleMaxWidthAndHeight());
        cmds.add(new CommandAffineTransform());
        cmds.add(new CommandAffineTransformMultiline());
        cmds.add(new CommandHideUnlinked());
        FactorySpriteCommand factorySpriteCommand = new FactorySpriteCommand();
        cmds.add(factorySpriteCommand.createMultiLine(false));
        cmds.add(factorySpriteCommand.createSingleLine());
        cmds.add(new CommandSpriteFile());
        cmds.add(new CommandHideShowByVisibility());
        cmds.add(new CommandHideShowByGender());
    }

    public final List<String> getDescription() {
        ArrayList<String> result = new ArrayList<String>();
        for (Command cmd : this.createCommands()) {
            result.addAll(Arrays.asList(cmd.getDescription()));
        }
        return Collections.unmodifiableList(result);
    }
}

