/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import net.sourceforge.plantuml.version.Magic;

public class QBlock {
    private final BigInteger big;

    public static QBlock read(InputStream source, int size) throws IOException {
        byte[] block = new byte[size + 1];
        for (int i = 0; i < size; ++i) {
            int read = source.read();
            if (read == -1) {
                if (i != 0) break;
                return null;
            }
            block[i + 1] = (byte)read;
        }
        return new QBlock(new BigInteger(block));
    }

    public static QBlock fromMagic(Magic magic) {
        byte[] buffer = magic.getBuffer();
        byte[] block = new byte[buffer.length + 1];
        System.arraycopy(buffer, 0, block, 1, buffer.length);
        BigInteger big = new BigInteger(block);
        return new QBlock(big);
    }

    public Magic toMagic() {
        Magic magic = new Magic();
        magic.set(0, this.getData512());
        return magic;
    }

    public QBlock(BigInteger number) {
        this.big = number;
    }

    public QBlock change(BigInteger E, BigInteger N) {
        BigInteger changed = this.big.modPow(E, N);
        return new QBlock(changed);
    }

    private byte[] getData512() {
        byte[] nb = this.big.toByteArray();
        if (nb.length == 512) {
            return nb;
        }
        byte[] result = new byte[512];
        if (nb.length < 512) {
            System.arraycopy(nb, 0, result, 512 - nb.length, nb.length);
        } else {
            System.arraycopy(nb, nb.length - 512, result, 0, 512);
        }
        return result;
    }

    public byte[] getDataRaw() {
        return this.big.toByteArray();
    }

    public String toString() {
        return this.big.toByteArray().length + " " + this.big.toString(36);
    }

    public void write(OutputStream os, int size) throws IOException {
        int i;
        byte[] data = this.big.toByteArray();
        int start = data.length - size;
        if (start < 0) {
            for (i = 0; i < -start; ++i) {
                os.write(0);
            }
        }
        for (i = Math.max(start, 0); i < data.length; ++i) {
            byte b = data[i];
            os.write(b);
        }
    }
}

