/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.PaddingParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Englober {
    private final ParticipantEnglober participantEnglober;
    private final List<Participant> participants = new ArrayList<Participant>();
    private final TileArguments tileArguments;
    private final Real core1;
    private final Real core2;
    private final boolean isTeoz;
    private double marginX = 0.0;

    public static Englober createPuma(ParticipantEnglober englober, Participant first, ISkinParam skinParam, Skin skin, StringBounder stringBounder) {
        return new Englober(englober, first, Englober.convertFunctionToBeRemoved(skinParam, skin, stringBounder), false);
    }

    public static Englober createTeoz(ParticipantEnglober participantEnglober, Participant first, TileArguments tileArguments) {
        return new Englober(participantEnglober, first, tileArguments, true);
    }

    private static TileArguments convertFunctionToBeRemoved(ISkinParam skinParam, Skin skin, StringBounder stringBounder) {
        TileArguments result = new TileArguments(stringBounder, null, skin, skinParam, null);
        return result;
    }

    private Englober(ParticipantEnglober participantEnglober, Participant first, TileArguments tileArguments, boolean isTeoz) {
        if (tileArguments == null) {
            throw new IllegalArgumentException();
        }
        this.isTeoz = isTeoz;
        this.participantEnglober = participantEnglober;
        this.participants.add(first);
        this.tileArguments = tileArguments;
        double preferredWidth = this.getPreferredWidth();
        if (tileArguments.getLivingSpaces() == null) {
            this.core1 = null;
            this.core2 = null;
        } else {
            this.core1 = this.getMiddle().addFixed(-preferredWidth / 2.0);
            this.core2 = this.getMiddle().addFixed(preferredWidth / 2.0);
        }
    }

    public final Participant getFirst2TOBEPRIVATE() {
        return this.participants.get(0);
    }

    public final Participant getLast2TOBEPRIVATE() {
        return this.participants.get(this.participants.size() - 1);
    }

    private Real getMiddle() {
        return RealUtils.middle(this.getPosB(), this.getPosD());
    }

    private Real getPosB() {
        return this.getFirstLivingSpace().getPosB();
    }

    private Real getPosD() {
        return this.getLastLivingSpace().getPosD(this.tileArguments.getStringBounder());
    }

    private Real getPosAA() {
        LivingSpace previous = this.tileArguments.getLivingSpaces().previous(this.getFirstLivingSpace());
        if (previous == null) {
            return this.tileArguments.getOrigin();
        }
        return previous.getPosD(this.tileArguments.getStringBounder());
    }

    private Real getPosZZ() {
        LivingSpace next = this.tileArguments.getLivingSpaces().next(this.getLastLivingSpace());
        if (next == null) {
            return null;
        }
        return next.getPosB();
    }

    private LivingSpace getFirstLivingSpace() {
        return this.tileArguments.getLivingSpace(this.getFirst2TOBEPRIVATE());
    }

    private LivingSpace getLastLivingSpace() {
        return this.tileArguments.getLivingSpace(this.getLast2TOBEPRIVATE());
    }

    private Component getComponent() {
        ParticipantEnglober englober = this.getParticipantEnglober();
        ISkinParam s = englober.getBoxColor() == null ? this.tileArguments.getSkinParam() : new SkinParamBackcolored(this.tileArguments.getSkinParam(), englober.getBoxColor());
        return this.tileArguments.getSkin().createComponent(ComponentType.ENGLOBER, null, s, englober.getTitle());
    }

    public final ParticipantEnglober getParticipantEnglober() {
        return this.participantEnglober;
    }

    public boolean contains(Participant p) {
        return this.participants.contains(p);
    }

    public void add(Participant p) {
        if (this.participants.contains(p)) {
            throw new IllegalArgumentException();
        }
        this.participants.add(p);
    }

    public String toString() {
        return "ParticipantEngloberContexted:" + this.participantEnglober.getTitle().toString() + " " + this.participants;
    }

    private double getPreferredWidth() {
        if (this.isTeoz) {
            return 10.0;
        }
        return this.getTitleWidth();
    }

    private double getTitleWidth() {
        return this.getComponent().getPreferredWidth(this.tileArguments.getStringBounder());
    }

    public double getPreferredHeight() {
        Component comp = this.tileArguments.getSkin().createComponent(ComponentType.ENGLOBER, null, this.tileArguments.getSkinParam(), this.getParticipantEnglober().getTitle());
        return comp.getPreferredHeight(this.tileArguments.getStringBounder());
    }

    public void drawEnglober(UGraphic ug, double height, Context2D context) {
        double x1 = this.getX1().getCurrentValue() - 4.0;
        double x2 = this.getX2().getCurrentValue() + 4.0;
        Dimension2DDouble dim = new Dimension2DDouble(x2 - x1, height);
        this.getComponent().drawU(ug.apply(new UTranslate(x1, 1.0)), new Area(dim), context);
    }

    private Real getX2() {
        return RealUtils.max(this.getPosD(), this.core2).addFixed(this.marginX);
    }

    private Real getX1() {
        return RealUtils.min(this.getPosB(), this.core1).addFixed(-this.marginX);
    }

    public void addInternalConstraints() {
        assert (this.isTeoz);
        double titleWidth = this.getTitleWidth();
        double x1 = this.getX1().getCurrentValue();
        double x2 = this.getX2().getCurrentValue();
        double actualWidth = x2 - x1;
        if (titleWidth > actualWidth + 20.0) {
            this.marginX = (titleWidth - actualWidth - 20.0) / 2.0;
        }
        this.getX1().ensureBiggerThan(this.getPosAA().addFixed(10.0 + this.padding()));
        Real posZZ = this.getPosZZ();
        Real limit = this.getX2().addFixed(10.0 + this.padding());
        if (posZZ != null) {
            posZZ.ensureBiggerThan(limit);
        }
    }

    private double padding() {
        return this.tileArguments.getSkinParam().getPadding(PaddingParam.BOX);
    }

    public void addConstraintAfter(Englober current) {
        current.getX1().ensureBiggerThan(this.getX2().addFixed(10.0 + 2.0 * this.padding()));
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.getX1();
    }

    public Real getMaxX(StringBounder stringBounder) {
        return this.getX2().addFixed(10.0);
    }
}

