/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public abstract class AbstractComponent
implements Component {
    private final Style style;

    @Override
    public final Style[] getUsedStyles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StyleSignatureBasic getStyleSignature() {
        throw new UnsupportedOperationException();
    }

    public AbstractComponent(Style style) {
        this.style = style;
    }

    protected final Style getStyle() {
        return this.style;
    }

    protected abstract void drawInternalU(UGraphic var1, Area var2);

    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
    }

    @Override
    public final void drawU(UGraphic ug, Area area, Context2D context) {
        ug = ug.apply(new UTranslate(this.getPaddingX(), this.getPaddingY()));
        if (context.isBackground()) {
            this.drawBackgroundInternalU(ug, area);
        } else {
            this.drawInternalU(ug, area);
        }
    }

    public double getPaddingX() {
        return 0.0;
    }

    public double getPaddingY() {
        return 0.0;
    }

    @Override
    public abstract double getPreferredWidth(StringBounder var1);

    @Override
    public abstract double getPreferredHeight(StringBounder var1);

    @Override
    public final XDimension2D getPreferredDimension(StringBounder stringBounder) {
        double w = this.getPreferredWidth(stringBounder);
        double h = this.getPreferredHeight(stringBounder);
        return new XDimension2D(w, h);
    }
}

